/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.hibernate.processor.annotation.AbstractCriteriaMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;

public class CriteriaDeleteMethod
extends AbstractCriteriaMethod {
    private final List<Boolean> paramNullability;

    CriteriaDeleteMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String methodName, String entity, List<String> paramNames, List<String> paramTypes, List<Boolean> paramNullability, List<Boolean> multivalued, List<Boolean> paramPatterns, boolean belongsToDao, String sessionType, String sessionName, boolean addNonnullAnnotation, boolean dataRepository, String fullReturnType) {
        super(annotationMetaEntity, method, methodName, entity, null, belongsToDao, sessionType, sessionName, Collections.emptyList(), paramNames, paramTypes, Collections.emptyList(), addNonnullAnnotation, dataRepository, multivalued, paramPatterns, fullReturnType, false);
        this.paramNullability = paramNullability;
    }

    @Override
    public boolean isNullable(int index) {
        return this.paramNullability.get(index);
    }

    @Override
    boolean singleResult() {
        return true;
    }

    @Override
    void executeQuery(StringBuilder declaration, List<String> paramTypes) {
        this.createSpecification(declaration);
        this.handleRestrictionParameters(declaration, paramTypes);
        this.tryReturn(declaration);
        this.createQuery(declaration, false);
        this.execute(declaration);
    }

    @Override
    void tryReturn(StringBuilder declaration) {
        if (!this.isReactive()) {
            declaration.append("\n\ttry {\n\t\t");
        }
        if (!"void".equals(this.fullReturnType)) {
            declaration.append("return ");
        }
    }

    @Override
    String createQueryMethod() {
        return this.isUsingEntityManager() ? "createQuery" : "createMutationQuery";
    }

    @Override
    String specificationType() {
        return "org.hibernate.query.specification.MutationSpecification";
    }

    private void execute(StringBuilder declaration) {
        declaration.append("\t\t\t.executeUpdate()");
        if (this.isReactive()) {
            if (this.fullReturnType.endsWith("<java.lang.Void>")) {
                // empty if block
            }
            declaration.append(".replaceWithVoid()");
        }
    }

    @Override
    String createCriteriaMethod() {
        return "createCriteriaDelete";
    }
}

