/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.NameMetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;

class TypedMetaAttribute
extends NameMetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized String prefix;
    private final @UnknownKeyFor @NonNull @Initialized String resultType;
    private final @UnknownKeyFor @NonNull @Initialized String referenceType;
    private final @Nullable @UnknownKeyFor @Initialized String query;

    public TypedMetaAttribute(@UnknownKeyFor @NonNull @Initialized Metamodel annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized String resultType, @UnknownKeyFor @NonNull @Initialized String referenceType, @Nullable @UnknownKeyFor @Initialized String query) {
        super(annotationMetaEntity, name, prefix);
        this.prefix = prefix;
        this.resultType = resultType;
        this.referenceType = referenceType;
        this.query = query;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isQuery() {
        return "QUERY_".equals(this.prefix);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append("\n/**\n * @see ").append("#");
        this.appendFieldName(declaration, this.isQuery());
        return declaration.append("\n **/\n").append(super.getAttributeNameDeclarationString()).toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        boolean isQuery = this.isQuery();
        Metamodel entity = this.getHostingEntity();
        StringBuilder declaration = new StringBuilder();
        declaration.append("\n/**").append("\n * The ").append(isQuery ? "query" : "entity graph").append(" named {@value ").append(this.prefix).append(this.fieldName()).append("}\n");
        if (this.query != null) {
            declaration.append(" * <pre>");
            this.query.lines().forEach(line -> declaration.append("\n * ").append((String)line));
            declaration.append("\n * </pre>\n");
        }
        declaration.append(" *\n * @see ").append(entity.getQualifiedName()).append("\n **/\n").append("public static volatile ").append(entity.importType(this.referenceType)).append('<').append(entity.importType(this.resultType)).append('>').append(' ');
        this.appendFieldName(declaration, isQuery);
        declaration.append(';');
        return declaration.toString();
    }

    private void appendFieldName(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized boolean isQuery) {
        declaration.append('_').append(StringUtil.nameToMethodName(this.getPropertyName()));
        if (isQuery) {
            declaration.append('_');
        }
    }
}

