/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import javax.lang.model.element.Element;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;

public abstract class AnnotationMetaAttribute
implements MetaAttribute {
    final @UnknownKeyFor @NonNull @Initialized Element element;
    final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity parent;
    private final @UnknownKeyFor @NonNull @Initialized String type;

    public AnnotationMetaAttribute(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity parent, @UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String type) {
        this.element = element;
        this.parent = parent;
        this.type = type;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        return "\n/**\n * Static metamodel for attribute {@link " + this.parent.getQualifiedName() + '#' + this.element.getSimpleName() + "}\n **/\n" + "public static volatile " + this.parent.importType(this.getMetaType()) + '<' + this.parent.importType(this.parent.getQualifiedName()) + ", " + this.parent.importType(this.getTypeDeclaration()) + '>' + ' ' + this.getPropertyName() + ';';
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        return "\n/**\n * @see " + "#" + this.getPropertyName() + "\n **/\n" + "public static final " + this.parent.importType("java.lang.String") + ' ' + StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.getPropertyName()) + " = " + '\"' + this.getPropertyName() + '\"' + ';';
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return TypeUtils.propertyName(this.element);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.parent;
    }

    @Override
    public abstract @UnknownKeyFor @NonNull @Initialized String getMetaType();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.type;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "AnnotationMetaAttribute" + "{element=" + this.element + ", type='" + this.type + '\'' + '}';
    }
}

