/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import jakarta.persistence.AccessType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.internal.ShortNameImplicitDiscriminatorStrategy;
import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.internal.DiscriminatorTypeImpl;
import org.hibernate.metamodel.mapping.internal.UnifiedAnyDiscriminatorConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.ImplicitDiscriminatorStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.processor.validation.MockSessionFactory;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public abstract class MockEntityPersister
implements EntityPersister,
Joinable {
    private static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] ID_COLUMN = new String[]{"id"};
    private final @UnknownKeyFor @NonNull @Initialized String entityName;
    private final @UnknownKeyFor @NonNull @Initialized MockSessionFactory factory;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MockEntityPersister> subclassPersisters = new ArrayList<MockEntityPersister>();
    final @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Type> propertyTypesByName = new HashMap<String, Type>();

    public MockEntityPersister(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized MockSessionFactory factory) {
        this.entityName = entityName;
        this.factory = factory;
        this.defaultAccessType = defaultAccessType;
    }

    void initSubclassPersisters() {
        for (MockEntityPersister other : this.factory.getMockEntityPersisters()) {
            other.addPersister(this);
            this.addPersister(other);
        }
    }

    private void addPersister(@UnknownKeyFor @NonNull @Initialized MockEntityPersister entityPersister) {
        if (this.isSubclassPersister(entityPersister)) {
            this.subclassPersisters.add(entityPersister);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Type getSubclassPropertyType(@UnknownKeyFor @NonNull @Initialized String propertyPath) {
        return this.subclassPersisters.stream().map(sp -> sp.getPropertyType(propertyPath)).filter(Objects::nonNull).findAny().orElse(null);
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean isSamePersister(@UnknownKeyFor @NonNull @Initialized MockEntityPersister var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isSubclassPersister(@UnknownKeyFor @NonNull @Initialized MockEntityPersister var1);

    public @UnknownKeyFor @NonNull @Initialized boolean isSubclassEntityName(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.isSubclassPersister(this.subclassPersisters.stream().filter(persister -> persister.entityName.equals(name)).findFirst().orElseThrow());
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public @UnknownKeyFor @NonNull @Initialized EntityMetamodel getEntityMetamodel() {
        throw new UnsupportedOperationException("operation not supported");
    }

    public @UnknownKeyFor @NonNull @Initialized String getEntityName() {
        return this.entityName;
    }

    public final @UnknownKeyFor @NonNull @Initialized Type getPropertyType(@UnknownKeyFor @NonNull @Initialized String propertyPath) {
        Type cached = this.propertyTypesByName.get(propertyPath);
        if (cached == null) {
            Type type = this.propertyType(propertyPath);
            if (type != null) {
                this.propertyTypesByName.put(propertyPath, type);
            }
            return type;
        }
        return cached;
    }

    private @UnknownKeyFor @NonNull @Initialized Type propertyType(@UnknownKeyFor @NonNull @Initialized String propertyPath) {
        Type type = this.createPropertyType(propertyPath);
        if (type != null) {
            return type;
        }
        Type typeFromSubclass = this.getSubclassPropertyType(propertyPath);
        if (typeFromSubclass != null) {
            return typeFromSubclass;
        }
        if ("id".equals(propertyPath)) {
            return this.identifierType();
        }
        return null;
    }

    abstract @UnknownKeyFor @NonNull @Initialized Type createPropertyType(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized String getIdentifierPropertyName() {
        return this.getRootEntityPersister().identifierPropertyName();
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized String identifierPropertyName();

    public @UnknownKeyFor @NonNull @Initialized Type getIdentifierType() {
        return this.getRootEntityPersister().identifierType();
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized Type identifierType();

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BasicType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getVersionType() {
        return this.getRootEntityPersister().versionType();
    }

    protected abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BasicType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> versionType();

    public abstract @UnknownKeyFor @NonNull @Initialized String getRootEntityName();

    public @UnknownKeyFor @NonNull @Initialized MockEntityPersister getRootEntityPersister() {
        return this.factory.createMockEntityPersister(this.getRootEntityName());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubclassEntityNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(this.entityName);
        for (MockEntityPersister persister : this.factory.getMockEntityPersisters()) {
            if (!persister.isSubclassPersister(this)) continue;
            names.add(persister.entityName);
        }
        return names;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] toColumns(@UnknownKeyFor @NonNull @Initialized String propertyName) {
        return new String[]{""};
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getPropertySpaces() {
        return new String[]{this.entityName};
    }

    public @UnknownKeyFor @NonNull @Initialized Serializable @UnknownKeyFor @NonNull @Initialized [] getQuerySpaces() {
        return new Serializable[]{this.entityName};
    }

    public @UnknownKeyFor @NonNull @Initialized EntityPersister getEntityPersister() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getIdentifierColumnNames() {
        return ID_COLUMN;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DiscriminatorType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDiscriminatorDomainType() {
        BasicType<String> type = this.getDiscriminatorType();
        return new DiscriminatorTypeImpl(type, (DiscriminatorConverter)new UnifiedAnyDiscriminatorConverter(new NavigableRole(this.entityName).append("{discriminator}"), type.getJavaTypeDescriptor(), type.getRelationalJavaType(), Collections.emptyMap(), (ImplicitDiscriminatorStrategy)ShortNameImplicitDiscriminatorStrategy.SHORT_NAME_STRATEGY, this.factory.getMetamodel()));
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableName() {
        return this.entityName;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "MockEntityPersister[" + this.entityName + "]";
    }

    public @UnknownKeyFor @NonNull @Initialized int getVersionProperty() {
        return 0;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isVersioned() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized String getMappedSuperclass() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized BasicType<@UnknownKeyFor @NonNull @Initialized String> getDiscriminatorType() {
        return this.factory.getTypeConfiguration().getBasicTypeForJavaType(String.class);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isMutable() {
        return true;
    }
}

