/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;

public class RepositoryConstructor
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity;
    private final @UnknownKeyFor @NonNull @Initialized String constructorName;
    private final @UnknownKeyFor @NonNull @Initialized String methodName;
    private final @UnknownKeyFor @NonNull @Initialized String sessionTypeName;
    private final @UnknownKeyFor @NonNull @Initialized String sessionVariableName;
    private final @Nullable @UnknownKeyFor @Initialized String dataStore;
    private final @UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation;
    private final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;
    private final @UnknownKeyFor @NonNull @Initialized boolean addOverrideAnnotation;
    private final @UnknownKeyFor @NonNull @Initialized boolean dataRepository;
    private final @UnknownKeyFor @NonNull @Initialized boolean quarkusInjection;

    public RepositoryConstructor(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String constructorName, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String sessionTypeName, @UnknownKeyFor @NonNull @Initialized String sessionVariableName, @Nullable @UnknownKeyFor @Initialized String dataStore, @UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean addOverrideAnnotation, @UnknownKeyFor @NonNull @Initialized boolean dataRepository, @UnknownKeyFor @NonNull @Initialized boolean quarkusInjection) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.constructorName = constructorName;
        this.methodName = methodName;
        this.sessionTypeName = sessionTypeName;
        this.sessionVariableName = sessionVariableName;
        this.dataStore = dataStore;
        this.addInjectAnnotation = addInjectAnnotation;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.addOverrideAnnotation = addOverrideAnnotation;
        this.dataRepository = dataRepository;
        this.quarkusInjection = quarkusInjection;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append('\n');
        if (this.annotationMetaEntity.getSuperTypeElement() == null) {
            declaration.append("protected ");
            if (!this.dataRepository) {
                declaration.append("final ");
            }
            this.notNull(declaration);
            declaration.append(this.annotationMetaEntity.importType(this.sessionTypeName)).append(" ").append(this.sessionVariableName).append(";\n\n");
        }
        this.inject(declaration);
        declaration.append("public ").append(this.constructorName).append("(");
        this.notNull(declaration);
        this.qualifier(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.sessionTypeName)).append(" ").append(this.sessionVariableName).append(") {\n");
        if (this.annotationMetaEntity.getSuperTypeElement() != null) {
            declaration.append("\tsuper(").append(this.sessionVariableName).append(");\n");
        } else {
            declaration.append("\tthis.").append(this.sessionVariableName).append(" = ").append(this.sessionVariableName).append(";\n");
        }
        declaration.append("}");
        if (this.annotationMetaEntity.getSuperTypeElement() == null) {
            declaration.append("\n\n");
            if (this.addOverrideAnnotation) {
                declaration.append("@Override\n");
            }
            declaration.append("public ");
            this.notNull(declaration);
            declaration.append(this.annotationMetaEntity.importType(this.sessionTypeName)).append(" ").append(this.methodName).append("() {").append("\n\treturn ").append(this.sessionVariableName).append(";\n}");
        }
        return declaration.toString();
    }

    private void qualifier(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addInjectAnnotation && this.quarkusInjection && this.dataStore != null) {
            declaration.append('@').append(this.annotationMetaEntity.importType("io.quarkus.hibernate.orm.PersistenceUnit")).append("(\"").append(this.dataStore).append("\") ");
        }
    }

    private void inject(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addInjectAnnotation && !this.annotationMetaEntity.needsDefaultConstructor()) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.inject.Inject")).append('\n');
        }
    }

    private void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return "jakarta.persistence.EntityManager";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

