/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AbstractAnnotatedMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;

public class LifecycleMethod
extends AbstractAnnotatedMethod {
    private final @UnknownKeyFor @NonNull @Initialized String entity;
    private final @UnknownKeyFor @NonNull @Initialized String actualEntity;
    private final @UnknownKeyFor @NonNull @Initialized String methodName;
    private final @UnknownKeyFor @NonNull @Initialized String parameterName;
    private final @UnknownKeyFor @NonNull @Initialized String operationName;
    private final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;
    private final @UnknownKeyFor @NonNull @Initialized ParameterKind parameterKind;
    private final @UnknownKeyFor @NonNull @Initialized boolean returnArgument;
    private final @UnknownKeyFor @NonNull @Initialized boolean hasGeneratedId;
    static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> eventTypes = Set.of("insert", "update", "delete");

    public LifecycleMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized String actualEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String parameterName, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String operationName, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized ParameterKind parameterKind, @UnknownKeyFor @NonNull @Initialized boolean returnArgument, @UnknownKeyFor @NonNull @Initialized boolean hasGeneratedId) {
        super(annotationMetaEntity, method, sessionName, sessionType);
        this.entity = entity;
        this.actualEntity = actualEntity;
        this.methodName = methodName;
        this.parameterName = parameterName;
        this.operationName = operationName;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.parameterKind = parameterKind;
        this.returnArgument = returnArgument;
        this.hasGeneratedId = hasGeneratedId;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized String capitalize(@UnknownKeyFor @NonNull @Initialized String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.preamble(declaration);
        this.nullCheck(declaration, this.parameterName);
        this.fireEvents(declaration, "Pre");
        if (!this.isReactive()) {
            declaration.append("\ttry {\n");
        }
        this.delegateCall(declaration);
        this.returnArgumentReactively(declaration);
        if (!this.isReactive()) {
            declaration.append("\t}\n");
        }
        this.convertExceptions(declaration);
        if (this.isReactive()) {
            declaration.append(";\n");
        }
        this.fireEvents(declaration, "Post");
        this.returnArgument(declaration);
        declaration.append("}");
        return declaration.toString();
    }

    private void fireEvents(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String prefix) {
        if (this.annotationMetaEntity.getContext().isDataEventPackageAvailable() && this.annotationMetaEntity.getContext().addDependentAnnotation() && eventTypes.contains(this.operationName) && !this.isReactive()) {
            String entityName = this.iterateEvents(declaration);
            this.fireEvent(declaration, entityName, prefix + this.capitalize(this.operationName) + "Event");
            this.endIterateEvents(declaration);
        }
    }

    private void fireEvent(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String eventType) {
        this.annotationMetaEntity.importType("jakarta.data.event.LifecycleEvent");
        this.annotationMetaEntity.importType("jakarta.enterprise.util.TypeLiteral");
        this.annotationMetaEntity.importType("jakarta.enterprise.event.Event");
        this.annotationMetaEntity.importType("jakarta.inject.Inject");
        this.annotationMetaEntity.importType("jakarta.data.event." + eventType);
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\t");
        }
        declaration.append("\tif (event != null) {\n");
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\t");
        }
        declaration.append("\t\tevent.select(new TypeLiteral<").append(eventType).append("<").append(this.annotationMetaEntity.importType(this.actualEntity)).append(">>(){})\n\t\t\t\t.fire(new ").append(eventType).append("<>(").append(entityName).append("));\n");
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\t");
        }
        declaration.append("\t}\n");
    }

    private void endIterateEvents(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\t}\n");
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String iterateEvents(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\tfor (var _entity : ").append(this.parameterName).append(") {\n");
            return "_entity";
        }
        return this.parameterName;
    }

    private void returnArgument(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.returnArgument && !this.isReactive()) {
            declaration.append("\treturn ").append(this.parameterName).append(";\n");
        }
    }

    private void returnArgumentReactively(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isReactive() && this.returnArgument) {
            declaration.append("\n\t\t\t.replaceWith(").append(this.parameterName).append(")");
        }
    }

    private void convertExceptions(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.operationName.equals("insert")) {
            this.handle(declaration, "org.hibernate.exception.ConstraintViolationException", "jakarta.data.exceptions.EntityExistsException");
        } else {
            this.handle(declaration, "org.hibernate.StaleStateException", "jakarta.data.exceptions.OptimisticLockingFailureException");
        }
        this.handle(declaration, "jakarta.persistence.PersistenceException", "jakarta.data.exceptions.DataException");
    }

    private void delegateCall(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isReactive()) {
            this.delegateReactively(declaration);
        } else {
            this.delegateBlockingly(declaration);
        }
    }

    private void delegateBlockingly(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isGeneratedIdUpsert()) {
            declaration.append("\t\tif (").append(this.sessionName).append(".getIdentifier(").append(this.parameterName).append(") == null)\n").append("\t\t\t").append(this.sessionName).append('.').append("insert");
            this.argument(declaration);
            declaration.append(";\n").append("\t\telse\n\t");
        }
        declaration.append("\t\t").append(this.sessionName).append('.').append(this.operationName);
        this.argument(declaration);
        declaration.append(";\n");
    }

    private void argument(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        switch (this.parameterKind) {
            case LIST: {
                if (this.isReactive()) {
                    declaration.append("All").append("(").append(this.parameterName).append(".toArray()").append(")");
                    break;
                }
                declaration.append("Multiple").append("(").append(this.parameterName).append(")");
                break;
            }
            case ARRAY: {
                if (this.isReactive()) {
                    declaration.append("All").append("((Object[]) ").append(this.parameterName).append(")");
                    break;
                }
                declaration.append("Multiple").append("(").append(this.annotationMetaEntity.importType("java.util.List")).append(".of(").append(this.parameterName).append("))");
                break;
            }
            default: {
                declaration.append('(').append(this.parameterName).append(')');
            }
        }
    }

    private void delegateReactively(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\treturn ");
        if (this.isReactiveSessionAccess()) {
            declaration.append(this.sessionName).append(".chain(").append(this.localSessionName()).append(" -> ");
        }
        if (this.isGeneratedIdUpsert()) {
            declaration.append("(").append(this.localSessionName()).append(".getIdentifier(").append(this.parameterName).append(") == null ? ").append(this.localSessionName()).append('.').append("insert").append('(').append(this.parameterName).append(')').append(" : ");
        }
        declaration.append(this.localSessionName()).append('.').append(this.operationName);
        this.argument(declaration);
        if (this.isGeneratedIdUpsert()) {
            declaration.append(')');
        }
        if (this.isReactiveSessionAccess()) {
            declaration.append(')');
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isGeneratedIdUpsert() {
        return "upsert".equals(this.operationName) && this.hasGeneratedId;
    }

    private void preamble(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n@Override\npublic ").append(this.returnType()).append(' ').append(this.methodName).append('(');
        this.notNull(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.entity)).append(' ').append(this.parameterName).append(')').append(" {\n");
    }

    private @UnknownKeyFor @NonNull @Initialized String returnType() {
        String entityType = this.annotationMetaEntity.importType(this.entity);
        if (this.isReactive()) {
            return this.annotationMetaEntity.importType("io.smallrye.mutiny.Uni") + "<" + (this.returnArgument ? entityType : "Void") + ">";
        }
        return this.returnArgument ? entityType : "void";
    }

    private void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.entity;
    }

    public static enum ParameterKind {
        NORMAL,
        ARRAY,
        LIST;

    }
}

