/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.NameMetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;

class EnabledFetchProfileMetaAttribute
extends NameMetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized String prefix;
    private final @UnknownKeyFor @NonNull @Initialized String referenceType;

    public EnabledFetchProfileMetaAttribute(@UnknownKeyFor @NonNull @Initialized Metamodel annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized String referenceType) {
        super(annotationMetaEntity, name, prefix);
        this.prefix = prefix;
        this.referenceType = referenceType;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append("\n/**\n * @see ").append("#");
        this.appendFieldName(declaration);
        return declaration.append("\n **/\n").append(super.getAttributeNameDeclarationString()).toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        Metamodel entity = this.getHostingEntity();
        StringBuilder declaration = new StringBuilder();
        declaration.append("\n/**").append("\n * The fetch profile named {@value ").append(this.prefix).append(this.fieldName()).append("}\n").append(" *\n * @see ").append(entity.getQualifiedName()).append("\n **/\n").append("public static final ").append(entity.importType(this.referenceType)).append(' ');
        this.appendFieldName(declaration);
        declaration.append(" = new ").append(entity.importType(this.referenceType)).append("(").append(this.prefix).append(this.fieldName()).append(");");
        return declaration.toString();
    }

    private void appendFieldName(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append('_').append(StringUtil.nameToMethodName(this.getPropertyName()));
    }
}

