/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import jakarta.persistence.metamodel.Bindable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.MappingException;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.internal.DefaultCustomEntityDirtinessStrategy;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.internal.StandardEntityNotFoundDelegate;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DisabledCaching;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.query.internal.NativeQueryInterpreterStandardImpl;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.jpa.internal.MutableJpaComplianceImpl;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.jpa.spi.MutableJpaCompliance;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.JpaMetamodelPopulationSetting;
import org.hibernate.metamodel.internal.JpaStaticMetamodelPopulationSetting;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractPluralAttribute;
import org.hibernate.metamodel.model.domain.internal.BagAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.BasicTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.JpaMetamodelImpl;
import org.hibernate.metamodel.model.domain.internal.ListAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.MapAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappingMetamodelImpl;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.metamodel.model.domain.internal.SetAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.SingularAttributeImpl;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.processor.validation.MockCollectionPersister;
import org.hibernate.processor.validation.MockEntityPersister;
import org.hibernate.processor.validation.MockJdbcServicesInitiator;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.BindingContext;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.StandardHqlTranslator;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.internal.NamedObjectRepositoryImpl;
import org.hibernate.query.internal.QueryInterpretationCacheDisabledImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.spi.ImmutableEntityUpdateQueryHandlingMode;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryEngineOptions;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sql.internal.SqlTranslationEngineImpl;
import org.hibernate.query.sql.spi.SqlTranslationEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddableDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmSingularPersistentAttribute;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.internal.StatisticsImpl;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BagType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.ListType;
import org.hibernate.type.MapType;
import org.hibernate.type.SetType;
import org.hibernate.type.TimeZoneStorageStrategy;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class MockSessionFactory
implements SessionFactoryImplementor,
SessionFactoryOptions,
QueryEngine,
FunctionContributions,
MetadataBuildingOptions,
MetadataBuildingContext,
RuntimeModelCreationContext,
BootstrapContext,
JdbcTypeIndicators,
RuntimeMetamodelsImplementor {
    private static final @UnknownKeyFor @NonNull @Initialized BasicTypeImpl<@UnknownKeyFor @NonNull @Initialized Object> OBJECT_BASIC_TYPE = new BasicTypeImpl((JavaType)new UnknownBasicJavaType(Object.class), (JdbcType)ObjectJdbcType.INSTANCE);
    private final @UnknownKeyFor @NonNull @Initialized TypeConfiguration typeConfiguration;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MockEntityPersister> entityPersistersByName = new HashMap<String, MockEntityPersister>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MockCollectionPersister> collectionPersistersByName = new HashMap<String, MockCollectionPersister>();
    private final @UnknownKeyFor @NonNull @Initialized StandardServiceRegistryImpl serviceRegistry;
    private final @UnknownKeyFor @NonNull @Initialized SqmFunctionRegistry functionRegistry;
    private final @UnknownKeyFor @NonNull @Initialized MappingMetamodelImpl metamodel;
    private final @UnknownKeyFor @NonNull @Initialized MetadataImplementor bootModel;
    private final @UnknownKeyFor @NonNull @Initialized MetadataContext metadataContext;
    private final @UnknownKeyFor @NonNull @Initialized NodeBuilder nodeBuilder;
    private final @UnknownKeyFor @NonNull @Initialized SqlTranslationEngine sqlTranslationEngine;
    private final @UnknownKeyFor @NonNull @Initialized ClassLoaderServiceImpl classLoaderService = new ClassLoaderServiceImpl(){

        public Class<?> classForName(String className) {
            try {
                return super.classForName(className);
            }
            catch (ClassLoadingException e) {
                if (MockSessionFactory.this.isClassDefined(className)) {
                    return Object[].class;
                }
                throw e;
            }
        }
    };
    private static final @UnknownKeyFor @NonNull @Initialized SessionFactoryObserver @UnknownKeyFor @NonNull @Initialized [] NO_OBSERVERS = new SessionFactoryObserver[0];
    private static final @UnknownKeyFor @NonNull @Initialized EntityNameResolver @UnknownKeyFor @NonNull @Initialized [] NO_RESOLVERS = new EntityNameResolver[0];
    static @UnknownKeyFor @NonNull @Initialized MutableJpaCompliance jpaCompliance = new MutableJpaComplianceImpl(Collections.emptyMap());

    public MockSessionFactory() {
        this.serviceRegistry = StandardServiceRegistryImpl.create((BootstrapServiceRegistry)new BootstrapServiceRegistryImpl(true, (ClassLoaderService)this.classLoaderService, (StrategySelector)new StrategySelectorImpl((ClassLoaderService)this.classLoaderService), (IntegratorService & Serializable)() -> Collections.emptyList()), Collections.singletonList(MockJdbcServicesInitiator.INSTANCE), Collections.emptyList(), Collections.emptyMap());
        this.functionRegistry = new SqmFunctionRegistry();
        this.metamodel = new MockMappingMetamodelImpl();
        this.bootModel = new MetadataImpl(UUID.randomUUID(), (MetadataBuildingOptions)this, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), new Database((MetadataBuildingOptions)this, MockJdbcServicesInitiator.jdbcServices.getJdbcEnvironment()), (BootstrapContext)this);
        this.metadataContext = new MetadataContext(this.metamodel.getJpaMetamodel(), (MappingMetamodel)this.metamodel, this.bootModel, JpaStaticMetamodelPopulationSetting.DISABLED, JpaMetamodelPopulationSetting.DISABLED, (RuntimeModelCreationContext)this, (ClassLoaderService)this.classLoaderService);
        this.typeConfiguration = new TypeConfiguration();
        this.typeConfiguration.scope((MetadataBuildingContext)this);
        MockJdbcServicesInitiator.genericDialect.initializeFunctionRegistry((FunctionContributions)this);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory((FunctionContributions)this);
        functionFactory.listagg(null);
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.windowFunctions();
        this.typeConfiguration.scope((SessionFactoryImplementor)this);
        this.nodeBuilder = new SqmCriteriaNodeBuilder("", "", (QueryEngine)this, (QueryEngineOptions)this, (BindingContext)this);
        this.sqlTranslationEngine = new SqlTranslationEngineImpl((SessionFactoryImplementor)this, this.typeConfiguration, Collections.emptyMap());
    }

    public @UnknownKeyFor @NonNull @Initialized TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public @UnknownKeyFor @NonNull @Initialized ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    public void addObserver(@UnknownKeyFor @NonNull @Initialized SessionFactoryObserver observer) {
    }

    public @UnknownKeyFor @NonNull @Initialized MetadataBuildingOptions getBuildingOptions() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PhysicalNamingStrategy getPhysicalNamingStrategy() {
        return new PhysicalNamingStrategyStandardImpl();
    }

    public @UnknownKeyFor @NonNull @Initialized ImplicitNamingStrategy getImplicitNamingStrategy() {
        return new ImplicitNamingStrategyJpaCompliantImpl();
    }

    static @UnknownKeyFor @NonNull @Initialized CollectionType createCollectionType(@UnknownKeyFor @NonNull @Initialized String role, @UnknownKeyFor @NonNull @Initialized String name) {
        return switch (name) {
            case "Set", "SortedSet" -> new SetType(role, null);
            case "List", "SortedList" -> new ListType(role, null);
            case "Map", "SortedMap" -> new MapType(role, null);
            default -> new BagType(role, null);
        };
    }

    abstract @UnknownKeyFor @NonNull @Initialized MockEntityPersister createMockEntityPersister(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized MockCollectionPersister createMockCollectionPersister(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isEntityDefined(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized String qualifyName(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isAttributeDefined(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isClassDefined(@UnknownKeyFor @NonNull @Initialized String var1);

    protected abstract @UnknownKeyFor @NonNull @Initialized boolean isEntity(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isEnum(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isEnumConstant(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> javaConstantType(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isFieldDefined(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isConstructorDefined(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Type> var2);

    abstract @UnknownKeyFor @NonNull @Initialized Type propertyType(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    protected abstract @UnknownKeyFor @NonNull @Initialized boolean isSubtype(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    protected abstract @UnknownKeyFor @NonNull @Initialized String getSupertype(@UnknownKeyFor @NonNull @Initialized String var1);

    private @UnknownKeyFor @NonNull @Initialized EntityPersister createEntityPersister(@UnknownKeyFor @NonNull @Initialized String entityName) {
        MockEntityPersister result = this.entityPersistersByName.get(entityName);
        if (result != null) {
            return result;
        }
        result = this.createMockEntityPersister(entityName);
        this.entityPersistersByName.put(entityName, result);
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized CollectionPersister createCollectionPersister(@UnknownKeyFor @NonNull @Initialized String entityName) {
        MockCollectionPersister result = this.collectionPersistersByName.get(entityName);
        if (result != null) {
            return result;
        }
        result = this.createMockCollectionPersister(entityName);
        this.collectionPersistersByName.put(entityName, result);
        return result;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MockEntityPersister> getMockEntityPersisters() {
        return this.entityPersistersByName.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized Type getIdentifierType(@UnknownKeyFor @NonNull @Initialized String className) throws @UnknownKeyFor @NonNull @Initialized MappingException {
        return this.createEntityPersister(className).getIdentifierType();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BasicType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getVersionType(@UnknownKeyFor @NonNull @Initialized String className) throws @UnknownKeyFor @NonNull @Initialized MappingException {
        return this.createEntityPersister(className).getVersionType();
    }

    public @UnknownKeyFor @NonNull @Initialized String getIdentifierPropertyName(@UnknownKeyFor @NonNull @Initialized String className) throws @UnknownKeyFor @NonNull @Initialized MappingException {
        return this.createEntityPersister(className).getIdentifierPropertyName();
    }

    public @UnknownKeyFor @NonNull @Initialized Type getReferencedPropertyType(@UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized String propertyName) throws @UnknownKeyFor @NonNull @Initialized MappingException {
        return this.createEntityPersister(className).getPropertyType(propertyName);
    }

    public @UnknownKeyFor @NonNull @Initialized MappingMetamodel getMetamodel() {
        return this.metamodel;
    }

    public @UnknownKeyFor @NonNull @Initialized StandardServiceRegistryImpl getServiceRegistry() {
        return this.serviceRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized JdbcServices getJdbcServices() {
        return MockJdbcServicesInitiator.jdbcServices;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return "mock";
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryOptions getSessionFactoryOptions() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getDefinedFilterNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized CacheImplementor getCache() {
        return new DisabledCaching((SessionFactoryImplementor)this);
    }

    public @UnknownKeyFor @NonNull @Initialized EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return new StandardEntityNotFoundDelegate();
    }

    public @UnknownKeyFor @NonNull @Initialized CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return new DefaultCustomEntityDirtinessStrategy();
    }

    public @UnknownKeyFor @NonNull @Initialized CurrentTenantIdentifierResolver<@UnknownKeyFor @NonNull @Initialized Object> getCurrentTenantIdentifierResolver() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized JavaType<@UnknownKeyFor @NonNull @Initialized Object> getTenantIdentifierJavaType() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isPreferJavaTimeJdbcTypesEnabled() {
        return super.isPreferJavaTimeJdbcTypesEnabled();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isPreferNativeEnumTypesEnabled() {
        return super.isPreferNativeEnumTypesEnabled();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isXmlFormatMapperLegacyFormatEnabled() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized ValueHandlingMode getCriteriaValueHandlingMode() {
        return ValueHandlingMode.BIND;
    }

    public void close() {
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findEntityGraphByName(@UnknownKeyFor @NonNull @Initialized String s) {
        throw new UnsupportedOperationException("operation not supported");
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> toPrimitiveClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
        return switch (type.getName()) {
            case "java.lang.Boolean" -> Boolean.TYPE;
            case "java.lang.Character" -> Character.TYPE;
            case "java.lang.Integer" -> Integer.TYPE;
            case "java.lang.Short" -> Short.TYPE;
            case "java.lang.Byte" -> Byte.TYPE;
            case "java.lang.Long" -> Long.TYPE;
            case "java.lang.Float" -> Float.TYPE;
            case "java.lang.Double" -> Double.TYPE;
            default -> Object.class;
        };
    }

    public @UnknownKeyFor @NonNull @Initialized NativeQueryInterpreter getNativeQueryInterpreter() {
        return new NativeQueryInterpreterStandardImpl(this.getNativeJdbcParametersIgnored());
    }

    public @UnknownKeyFor @NonNull @Initialized QueryInterpretationCache getInterpretationCache() {
        return new QueryInterpretationCacheDisabledImpl((ServiceRegistry)this.serviceRegistry);
    }

    public @UnknownKeyFor @NonNull @Initialized StatisticsImplementor getStatistics() {
        return new StatisticsImpl((SessionFactoryImplementor)this);
    }

    public @UnknownKeyFor @NonNull @Initialized SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.functionRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized NodeBuilder getCriteriaBuilder() {
        return this.nodeBuilder;
    }

    public void validateNamedQueries() {
    }

    public @UnknownKeyFor @NonNull @Initialized NamedObjectRepository getNamedObjectRepository() {
        return new NamedObjectRepositoryImpl(new HashMap(), new HashMap(), new HashMap(), new HashMap());
    }

    public @UnknownKeyFor @NonNull @Initialized HqlTranslator getHqlTranslator() {
        return new StandardHqlTranslator((SqmCreationContext)this.nodeBuilder, new SqmCreationOptions(){});
    }

    public @UnknownKeyFor @NonNull @Initialized SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory();
    }

    public @UnknownKeyFor @NonNull @Initialized QueryEngine getQueryEngine() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SqlTranslationEngine getSqlTranslationEngine() {
        return this.sqlTranslationEngine;
    }

    public @UnknownKeyFor @NonNull @Initialized JpaMetamodelImplementor getJpaMetamodel() {
        return this.metamodel.getJpaMetamodel();
    }

    public @UnknownKeyFor @NonNull @Initialized MappingMetamodelImplementor getMappingMetamodel() {
        return this.metamodel;
    }

    public @UnknownKeyFor @NonNull @Initialized RuntimeMetamodelsImplementor getRuntimeMetamodels() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isClosed() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized MutableJpaCompliance getJpaCompliance() {
        return jpaCompliance;
    }

    public @UnknownKeyFor @NonNull @Initialized String getSessionFactoryName() {
        return "mock";
    }

    public @UnknownKeyFor @NonNull @Initialized String getUuid() {
        return "mock";
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryObserver @UnknownKeyFor @NonNull @Initialized [] getSessionFactoryObservers() {
        return NO_OBSERVERS;
    }

    public @UnknownKeyFor @NonNull @Initialized EntityNameResolver @UnknownKeyFor @NonNull @Initialized [] getEntityNameResolvers() {
        return NO_RESOLVERS;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDelayBatchFetchLoaderCreationsEnabled() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized Integer getMaximumFetchDepth() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean allowImmutableEntityUpdate() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableEntityUpdateQueryHandlingMode getImmutableEntityUpdateQueryHandlingMode() {
        return ImmutableEntityUpdateQueryHandlingMode.ALLOW;
    }

    public void setCheckNullability(@UnknownKeyFor @NonNull @Initialized boolean enabled) {
    }

    public @UnknownKeyFor @NonNull @Initialized Dialect getDialect() {
        return MockJdbcServicesInitiator.genericDialect;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForBoolean() {
        return 16;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForDuration() {
        return 2;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForUuid() {
        return 3000;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForInstant() {
        return 2014;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForArray() {
        return 2003;
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getSessionFactory() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized BootstrapContext getBootstrapContext() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized MetadataImplementor getBootModel() {
        return this.bootModel;
    }

    public @UnknownKeyFor @NonNull @Initialized MappingMetamodelImplementor getDomainModel() {
        return this.metamodel;
    }

    public @UnknownKeyFor @NonNull @Initialized SqmFunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getSettings() {
        return Collections.emptyMap();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlStringGenerationContext getSqlStringGenerationContext() {
        throw new UnsupportedOperationException("operation not supported");
    }

    public @UnknownKeyFor @NonNull @Initialized MappingDefaults getMappingDefaults() {
        return new MockMappingDefaults();
    }

    public @UnknownKeyFor @NonNull @Initialized EffectiveMappingDefaults getEffectiveDefaults() {
        throw new UnsupportedOperationException();
    }

    public @UnknownKeyFor @NonNull @Initialized TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return TimeZoneStorageStrategy.NATIVE;
    }

    @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getEnumTypesForValue(@UnknownKeyFor @NonNull @Initialized String value) {
        return Collections.emptySet();
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized String getJpaEntityName(@UnknownKeyFor @NonNull @Initialized String var1);

    private <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmPersistentAttribute<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createAttribute(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized ManagedDomainType<T> owner) {
        JavaType javaType;
        if (type == null) {
            throw new UnsupportedOperationException(entityName + "." + name);
        }
        if (type.isCollectionType()) {
            CollectionType collectionType = (CollectionType)type;
            return this.createPluralAttribute(collectionType, entityName, name, owner);
        }
        if (type.isEntityType()) {
            return new SingularAttributeImpl(owner, name, AttributeClassification.MANY_TO_ONE, new MockEntityDomainType(new MockJavaType(type.getName())), null, null, false, false, true, false, this.metadataContext);
        }
        if (type.isComponentType()) {
            CompositeType compositeType = (CompositeType)type;
            return new SingularAttributeImpl(owner, name, AttributeClassification.EMBEDDED, this.createEmbeddableDomainType(entityName, compositeType, owner), null, null, false, false, true, false, this.metadataContext);
        }
        SqmDomainType sqmDomainType = (SqmDomainType)type;
        if (type instanceof JdbcMapping) {
            JdbcMapping jdbcMapping = (JdbcMapping)type;
            javaType = jdbcMapping.getJavaTypeDescriptor();
        } else {
            javaType = null;
        }
        return new SingularAttributeImpl(owner, name, AttributeClassification.BASIC, sqmDomainType, javaType, null, false, false, true, false, this.metadataContext);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getElementDomainType(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner) {
        Type elementType = collectionType.getElementType((SessionFactoryImplementor)this);
        return this.getDomainType(entityName, collectionType, owner, elementType);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getMapKeyDomainType(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner) {
        Type keyType = this.getMappingMetamodel().getCollectionDescriptor(collectionType.getRole()).getIndexType();
        return this.getDomainType(entityName, collectionType, owner, keyType);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDomainType(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner, @UnknownKeyFor @NonNull @Initialized Type elementType) {
        if (elementType.isEntityType()) {
            String associatedEntityName = collectionType.getAssociatedEntityName((SessionFactoryImplementor)this);
            return new MockEntityDomainType(new MockJavaType(associatedEntityName));
        }
        if (elementType.isComponentType()) {
            CompositeType compositeType = (CompositeType)elementType;
            return this.createEmbeddableDomainType(entityName, compositeType, owner);
        }
        if (elementType instanceof SqmDomainType) {
            SqmDomainType domainType = (SqmDomainType)elementType;
            return domainType;
        }
        return OBJECT_BASIC_TYPE;
    }

    private <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AbstractPluralAttribute<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createPluralAttribute(@UnknownKeyFor @NonNull @Initialized CollectionType collectionType, @UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized ManagedDomainType<T> owner) {
        Property property = new Property();
        property.setName(name);
        JavaType collectionJavaType = this.typeConfiguration.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)collectionType.getReturnedClass());
        SqmDomainType<?> elementDomainType = this.getElementDomainType(entityName, collectionType, owner);
        CollectionClassification classification = collectionType.getCollectionClassification();
        return switch (classification) {
            case CollectionClassification.LIST -> new ListAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, (DomainType)this.typeConfiguration.getBasicTypeRegistry().getRegisteredType(Integer.class), owner, property, null), this.metadataContext);
            case CollectionClassification.BAG, CollectionClassification.ID_BAG -> new BagAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, null, owner, property, null), this.metadataContext);
            case CollectionClassification.SET, CollectionClassification.SORTED_SET, CollectionClassification.ORDERED_SET -> new SetAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, null, owner, property, null), this.metadataContext);
            case CollectionClassification.MAP, CollectionClassification.SORTED_MAP, CollectionClassification.ORDERED_MAP -> new MapAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, this.getMapKeyDomainType(entityName, collectionType, owner), owner, property, null), this.metadataContext);
            default -> null;
        };
    }

    private <T> @UnknownKeyFor @NonNull @Initialized EmbeddableTypeImpl<T> createEmbeddableDomainType(final @UnknownKeyFor @NonNull @Initialized String entityName, final @UnknownKeyFor @NonNull @Initialized CompositeType compositeType, final @UnknownKeyFor @NonNull @Initialized ManagedDomainType<T> owner) {
        UnknownBasicJavaType javaType = new UnknownBasicJavaType(null, compositeType.getReturnedClassName());
        return new EmbeddableTypeImpl<T>((JavaType)javaType, null, null, true, this.metamodel.getJpaMetamodel()){

            public SqmPersistentAttribute<T, ?> findAttribute(String name) {
                return MockSessionFactory.this.createAttribute(name, entityName, compositeType.getSubtypes()[compositeType.getPropertyIndex(name)], owner);
            }
        };
    }

    private class MockMappingMetamodelImpl
    extends MappingMetamodelImpl {
        public MockMappingMetamodelImpl() {
            super(MockSessionFactory.this.typeConfiguration, (ServiceRegistry)MockSessionFactory.this.serviceRegistry);
        }

        public @UnknownKeyFor @NonNull @Initialized EntityPersister getEntityDescriptor(@UnknownKeyFor @NonNull @Initialized String entityName) {
            return MockSessionFactory.this.createEntityPersister(entityName);
        }

        public @UnknownKeyFor @NonNull @Initialized CollectionPersister getCollectionDescriptor(@UnknownKeyFor @NonNull @Initialized String role) {
            return MockSessionFactory.this.createCollectionPersister(role);
        }

        public @UnknownKeyFor @NonNull @Initialized CollectionPersister findCollectionDescriptor(@UnknownKeyFor @NonNull @Initialized String role) {
            return MockSessionFactory.this.createCollectionPersister(role);
        }

        public @UnknownKeyFor @NonNull @Initialized JpaMetamodelImplementor getJpaMetamodel() {
            return new MockJpaMetamodelImpl();
        }

        public @UnknownKeyFor @NonNull @Initialized EntityPersister findEntityDescriptor(@UnknownKeyFor @NonNull @Initialized String entityName) {
            return MockSessionFactory.this.createEntityPersister(entityName);
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getEnumTypesForValue(@UnknownKeyFor @NonNull @Initialized String enumValue) {
            return MockSessionFactory.this.getEnumTypesForValue(enumValue);
        }
    }

    private static class MockMappingDefaults
    implements MappingDefaults {
        private MockMappingDefaults() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitSchemaName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitCatalogName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean shouldImplicitlyQuoteIdentifiers() {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitIdColumnName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitTenantIdColumnName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitDiscriminatorColumnName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitPackageName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isAutoImportEnabled() {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitCascadeStyleName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitPropertyAccessorName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean areEntitiesImplicitlyLazy() {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean areCollectionsImplicitlyLazy() {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized AccessType getImplicitCacheAccessType() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized CollectionClassification getImplicitListClassification() {
            return null;
        }
    }

    class MockEntityDomainType<@UnknownKeyFor X>
    extends EntityTypeImpl<X> {
        public MockEntityDomainType(JavaType<X> javaType) {
            this(javaType, this$0.getJpaEntityName(javaType.getTypeName()));
        }

        public MockEntityDomainType(@UnknownKeyFor @NonNull @Initialized JavaType<X> javaType, String jpaEntityName) {
            super(javaType.getTypeName(), jpaEntityName, false, true, false, javaType, null, MockSessionFactory.this.metamodel.getJpaMetamodel());
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SqmSingularPersistentAttribute<@UnknownKeyFor @Nullable @Initialized ? super X, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findVersionAttribute() {
            BasicType<?> type = MockSessionFactory.this.getVersionType(this.getHibernateEntityName());
            if (type == null) {
                return null;
            }
            return new SingularAttributeImpl((ManagedDomainType)this, "{version}", AttributeClassification.BASIC, type, type.getRelationalJavaType(), null, false, true, false, false, MockSessionFactory.this.metadataContext);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasVersionAttribute() {
            return MockSessionFactory.this.getVersionType(this.getHibernateEntityName()) != null;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SqmPathSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getIdentifierDescriptor() {
            Type type = MockSessionFactory.this.getIdentifierType(this.getHibernateEntityName());
            if (type instanceof BasicDomainType) {
                BasicDomainType basicDomainType = (BasicDomainType)type;
                return new BasicSqmPathSource("{id}", null, basicDomainType, this.getExpressibleJavaType(), Bindable.BindableType.SINGULAR_ATTRIBUTE, false);
            }
            if (type instanceof SqmEmbeddableDomainType) {
                SqmEmbeddableDomainType embeddableDomainType = (SqmEmbeddableDomainType)type;
                return new EmbeddedSqmPathSource("{id}", null, embeddableDomainType, Bindable.BindableType.SINGULAR_ATTRIBUTE, false);
            }
            return null;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SqmPathSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findSubPathSource(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized boolean includeSubtypes) {
            switch (name) {
                case "{id}": {
                    return this.getIdentifierDescriptor();
                }
                case "{version}": {
                    return this.findVersionAttribute();
                }
            }
            SqmPathSource source = super.findSubPathSource(name, includeSubtypes);
            if (source != null) {
                return source;
            }
            String supertype = MockSessionFactory.this.getSupertype(this.getHibernateEntityName());
            SqmPersistentAttribute superattribute = new MockMappedDomainType(supertype).findAttribute(name);
            if (superattribute != null) {
                return (SqmPathSource)superattribute;
            }
            for (Map.Entry<String, MockEntityPersister> entry : MockSessionFactory.this.entityPersistersByName.entrySet()) {
                MockEntityDomainType entityDomainType;
                SqmPersistentAttribute subattribute;
                MockEntityPersister entityPersister = entry.getValue();
                if (entityPersister.getEntityName().equals(this.getHibernateEntityName()) || !MockSessionFactory.this.isSubtype(entityPersister.getEntityName(), this.getHibernateEntityName()) || (subattribute = (entityDomainType = new MockEntityDomainType(new MockJavaType(entityPersister.getEntityName()), entityPersister.getJpaEntityName())).findAttribute(name)) == null) continue;
                return (SqmPathSource)subattribute;
            }
            return null;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SqmPersistentAttribute<@UnknownKeyFor @Nullable @Initialized ? super X, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findAttribute(@UnknownKeyFor @NonNull @Initialized String name) {
            SqmPersistentAttribute attribute = super.findAttribute(name);
            if (attribute != null) {
                return attribute;
            }
            String supertype = MockSessionFactory.this.getSupertype(this.getHibernateEntityName());
            return new MockMappedDomainType(supertype).findAttribute(name);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SqmPersistentAttribute<X, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findDeclaredAttribute(@UnknownKeyFor @NonNull @Initialized String name) {
            String entityName = this.getHibernateEntityName();
            return MockSessionFactory.this.isAttributeDefined(entityName, name) ? MockSessionFactory.this.createAttribute(name, entityName, MockSessionFactory.this.getReferencedPropertyType(entityName, name), this) : null;
        }
    }

    private static class MockJavaType<@UnknownKeyFor X>
    implements BasicJavaType<X> {
        private final @UnknownKeyFor @NonNull @Initialized String typeName;

        public MockJavaType(@UnknownKeyFor @NonNull @Initialized String typeName) {
            this.typeName = typeName;
        }

        public <X1> X1 unwrap(X value, @UnknownKeyFor @NonNull @Initialized Class<X1> type, @UnknownKeyFor @NonNull @Initialized WrapperOptions options) {
            return null;
        }

        public <X1> X wrap(X1 value, @UnknownKeyFor @NonNull @Initialized WrapperOptions options) {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getTypeName() {
            return this.typeName;
        }

        public @UnknownKeyFor @NonNull @Initialized Class<X> getJavaTypeClass() {
            try {
                return Class.forName(this.typeName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    class MockMappedDomainType<@UnknownKeyFor X>
    extends MappedSuperclassTypeImpl<X> {
        public MockMappedDomainType(String typeName) {
            super(typeName, false, true, false, null, null, MockSessionFactory.this.metamodel.getJpaMetamodel());
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SqmPersistentAttribute<X, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findDeclaredAttribute(@UnknownKeyFor @NonNull @Initialized String name) {
            String typeName = this.getTypeName();
            return MockSessionFactory.this.isFieldDefined(typeName, name) ? MockSessionFactory.this.createAttribute(name, typeName, MockSessionFactory.this.propertyType(typeName, name), this) : null;
        }
    }

    private class MockJpaMetamodelImpl
    extends JpaMetamodelImpl {
        public MockJpaMetamodelImpl() {
            super(MockSessionFactory.this.typeConfiguration, (MappingMetamodel)MockSessionFactory.this.metamodel, (ServiceRegistry)MockSessionFactory.this.serviceRegistry);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized EntityDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findEntityType(@Nullable @UnknownKeyFor @Initialized String jpaEntityName) {
            String entityTypeName = MockSessionFactory.this.qualifyName(jpaEntityName);
            if (entityTypeName != null) {
                return new MockEntityDomainType(new MockJavaType(entityTypeName), jpaEntityName);
            }
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String qualifyImportableName(@UnknownKeyFor @NonNull @Initialized String queryName) {
            if (MockSessionFactory.this.isClassDefined(queryName)) {
                return queryName;
            }
            if (MockSessionFactory.this.isEntityDefined(queryName)) {
                return MockSessionFactory.this.qualifyName(queryName);
            }
            return null;
        }

        public <X> @Nullable @UnknownKeyFor @Initialized ManagedDomainType<X> findManagedType(@Nullable @UnknownKeyFor @Initialized String typeName) {
            return typeName == null ? null : new MockEntityDomainType(new MockJavaType(typeName));
        }

        public <X> @UnknownKeyFor @NonNull @Initialized ManagedDomainType<X> findManagedType(@UnknownKeyFor @NonNull @Initialized Class<X> cls) {
            return this.findManagedType(cls.getName());
        }

        public <X> @UnknownKeyFor @NonNull @Initialized EntityDomainType<X> findEntityType(@UnknownKeyFor @NonNull @Initialized Class<X> cls) {
            return !cls.isArray() && !cls.isPrimitive() && MockSessionFactory.this.isEntity(cls.getName()) ? new MockEntityDomainType(new MockJavaType(cls.getName())) : null;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized EnumJavaType<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getEnumType(final @UnknownKeyFor @NonNull @Initialized String className) {
            if (MockSessionFactory.this.isEnum(className)) {
                return new EnumJavaType(Enum.class){

                    public String getTypeName() {
                        return className;
                    }
                };
            }
            return null;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized JavaType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getJavaConstantType(@UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized String fieldName) {
            return MockSessionFactory.this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(MockSessionFactory.this.javaConstantType(className, fieldName));
        }

        public <T> T getJavaConstant(@UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized String fieldName) {
            return null;
        }

        public <E extends Enum<E>> E enumValue(@UnknownKeyFor @NonNull @Initialized EnumJavaType<E> enumType, @UnknownKeyFor @NonNull @Initialized String enumValueName) {
            if (!MockSessionFactory.this.isEnumConstant(enumType.getTypeName(), enumValueName)) {
                throw new IllegalArgumentException("No enum constant " + enumType.getTypeName() + "." + enumValueName);
            }
            return null;
        }

        public @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getEnumTypesForValue(@UnknownKeyFor @NonNull @Initialized String enumValue) {
            return MockSessionFactory.this.getEnumTypesForValue(enumValue);
        }

        public @UnknownKeyFor @NonNull @Initialized JpaCompliance getJpaCompliance() {
            return jpaCompliance;
        }
    }
}

