/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.Context;
import org.hibernate.processor.HibernateProcessor;
import org.hibernate.processor.annotation.InnerClassMetaAttribute;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.TypeUtils;

public final class ClassWriter {
    private ClassWriter() {
    }

    public static void writeFile(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        try {
            String metaModelPackage = entity.getPackageName();
            String body = ClassWriter.generateBody(entity, context).toString();
            JavaFileObject fo = context.getProcessingEnvironment().getFiler().createSourceFile(ClassWriter.getFullyQualifiedClassName(entity), entity.getElement());
            OutputStream os = fo.openOutputStream();
            PrintWriter pw = new PrintWriter(os);
            if (!metaModelPackage.isEmpty()) {
                pw.println("package " + metaModelPackage + ";");
                pw.println();
            }
            pw.println(entity.generateImports());
            pw.println(body);
            pw.flush();
            pw.close();
        }
        catch (FilerException filerEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem with Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write MetaModel for " + entity.getSimpleName() + ": " + ioEx.getMessage());
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized StringBuffer generateBody(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            pw.println(entity.javadoc());
            if (context.addDependentAnnotation() && entity.isInjectable()) {
                pw.println(ClassWriter.writeScopeAnnotation(entity));
            }
            if (entity.getElement() instanceof TypeElement && !entity.isInjectable()) {
                pw.println(ClassWriter.writeStaticMetaModelAnnotation(entity));
            }
            if (context.addGeneratedAnnotation()) {
                pw.println(ClassWriter.writeGeneratedAnnotation(entity, context));
            }
            if (context.addSuppressWarningsAnnotation()) {
                pw.println(ClassWriter.writeSuppressWarnings(context));
            }
            entity.inheritedAnnotations().forEach(annotation -> {
                ClassWriter.printAnnotation(annotation, pw);
                pw.print('\n');
            });
            ClassWriter.printClassDeclaration(entity, pw);
            pw.println();
            List<MetaAttribute> members = entity.getMembers();
            for (MetaAttribute metaMember : members) {
                if (!(metaMember instanceof InnerClassMetaAttribute)) continue;
                InnerClassMetaAttribute innerClass = (InnerClassMetaAttribute)metaMember;
                ClassWriter.generateBody(innerClass.getMetaEntity(), context).toString().lines().forEach(line -> pw.println("\t" + line));
                context.markGenerated(innerClass.getMetaEntity());
            }
            for (MetaAttribute metaMember : members) {
                if (!metaMember.hasStringAttribute()) continue;
                metaMember.getAttributeNameDeclarationString().lines().forEach(line -> pw.println("\t" + line));
            }
            pw.println();
            for (MetaAttribute metaMember : members) {
                if (!metaMember.hasTypedAttribute()) continue;
                metaMember.getAttributeDeclarationString().lines().forEach(line -> {
                    pw.println("\t" + line);
                    if (line.trim().startsWith("@Override")) {
                        metaMember.inheritedAnnotations().forEach(annotation -> {
                            pw.print('\t');
                            ClassWriter.printAnnotation(annotation, pw);
                            pw.print('\n');
                        });
                    }
                });
            }
            pw.println();
            pw.println("}");
            StringBuffer stringBuffer = sw.getBuffer();
            return stringBuffer;
        }
    }

    private static void printAnnotation(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotation, @UnknownKeyFor @NonNull @Initialized PrintWriter pw) {
        pw.print('@');
        TypeElement type = (TypeElement)annotation.getAnnotationType().asElement();
        pw.print(type.getQualifiedName().toString());
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
        if (!elementValues.isEmpty()) {
            pw.print('(');
            boolean first = true;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    pw.print(',');
                }
                pw.print(entry.getKey().getSimpleName());
                pw.print('=');
                ClassWriter.printAnnotationValue(pw, entry.getValue());
            }
            pw.print(')');
        }
    }

    private static void printAnnotationValue(@UnknownKeyFor @NonNull @Initialized PrintWriter pw, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        Object argument = value.getValue();
        if (argument instanceof VariableElement) {
            VariableElement variable = (VariableElement)argument;
            pw.print(variable.getEnclosingElement());
            pw.print('.');
            pw.print(variable.getSimpleName().toString());
        } else if (argument instanceof AnnotationMirror) {
            AnnotationMirror childAnnotation = (AnnotationMirror)argument;
            ClassWriter.printAnnotation(childAnnotation, pw);
        } else if (argument instanceof List) {
            List list = (List)argument;
            pw.print('{');
            boolean first = true;
            for (AnnotationValue listedValue : list) {
                if (first) {
                    first = false;
                } else {
                    pw.print(',');
                }
                ClassWriter.printAnnotationValue(pw, listedValue);
            }
            pw.print('}');
        } else {
            pw.print(argument);
        }
    }

    private static void printClassDeclaration(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized PrintWriter pw) {
        if (TypeUtils.isMemberType(entity.getElement())) {
            Set<Modifier> modifiers = entity.getElement().getModifiers();
            if (modifiers.contains((Object)Modifier.PUBLIC)) {
                pw.print("public ");
            } else if (modifiers.contains((Object)Modifier.PROTECTED)) {
                pw.print("protected ");
            }
            pw.print("static ");
        } else {
            pw.print("public ");
        }
        if (!entity.isImplementation() && !entity.isJakartaDataStyle()) {
            pw.print("abstract ");
        }
        pw.print(entity.isJakartaDataStyle() ? "interface " : "class ");
        pw.print(ClassWriter.getGeneratedClassName(entity));
        Element superTypeElement = entity.getSuperTypeElement();
        if (superTypeElement != null) {
            pw.print(" extends " + entity.importType(ClassWriter.getGeneratedSuperclassName(superTypeElement, entity.isJakartaDataStyle())));
        }
        if (entity.isImplementation()) {
            pw.print(entity.getElement().getKind() == ElementKind.CLASS ? " extends " : " implements ");
            pw.print(entity.getSimpleName());
        }
        pw.println(" {");
    }

    private static @UnknownKeyFor @NonNull @Initialized String getFullyQualifiedClassName(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        Object object;
        Element element = entity.getElement();
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            object = packageElement.getQualifiedName().toString() + "." + ClassWriter.getGeneratedClassName(entity);
        } else {
            object = TypeUtils.getGeneratedClassFullyQualifiedName((TypeElement)entity.getElement(), entity.getPackageName(), entity.isJakartaDataStyle());
        }
        return object;
    }

    private static @UnknownKeyFor @NonNull @Initialized String getGeneratedClassName(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        String className = entity.getSimpleName();
        return entity.isJakartaDataStyle() ? "_" + className : className + "_";
    }

    private static @UnknownKeyFor @NonNull @Initialized String getGeneratedSuperclassName(@UnknownKeyFor @NonNull @Initialized Element superClassElement, @UnknownKeyFor @NonNull @Initialized boolean jakartaDataStyle) {
        return ClassWriter.getGeneratedClassName((TypeElement)superClassElement, jakartaDataStyle);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getGeneratedClassName(@UnknownKeyFor @NonNull @Initialized TypeElement typeElement, @UnknownKeyFor @NonNull @Initialized boolean jakartaDataStyle) {
        String simpleName = typeElement.getSimpleName().toString();
        Element enclosingElement = typeElement.getEnclosingElement();
        return (enclosingElement instanceof TypeElement ? ClassWriter.getGeneratedSuperclassName(enclosingElement, jakartaDataStyle) : ((PackageElement)enclosingElement).getQualifiedName().toString()) + "." + (jakartaDataStyle ? "_" + simpleName : simpleName + "_");
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeGeneratedAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        StringBuilder generatedAnnotation = new StringBuilder();
        generatedAnnotation.append("@").append(entity.importType("jakarta.annotation.Generated")).append("(");
        if (context.addGeneratedDate()) {
            generatedAnnotation.append("value = ");
        }
        generatedAnnotation.append("\"").append(HibernateProcessor.class.getName()).append("\"");
        if (context.addGeneratedDate()) {
            generatedAnnotation.append(", date = ").append("\"").append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.now())).append("\"");
        }
        generatedAnnotation.append(")");
        return generatedAnnotation.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeSuppressWarnings(@UnknownKeyFor @NonNull @Initialized Context context) {
        StringBuilder annotation = new StringBuilder("@SuppressWarnings({");
        String[] warnings = context.getSuppressedWarnings();
        for (int i = 0; i < warnings.length; ++i) {
            if (i > 0) {
                annotation.append(", ");
            }
            annotation.append('\"').append(warnings[i]).append('\"');
        }
        return annotation.append("})").toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeScopeAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        return "@" + entity.importType(entity.scope());
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeStaticMetaModelAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        String annotation = entity.isJakartaDataStyle() ? "jakarta.data.metamodel.StaticMetamodel" : "jakarta.persistence.metamodel.StaticMetamodel";
        String simpleName = entity.importType(entity.getQualifiedName());
        return "@" + entity.importType(annotation) + "(" + simpleName + ".class)";
    }
}

