/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.maven;

import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.internal.log.DeprecationLogger;

public class EnhancementContext
extends DefaultEnhancementContext {
    private ClassLoader classLoader = null;
    private boolean enableAssociationManagement = false;
    private boolean enableDirtyTracking = false;
    private boolean enableLazyInitialization = false;
    private boolean enableExtendedEnhancement = false;

    public EnhancementContext(ClassLoader classLoader, boolean enableAssociationManagement, boolean enableDirtyTracking, boolean enableLazyInitialization, boolean enableExtendedEnhancement) {
        this.classLoader = classLoader;
        this.enableAssociationManagement = enableAssociationManagement;
        this.enableDirtyTracking = enableDirtyTracking;
        this.enableLazyInitialization = enableLazyInitialization;
        this.enableExtendedEnhancement = enableExtendedEnhancement;
    }

    public ClassLoader getLoadingClassLoader() {
        return this.classLoader;
    }

    public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
        if (this.enableAssociationManagement) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSettingForRemoval("management of bidirectional persistent association attributes", "false");
        }
        return this.enableAssociationManagement;
    }

    public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
        return this.enableDirtyTracking;
    }

    public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
        return this.enableLazyInitialization;
    }

    public boolean isLazyLoadable(UnloadedField field) {
        return this.enableLazyInitialization;
    }

    public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
        if (this.enableExtendedEnhancement) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSettingForRemoval("extended enhancement", "false");
        }
        return this.enableExtendedEnhancement;
    }
}

