/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.internal.BytecodeProviderInitiator;
import org.hibernate.orm.tooling.maven.EnhancementContext;

@Mojo(name="enhance", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class HibernateEnhancerMojo
extends AbstractMojo {
    private final List<File> sourceSet = new ArrayList<File>();
    private Enhancer enhancer;
    @Parameter
    private FileSet[] fileSets;
    @Parameter(defaultValue="${project.build.directory}/classes", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="false", required=true)
    private boolean enableAssociationManagement;
    @Parameter(defaultValue="false", required=true)
    private boolean enableDirtyTracking;
    @Parameter(defaultValue="false", required=true)
    private boolean enableLazyInitialization;
    @Parameter(defaultValue="false", required=true)
    private boolean enableExtendedEnhancement;
    static final String SUCCESFULLY_CLEARED_FILE = "Succesfully cleared the contents of file: %s";
    static final String SUCCESFULLY_ENHANCED_CLASS_FILE = "Succesfully enhanced class file: %s";
    static final String SKIPPING_FILE = "Skipping file: %s";
    static final String SUCCESFULLY_DISCOVERED_TYPES_FOR_CLASS_FILE = "Succesfully discovered types for classes in file: %s";
    static final String ADDED_FILE_TO_SOURCE_SET = "Added file to source set: %s";
    static final String PROBLEM_CLEARING_FILE = "Problem clearing file for writing out enhancements [ %s ]";
    static final String ENABLE_LAZY_INITIALIZATION_DEPRECATED = "The 'enableLazyInitialization' configuration is deprecated and will be removed. Set the value to 'true' to get rid of this warning";
    static final String ENABLE_DIRTY_TRACKING_DEPRECATED = "The 'enableDirtyTracking' configuration is deprecated and will be removed. Set the value to 'true' to get rid of this warning";
    static final String UNABLE_TO_CREATE_FILE = "Unable to create file: %s";
    static final String UNABLE_TO_DELETE_FILE = "Unable to delete file: %s";
    static final String ERROR_WRITING_BYTES_TO_FILE = "Error writing bytes to file : %s";
    static final String ERROR_OPENING_FILE_FOR_WRITING = "Error opening file for writing : %s";
    static final String ERROR_WHILE_ENHANCING_CLASS_FILE = "An exception occurred while trying to class file: %s";
    static final String UNABLE_TO_DISCOVER_TYPES_FOR_CLASS_FILE = "Unable to discover types for classes in file: %s";
    static final String UNEXPECTED_ERROR_WHILE_CONSTRUCTING_CLASSLOADER = "An unexpected error occurred while constructing the classloader";
    static final String TRYING_TO_CLEAR_FILE = "Trying to clear the contents of file: %s";
    static final String AMOUNT_BYTES_WRITTEN_TO_FILE = "%s bytes were succesfully written to file: %s";
    static final String WRITING_BYTE_CODE_TO_FILE = "Writing byte code to file: %s";
    static final String DETERMINE_CLASS_NAME_FOR_FILE = "Determining class name for file: %s";
    static final String TRYING_TO_ENHANCE_CLASS_FILE = "Trying to enhance class file: %s";
    static final String STARTING_CLASS_ENHANCEMENT = "Starting class enhancement";
    static final String SETTING_LASTMODIFIED_FAILED_FOR_CLASS_FILE = "Setting lastModified failed for class file: %s";
    static final String ENDING_CLASS_ENHANCEMENT = "Ending class enhancement";
    static final String TRYING_TO_DISCOVER_TYPES_FOR_CLASS_FILE = "Trying to discover types for classes in file: %s";
    static final String STARTING_TYPE_DISCOVERY = "Starting type discovery";
    static final String ENDING_TYPE_DISCOVERY = "Ending type discovery";
    static final String CREATE_BYTECODE_ENHANCER = "Creating bytecode enhancer";
    static final String CREATE_ENHANCEMENT_CONTEXT = "Creating enhancement context";
    static final String CREATE_URL_CLASSLOADER_FOR_FOLDER = "Creating URL ClassLoader for folder: %s";
    static final String PROCESSING_FILE_SET = "Processing FileSet";
    static final String USING_BASE_DIRECTORY = "Using base directory: %s";
    static final String SKIPPING_NON_CLASS_FILE = "Skipping non '.class' file: %s";
    static final String FILESET_PROCESSED_SUCCESFULLY = "FileSet was processed succesfully";
    static final String STARTING_ASSEMBLY_OF_SOURCESET = "Starting assembly of the source set";
    static final String ENDING_ASSEMBLY_OF_SOURCESET = "Ending the assembly of the source set";
    static final String ADDED_DEFAULT_FILESET_WITH_BASE_DIRECTORY = "Addded a default FileSet with base directory: %s";
    static final String STARTING_EXECUTION_OF_ENHANCE_MOJO = "Starting execution of enhance mojo";
    static final String ENDING_EXECUTION_OF_ENHANCE_MOJO = "Ending execution of enhance mojo";

    public void execute() {
        this.getLog().debug((CharSequence)STARTING_EXECUTION_OF_ENHANCE_MOJO);
        this.processParameters();
        this.assembleSourceSet();
        this.createEnhancer();
        this.discoverTypes();
        this.performEnhancement();
        this.getLog().debug((CharSequence)ENDING_EXECUTION_OF_ENHANCE_MOJO);
    }

    private void processParameters() {
        if (!this.enableLazyInitialization) {
            this.getLog().warn((CharSequence)ENABLE_LAZY_INITIALIZATION_DEPRECATED);
        }
        if (!this.enableDirtyTracking) {
            this.getLog().warn((CharSequence)ENABLE_DIRTY_TRACKING_DEPRECATED);
        }
        if (this.fileSets == null) {
            this.fileSets = new FileSet[1];
            this.fileSets[0] = new FileSet();
            this.fileSets[0].setDirectory(this.classesDirectory.getAbsolutePath());
            this.getLog().debug((CharSequence)ADDED_DEFAULT_FILESET_WITH_BASE_DIRECTORY.formatted(this.fileSets[0].getDirectory()));
        }
    }

    private void assembleSourceSet() {
        this.getLog().debug((CharSequence)STARTING_ASSEMBLY_OF_SOURCESET);
        for (FileSet fileSet : this.fileSets) {
            this.addFileSetToSourceSet(fileSet);
        }
        this.getLog().debug((CharSequence)ENDING_ASSEMBLY_OF_SOURCESET);
    }

    private void addFileSetToSourceSet(FileSet fileSet) {
        this.getLog().debug((CharSequence)PROCESSING_FILE_SET);
        String directory = fileSet.getDirectory();
        FileSetManager fileSetManager = new FileSetManager();
        File baseDir = this.classesDirectory;
        if (directory != null && this.classesDirectory != null) {
            baseDir = new File(directory);
        }
        this.getLog().debug((CharSequence)USING_BASE_DIRECTORY.formatted(baseDir));
        for (String fileName : fileSetManager.getIncludedFiles(fileSet)) {
            File candidateFile = new File(baseDir, fileName);
            if (fileName.endsWith(".class")) {
                this.sourceSet.add(candidateFile);
                this.getLog().info((CharSequence)ADDED_FILE_TO_SOURCE_SET.formatted(candidateFile));
                continue;
            }
            this.getLog().debug((CharSequence)SKIPPING_NON_CLASS_FILE.formatted(candidateFile));
        }
        this.getLog().debug((CharSequence)FILESET_PROCESSED_SUCCESFULLY);
    }

    private ClassLoader createClassLoader() {
        this.getLog().debug((CharSequence)CREATE_URL_CLASSLOADER_FOR_FOLDER.formatted(this.classesDirectory));
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            urls.add(this.classesDirectory.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.getLog().error((CharSequence)UNEXPECTED_ERROR_WHILE_CONSTRUCTING_CLASSLOADER, (Throwable)e);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Enhancer.class.getClassLoader());
    }

    private EnhancementContext createEnhancementContext() {
        this.getLog().debug((CharSequence)CREATE_ENHANCEMENT_CONTEXT);
        return new EnhancementContext(this.createClassLoader(), this.enableAssociationManagement, this.enableDirtyTracking, this.enableLazyInitialization, this.enableExtendedEnhancement);
    }

    private void createEnhancer() {
        this.getLog().debug((CharSequence)CREATE_BYTECODE_ENHANCER);
        this.enhancer = BytecodeProviderInitiator.buildDefaultBytecodeProvider().getEnhancer((org.hibernate.bytecode.enhance.spi.EnhancementContext)this.createEnhancementContext());
    }

    private void discoverTypes() {
        this.getLog().debug((CharSequence)STARTING_TYPE_DISCOVERY);
        for (File classFile : this.sourceSet) {
            this.discoverTypesForClass(classFile);
        }
        this.getLog().debug((CharSequence)ENDING_TYPE_DISCOVERY);
    }

    private void discoverTypesForClass(File classFile) {
        this.getLog().debug((CharSequence)TRYING_TO_DISCOVER_TYPES_FOR_CLASS_FILE.formatted(classFile));
        try {
            this.enhancer.discoverTypes(this.determineClassName(classFile), Files.readAllBytes(classFile.toPath()));
            this.getLog().info((CharSequence)SUCCESFULLY_DISCOVERED_TYPES_FOR_CLASS_FILE.formatted(classFile));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)UNABLE_TO_DISCOVER_TYPES_FOR_CLASS_FILE.formatted(classFile), (Throwable)e);
        }
    }

    private String determineClassName(File classFile) {
        this.getLog().debug((CharSequence)DETERMINE_CLASS_NAME_FOR_FILE.formatted(classFile));
        String classFilePath = classFile.getAbsolutePath();
        String classesDirectoryPath = this.classesDirectory.getAbsolutePath();
        return classFilePath.substring(classesDirectoryPath.length() + 1, classFilePath.length() - ".class".length()).replace(File.separatorChar, '.');
    }

    private void performEnhancement() {
        this.getLog().debug((CharSequence)STARTING_CLASS_ENHANCEMENT);
        for (File classFile : this.sourceSet) {
            long lastModified = classFile.lastModified();
            this.enhanceClass(classFile);
            boolean timestampReset = classFile.setLastModified(lastModified);
            if (timestampReset) continue;
            this.getLog().debug((CharSequence)SETTING_LASTMODIFIED_FAILED_FOR_CLASS_FILE.formatted(classFile));
        }
        this.getLog().debug((CharSequence)ENDING_CLASS_ENHANCEMENT);
    }

    private void enhanceClass(File classFile) {
        this.getLog().debug((CharSequence)TRYING_TO_ENHANCE_CLASS_FILE.formatted(classFile));
        try {
            byte[] newBytes = this.enhancer.enhance(this.determineClassName(classFile), Files.readAllBytes(classFile.toPath()));
            if (newBytes != null) {
                this.writeByteCodeToFile(newBytes, classFile);
                this.getLog().info((CharSequence)SUCCESFULLY_ENHANCED_CLASS_FILE.formatted(classFile));
            } else {
                this.getLog().info((CharSequence)SKIPPING_FILE.formatted(classFile));
            }
        }
        catch (IOException | EnhancementException e) {
            this.getLog().error((CharSequence)ERROR_WHILE_ENHANCING_CLASS_FILE.formatted(classFile), e);
        }
    }

    private void writeByteCodeToFile(byte[] bytes, File file) {
        this.getLog().debug((CharSequence)WRITING_BYTE_CODE_TO_FILE.formatted(file));
        if (this.clearFile(file)) {
            try {
                Files.write(file.toPath(), bytes, new OpenOption[0]);
                this.getLog().debug((CharSequence)AMOUNT_BYTES_WRITTEN_TO_FILE.formatted(bytes.length, file));
            }
            catch (FileNotFoundException e) {
                this.getLog().error((CharSequence)ERROR_OPENING_FILE_FOR_WRITING.formatted(file), (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)ERROR_WRITING_BYTES_TO_FILE.formatted(file), (Throwable)e);
            }
        }
    }

    private boolean clearFile(File file) {
        boolean success;
        block5: {
            this.getLog().debug((CharSequence)TRYING_TO_CLEAR_FILE.formatted(file));
            success = false;
            if (file.delete()) {
                try {
                    if (!file.createNewFile()) {
                        this.getLog().error((CharSequence)UNABLE_TO_CREATE_FILE.formatted(file));
                        break block5;
                    }
                    this.getLog().info((CharSequence)SUCCESFULLY_CLEARED_FILE.formatted(file));
                    success = true;
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)PROBLEM_CLEARING_FILE.formatted(file), (Throwable)e);
                }
            } else {
                this.getLog().error((CharSequence)UNABLE_TO_DELETE_FILE.formatted(file));
            }
        }
        return success;
    }
}

