/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessType;
import org.hibernate.processor.util.AccessTypeInformation;

public final class Context {
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_PERSISTENCE_XML_LOCATION = "/META-INF/persistence.xml";
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metamodel> metaEntities = new HashMap<String, Metamodel>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metamodel> metaEmbeddables = new HashMap<String, Metamodel>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metamodel> dataMetaEntities = new HashMap<String, Metamodel>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metamodel> dataMetaEmbeddables = new HashMap<String, Metamodel>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Metamodel> metaAuxiliaries = new HashMap<String, Metamodel>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AccessTypeInformation> accessTypeInformation = new HashMap<String, AccessTypeInformation>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized CharSequence> elementsToRedo = new HashSet<CharSequence>();
    private final @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnvironment;
    private final @UnknownKeyFor @NonNull @Initialized boolean logDebug;
    private final @UnknownKeyFor @NonNull @Initialized boolean lazyXmlParsing;
    private final @UnknownKeyFor @NonNull @Initialized String persistenceXmlLocation;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ormXmlFiles;
    private @UnknownKeyFor @NonNull @Initialized Boolean fullyXmlConfigured;
    private @UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation = false;
    private @UnknownKeyFor @NonNull @Initialized boolean addDependentAnnotation = false;
    private @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation = false;
    private @UnknownKeyFor @NonNull @Initialized boolean addGeneratedAnnotation = true;
    private @UnknownKeyFor @NonNull @Initialized boolean addGenerationDate;
    private @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] suppressedWarnings;
    private @UnknownKeyFor @NonNull @Initialized boolean addTransactionScopedAnnotation;
    private @UnknownKeyFor @NonNull @Initialized AccessType persistenceUnitDefaultAccessType;
    private @UnknownKeyFor @NonNull @Initialized boolean generateJakartaDataStaticMetamodel;
    private @UnknownKeyFor @NonNull @Initialized boolean quarkusInjection;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Metamodel> generatedModelClasses = new HashSet<Metamodel>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> checkedNamedQueries = new HashSet<String>();
    private @UnknownKeyFor @NonNull @Initialized boolean usesQuarkusOrm = false;
    private @UnknownKeyFor @NonNull @Initialized boolean usesQuarkusReactive = false;
    private @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] includes = new String[]{"*"};
    private @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] excludes = new String[0];
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> entityNameMappings = new HashMap<String, String>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> enumTypesByValue = new HashMap<String, Set<String>>();

    /*
     * WARNING - void declaration
     */
    public Context(@UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        Map<String, String> options = processingEnvironment.getOptions();
        Object persistenceXmlOption = options.get("persistenceXml");
        if (persistenceXmlOption != null) {
            if (!((String)persistenceXmlOption).startsWith("/")) {
                persistenceXmlOption = "/" + (String)persistenceXmlOption;
            }
            this.persistenceXmlLocation = persistenceXmlOption;
        } else {
            this.persistenceXmlLocation = DEFAULT_PERSISTENCE_XML_LOCATION;
        }
        String ormXmlOption = options.get("ormXml");
        if (ormXmlOption != null) {
            this.ormXmlFiles = new ArrayList<String>();
            for (String string : ormXmlOption.split(",")) {
                void var8_8;
                if (!string.startsWith("/")) {
                    String string2 = "/" + string;
                }
                this.ormXmlFiles.add((String)var8_8);
            }
        } else {
            this.ormXmlFiles = Collections.emptyList();
        }
        this.lazyXmlParsing = Boolean.parseBoolean(options.get("lazyXmlParsing"));
        this.logDebug = Boolean.parseBoolean(options.get("debug"));
    }

    public @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean generateJakartaDataStaticMetamodel() {
        return this.generateJakartaDataStaticMetamodel;
    }

    public void setGenerateJakartaDataStaticMetamodel(@UnknownKeyFor @NonNull @Initialized boolean generateJakartaDataStaticMetamodel) {
        this.generateJakartaDataStaticMetamodel = generateJakartaDataStaticMetamodel;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation() {
        return this.addInjectAnnotation;
    }

    public void setAddInjectAnnotation(@UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation) {
        this.addInjectAnnotation = addInjectAnnotation;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean addDependentAnnotation() {
        return this.addDependentAnnotation;
    }

    public void setAddDependentAnnotation(@UnknownKeyFor @NonNull @Initialized boolean addDependentAnnotation) {
        this.addDependentAnnotation = addDependentAnnotation;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation() {
        return this.addNonnullAnnotation;
    }

    public void setAddNonnullAnnotation(@UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation) {
        this.addNonnullAnnotation = addNonnullAnnotation;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean addGeneratedAnnotation() {
        return this.addGeneratedAnnotation;
    }

    public void setAddGeneratedAnnotation(@UnknownKeyFor @NonNull @Initialized boolean addGeneratedAnnotation) {
        this.addGeneratedAnnotation = addGeneratedAnnotation;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean addGeneratedDate() {
        return this.addGenerationDate;
    }

    public void setAddGenerationDate(@UnknownKeyFor @NonNull @Initialized boolean addGenerationDate) {
        this.addGenerationDate = addGenerationDate;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean addSuppressWarningsAnnotation() {
        return this.suppressedWarnings != null;
    }

    public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getSuppressedWarnings() {
        return this.suppressedWarnings;
    }

    public void setSuppressedWarnings(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] suppressedWarnings) {
        this.suppressedWarnings = suppressedWarnings;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean addTransactionScopedAnnotation() {
        return this.addTransactionScopedAnnotation;
    }

    public void setAddTransactionScopedAnnotation(@UnknownKeyFor @NonNull @Initialized boolean addTransactionScopedAnnotation) {
        this.addTransactionScopedAnnotation = addTransactionScopedAnnotation;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isQuarkusInjection() {
        return this.quarkusInjection;
    }

    public void setQuarkusInjection(@UnknownKeyFor @NonNull @Initialized boolean quarkusInjection) {
        this.quarkusInjection = quarkusInjection;
    }

    public @UnknownKeyFor @NonNull @Initialized Elements getElementUtils() {
        return this.processingEnvironment.getElementUtils();
    }

    public @UnknownKeyFor @NonNull @Initialized Types getTypeUtils() {
        return this.processingEnvironment.getTypeUtils();
    }

    public @UnknownKeyFor @NonNull @Initialized String getPersistenceXmlLocation() {
        return this.persistenceXmlLocation;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getOrmXmlFiles() {
        return this.ormXmlFiles;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean containsMetaEntity(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.metaEntities.containsKey(qualifiedName);
    }

    public @Nullable @UnknownKeyFor @Initialized Metamodel getMetaEntity(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.metaEntities.get(qualifiedName);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Metamodel> getMetaEntities() {
        return this.metaEntities.values();
    }

    public void addMetaEntity(@UnknownKeyFor @NonNull @Initialized String qualifiedName, @UnknownKeyFor @NonNull @Initialized Metamodel metaEntity) {
        this.metaEntities.put(qualifiedName, metaEntity);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean containsMetaEmbeddable(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.metaEmbeddables.containsKey(qualifiedName);
    }

    public @Nullable @UnknownKeyFor @Initialized Metamodel getMetaEmbeddable(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.metaEmbeddables.get(qualifiedName);
    }

    public void addMetaEmbeddable(@UnknownKeyFor @NonNull @Initialized String qualifiedName, @UnknownKeyFor @NonNull @Initialized Metamodel metaEntity) {
        this.metaEmbeddables.put(qualifiedName, metaEntity);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Metamodel> getMetaEmbeddables() {
        return this.metaEmbeddables.values();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean containsDataMetaEntity(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.dataMetaEntities.containsKey(qualifiedName);
    }

    public @Nullable @UnknownKeyFor @Initialized Metamodel getDataMetaEntity(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.dataMetaEntities.get(qualifiedName);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Metamodel> getDataMetaEntities() {
        return this.dataMetaEntities.values();
    }

    public void addDataMetaEntity(@UnknownKeyFor @NonNull @Initialized String qualifiedName, @UnknownKeyFor @NonNull @Initialized Metamodel metaEntity) {
        this.dataMetaEntities.put(qualifiedName, metaEntity);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean containsDataMetaEmbeddable(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.dataMetaEmbeddables.containsKey(qualifiedName);
    }

    public @Nullable @UnknownKeyFor @Initialized Metamodel getDataMetaEmbeddable(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.dataMetaEmbeddables.get(qualifiedName);
    }

    public void addDataMetaEmbeddable(@UnknownKeyFor @NonNull @Initialized String qualifiedName, @UnknownKeyFor @NonNull @Initialized Metamodel metaEntity) {
        this.dataMetaEmbeddables.put(qualifiedName, metaEntity);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Metamodel> getDataMetaEmbeddables() {
        return this.dataMetaEmbeddables.values();
    }

    public @Nullable @UnknownKeyFor @Initialized Metamodel getMetaAuxiliary(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.metaAuxiliaries.get(qualifiedName);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Metamodel> getMetaAuxiliaries() {
        return this.metaAuxiliaries.values();
    }

    public void addMetaAuxiliary(@UnknownKeyFor @NonNull @Initialized String qualifiedName, @UnknownKeyFor @NonNull @Initialized Metamodel metamodel) {
        this.metaAuxiliaries.put(qualifiedName, metamodel);
    }

    public void addAccessTypeInformation(@UnknownKeyFor @NonNull @Initialized String qualifiedName, @UnknownKeyFor @NonNull @Initialized AccessTypeInformation info) {
        this.accessTypeInformation.put(qualifiedName, info);
    }

    public @Nullable @UnknownKeyFor @Initialized AccessTypeInformation getAccessTypeInfo(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.accessTypeInformation.get(qualifiedName);
    }

    public @UnknownKeyFor @NonNull @Initialized TypeElement getTypeElementForFullyQualifiedName(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.processingEnvironment.getElementUtils().getTypeElement(qualifiedName);
    }

    void markGenerated(@UnknownKeyFor @NonNull @Initialized Metamodel metamodel) {
        this.generatedModelClasses.add(metamodel);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isAlreadyGenerated(@UnknownKeyFor @NonNull @Initialized Metamodel metamodel) {
        return this.generatedModelClasses.contains(metamodel);
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized CharSequence> getElementsToRedo() {
        return this.elementsToRedo;
    }

    public void addElementToRedo(@UnknownKeyFor @NonNull @Initialized CharSequence qualifiedName) {
        this.elementsToRedo.add(qualifiedName);
    }

    public void removeElementToRedo(@UnknownKeyFor @NonNull @Initialized CharSequence qualifiedName) {
        this.elementsToRedo.remove(qualifiedName);
    }

    public void logMessage( @UnknownKeyFor @NonNull @Initialized Diagnostic.Kind type, @UnknownKeyFor @NonNull @Initialized String message) {
        if (this.logDebug || type != Diagnostic.Kind.OTHER) {
            this.processingEnvironment.getMessager().printMessage(type, message);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isFullyXmlConfigured() {
        return this.fullyXmlConfigured != null && this.fullyXmlConfigured != false;
    }

    public void mappingDocumentFullyXmlConfigured(@UnknownKeyFor @NonNull @Initialized boolean fullyXmlConfigured) {
        this.fullyXmlConfigured = this.fullyXmlConfigured == null ? fullyXmlConfigured : this.fullyXmlConfigured != false && fullyXmlConfigured;
    }

    public @UnknownKeyFor @NonNull @Initialized AccessType getPersistenceUnitDefaultAccessType() {
        return this.persistenceUnitDefaultAccessType;
    }

    public void setPersistenceUnitDefaultAccessType(@UnknownKeyFor @NonNull @Initialized AccessType persistenceUnitDefaultAccessType) {
        this.persistenceUnitDefaultAccessType = persistenceUnitDefaultAccessType;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean doLazyXmlParsing() {
        return this.lazyXmlParsing;
    }

    public void message(@UnknownKeyFor @NonNull @Initialized Element method, @UnknownKeyFor @NonNull @Initialized String message,  @UnknownKeyFor @NonNull @Initialized Diagnostic.Kind severity) {
        this.getProcessingEnvironment().getMessager().printMessage(severity, message, method);
    }

    public void message(@UnknownKeyFor @NonNull @Initialized Element method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String message,  @UnknownKeyFor @NonNull @Initialized Diagnostic.Kind severity) {
        this.getProcessingEnvironment().getMessager().printMessage(severity, message, method, mirror, value);
    }

    public void message(@UnknownKeyFor @NonNull @Initialized Element method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String message,  @UnknownKeyFor @NonNull @Initialized Diagnostic.Kind severity) {
        this.getProcessingEnvironment().getMessager().printMessage(severity, message, method, mirror);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Context");
        sb.append("{accessTypeInformation=").append(this.accessTypeInformation);
        sb.append(", logDebug=").append(this.logDebug);
        sb.append(", lazyXmlParsing=").append(this.lazyXmlParsing);
        sb.append(", fullyXmlConfigured=").append(this.fullyXmlConfigured);
        sb.append(", ormXmlFiles=").append(this.ormXmlFiles);
        sb.append(", persistenceXmlLocation='").append(this.persistenceXmlLocation).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean checkNamedQuery(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.checkedNamedQueries.add(name);
    }

    public void setUsesQuarkusOrm(@UnknownKeyFor @NonNull @Initialized boolean b) {
        this.usesQuarkusOrm = b;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean usesQuarkusOrm() {
        return this.usesQuarkusOrm;
    }

    public void setUsesQuarkusReactive(@UnknownKeyFor @NonNull @Initialized boolean b) {
        this.usesQuarkusReactive = b;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean usesQuarkusReactive() {
        return this.usesQuarkusReactive;
    }

    public void setInclude(@UnknownKeyFor @NonNull @Initialized String include) {
        this.includes = include.split(",\\s*");
    }

    public void setExclude(@UnknownKeyFor @NonNull @Initialized String exclude) {
        this.excludes = exclude.isBlank() ? ArrayHelper.EMPTY_STRING_ARRAY : exclude.split(",\\s*");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isIncluded(@UnknownKeyFor @NonNull @Initialized String typeName) {
        for (String include : this.includes) {
            if (!this.matches(typeName, include)) continue;
            for (String exclude : this.excludes) {
                if (!this.matches(typeName, exclude)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String pattern) {
        return "*".equals(pattern) || name.equals(pattern) || pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1)) || pattern.startsWith("*") && name.endsWith(pattern.substring(1)) || pattern.startsWith("*") && pattern.endsWith("*") && name.contains(pattern.substring(1, pattern.length() - 1));
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Element> getAllMembers(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        List<? extends Element> elements = type.getEnclosedElements();
        ArrayList<Element> list = new ArrayList<Element>(elements);
        TypeMirror superclass = type.getSuperclass();
        if (superclass.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)superclass;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            for (Element inherited : this.getAllMembers(typeElement)) {
                if (!this.notOverridden(type, inherited, elements)) continue;
                list.add(inherited);
            }
        }
        for (TypeMirror typeMirror : type.getInterfaces()) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            for (Element inherited : this.getAllMembers(typeElement)) {
                if (!this.notOverridden(type, inherited, elements)) continue;
                list.add(inherited);
            }
        }
        return list;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean notOverridden(@UnknownKeyFor @NonNull @Initialized TypeElement type, @UnknownKeyFor @NonNull @Initialized Element inherited, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Element> elements) {
        return !(inherited instanceof ExecutableElement) || elements.stream().noneMatch(member -> member instanceof ExecutableElement && this.getElementUtils().overrides((ExecutableElement)member, (ExecutableElement)inherited, type));
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getEntityNameMappings() {
        return this.entityNameMappings;
    }

    public void addEntityNameMapping(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        this.entityNameMappings.put(entityName, qualifiedName);
    }

    public @Nullable @UnknownKeyFor @Initialized String qualifiedNameForEntityName(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return this.entityNameMappings.get(entityName);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> getEnumTypesByValue() {
        return this.enumTypesByValue;
    }

    public void addEnumValue(@UnknownKeyFor @NonNull @Initialized String qualifiedTypeName, @UnknownKeyFor @NonNull @Initialized String shortTypeName, @Nullable @UnknownKeyFor @Initialized String outerTypeQualifiedName, @Nullable @UnknownKeyFor @Initialized String outerShortTypeName, @UnknownKeyFor @NonNull @Initialized String value) {
        this.addEnumValue(qualifiedTypeName, value);
        this.addEnumValue(qualifiedTypeName, qualifiedTypeName + "." + value);
        this.addEnumValue(qualifiedTypeName, shortTypeName + "." + value);
        if (outerShortTypeName != null) {
            this.addEnumValue(qualifiedTypeName, outerShortTypeName + "." + shortTypeName + "." + value);
            this.addEnumValue(qualifiedTypeName, outerShortTypeName + "$" + shortTypeName + "." + value);
            this.addEnumValue(qualifiedTypeName, outerTypeQualifiedName + "$" + shortTypeName + "." + value);
        }
    }

    private void addEnumValue(@UnknownKeyFor @NonNull @Initialized String qualifiedTypeName, @UnknownKeyFor @NonNull @Initialized String value) {
        this.enumTypesByValue.computeIfAbsent(value, s -> new TreeSet()).add(qualifiedTypeName);
    }
}

