/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.util.NullnessUtil;
import org.hibernate.jpamodelgen.util.xml.ContextProvidingValidationEventHandler;
import org.hibernate.jpamodelgen.util.xml.JpaNamespaceTransformingEventReader;
import org.hibernate.jpamodelgen.util.xml.XmlParsingException;
import org.hibernate.jpamodelgen.xml.jaxb.ObjectFactory;
import org.xml.sax.SAXException;

public class XmlParserHelper {
    private static final @UnknownKeyFor @NonNull @Initialized String RESOURCE_PATH_SEPARATOR = "/";
    private static final @UnknownKeyFor @NonNull @Initialized int NUMBER_OF_SCHEMAS = 4;
    private static final @UnknownKeyFor @NonNull @Initialized XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Schema> SCHEMA_CACHE = new ConcurrentHashMap<String, Schema>(4);
    private final @UnknownKeyFor @NonNull @Initialized Context context;

    public XmlParserHelper(@UnknownKeyFor @NonNull @Initialized Context context) {
        this.context = context;
    }

    public @Nullable @UnknownKeyFor @Initialized InputStream getInputStreamForResource(@UnknownKeyFor @NonNull @Initialized String resource) {
        InputStream ormStream;
        if (!((String)resource).startsWith(RESOURCE_PATH_SEPARATOR)) {
            resource = RESOURCE_PATH_SEPARATOR + (String)resource;
        }
        String pkg = this.getPackage((String)resource);
        String name = this.getRelativeName((String)resource);
        try {
            FileObject fileObject = this.context.getProcessingEnvironment().getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, name);
            ormStream = fileObject.openInputStream();
        }
        catch (IOException e1) {
            ormStream = this.getClass().getResourceAsStream((String)resource);
        }
        return ormStream;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getSchema(@UnknownKeyFor @NonNull @Initialized String schemaResource) throws @UnknownKeyFor @NonNull @Initialized XmlParsingException {
        Schema schema = (Schema)SCHEMA_CACHE.get(schemaResource);
        if (schema != null) {
            return schema;
        }
        schema = this.loadSchema(schemaResource);
        Schema previous = SCHEMA_CACHE.putIfAbsent(schemaResource, schema);
        return previous != null ? previous : schema;
    }

    public <T> T getJaxbRoot(@UnknownKeyFor @NonNull @Initialized InputStream stream, @UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized Schema schema) throws @UnknownKeyFor @NonNull @Initialized XmlParsingException {
        XMLEventReader staxEventReader;
        try {
            staxEventReader = this.createXmlEventReader(stream);
        }
        catch (XMLStreamException e) {
            throw new XmlParsingException("Unable to create stax reader", e);
        }
        ContextProvidingValidationEventHandler handler = new ContextProvidingValidationEventHandler();
        try {
            staxEventReader = new JpaNamespaceTransformingEventReader(staxEventReader);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)handler);
            return clazz.cast(unmarshaller.unmarshal(staxEventReader));
        }
        catch (JAXBException e) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unable to perform unmarshalling at line number ");
            builder.append(handler.getLineNumber());
            builder.append(" and column ");
            builder.append(handler.getColumnNumber());
            builder.append(". Message: ");
            builder.append(handler.getMessage());
            throw new XmlParsingException(builder.toString(), e);
        }
    }

    private synchronized @UnknownKeyFor @NonNull @Initialized XMLEventReader createXmlEventReader(@UnknownKeyFor @NonNull @Initialized InputStream xmlStream) throws @UnknownKeyFor @NonNull @Initialized XMLStreamException {
        return XML_INPUT_FACTORY.createXMLEventReader(xmlStream);
    }

    private @UnknownKeyFor @NonNull @Initialized String getPackage(@UnknownKeyFor @NonNull @Initialized String resourceName) {
        if (!resourceName.contains(RESOURCE_PATH_SEPARATOR)) {
            return "";
        }
        return resourceName.substring(0, resourceName.lastIndexOf(RESOURCE_PATH_SEPARATOR));
    }

    private @UnknownKeyFor @NonNull @Initialized String getRelativeName(@UnknownKeyFor @NonNull @Initialized String resourceName) {
        if (!resourceName.contains(RESOURCE_PATH_SEPARATOR)) {
            return resourceName;
        }
        return resourceName.substring(resourceName.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }

    private @UnknownKeyFor @NonNull @Initialized Schema loadSchema(@UnknownKeyFor @NonNull @Initialized String schemaName) throws @UnknownKeyFor @NonNull @Initialized XmlParsingException {
        URL schemaUrl = NullnessUtil.castNonNull(this.getClass().getClassLoader()).getResource(schemaName);
        if (schemaUrl == null) {
            throw new IllegalArgumentException("Couldn't find schema on classpath: " + schemaName);
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            throw new XmlParsingException("Unable to create schema for " + schemaName + ": " + e.getMessage(), e);
        }
    }
}

