/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.jfr.internal;

import java.util.Objects;
import jdk.jfr.EventType;
import org.hibernate.LockMode;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.jfr.internal.CacheGetEvent;
import org.hibernate.event.jfr.internal.CachePutEvent;
import org.hibernate.event.jfr.internal.CollectionRecreateEvent;
import org.hibernate.event.jfr.internal.CollectionRemoveEvent;
import org.hibernate.event.jfr.internal.CollectionUpdateEvent;
import org.hibernate.event.jfr.internal.DirtyCalculationEvent;
import org.hibernate.event.jfr.internal.EntityDeleteEvent;
import org.hibernate.event.jfr.internal.EntityInsertEvent;
import org.hibernate.event.jfr.internal.EntityLockEvent;
import org.hibernate.event.jfr.internal.EntityUpdateEvent;
import org.hibernate.event.jfr.internal.EntityUpsertEvent;
import org.hibernate.event.jfr.internal.FlushEvent;
import org.hibernate.event.jfr.internal.JdbcBatchExecutionEvent;
import org.hibernate.event.jfr.internal.JdbcConnectionAcquisitionEvent;
import org.hibernate.event.jfr.internal.JdbcConnectionReleaseEvent;
import org.hibernate.event.jfr.internal.JdbcPreparedStatementCreationEvent;
import org.hibernate.event.jfr.internal.JdbcPreparedStatementExecutionEvent;
import org.hibernate.event.jfr.internal.PartialFlushEvent;
import org.hibernate.event.jfr.internal.PrePartialFlushEvent;
import org.hibernate.event.jfr.internal.SessionClosedEvent;
import org.hibernate.event.jfr.internal.SessionOpenEvent;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.internal.build.AllowNonPortable;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.internal.StatsHelper;

@AllowNonPortable
public class JfrEventMonitor
implements EventMonitor {
    private static final EventType sessionOpenEventType = EventType.getEventType(SessionOpenEvent.class);
    private static final EventType sessionClosedEventType = EventType.getEventType(SessionClosedEvent.class);
    private static final EventType jdbcConnectionAcquisitionEventType = EventType.getEventType(JdbcConnectionAcquisitionEvent.class);
    private static final EventType jdbcConnectionReleaseEventType = EventType.getEventType(JdbcConnectionReleaseEvent.class);
    private static final EventType jdbcPreparedStatementCreationEventType = EventType.getEventType(JdbcPreparedStatementCreationEvent.class);
    private static final EventType jdbcPreparedStatementExecutionEventType = EventType.getEventType(JdbcPreparedStatementExecutionEvent.class);
    private static final EventType jdbcBatchExecutionEventType = EventType.getEventType(JdbcBatchExecutionEvent.class);
    private static final EventType cachePutEventType = EventType.getEventType(CachePutEvent.class);
    private static final EventType cacheGetEventType = EventType.getEventType(CacheGetEvent.class);
    private static final EventType flushEventType = EventType.getEventType(FlushEvent.class);
    private static final EventType partialFlushEventType = EventType.getEventType(PartialFlushEvent.class);
    private static final EventType dirtyCalculationEventType = EventType.getEventType(DirtyCalculationEvent.class);
    private static final EventType prePartialFlushEventType = EventType.getEventType(PrePartialFlushEvent.class);
    private static final EventType entityInsertEventType = EventType.getEventType(EntityInsertEvent.class);
    private static final EventType entityUpdateEventType = EventType.getEventType(EntityUpdateEvent.class);
    private static final EventType entityUpsertEventType = EventType.getEventType(EntityUpsertEvent.class);
    private static final EventType entityDeleteEventType = EventType.getEventType(EntityDeleteEvent.class);
    private static final EventType entityLockEventType = EventType.getEventType(EntityLockEvent.class);
    private static final EventType collectionRecreateEventType = EventType.getEventType(CollectionRecreateEvent.class);
    private static final EventType collectionUpdateEventType = EventType.getEventType(CollectionUpdateEvent.class);
    private static final EventType collectionRemoveEventType = EventType.getEventType(CollectionRemoveEvent.class);

    public SessionOpenEvent beginSessionOpenEvent() {
        if (sessionOpenEventType.isEnabled()) {
            SessionOpenEvent sessionOpenEvent = new SessionOpenEvent();
            sessionOpenEvent.begin();
            return sessionOpenEvent;
        }
        return null;
    }

    public void completeSessionOpenEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session) {
        if (monitoringEvent != null) {
            SessionOpenEvent sessionOpenEvent = (SessionOpenEvent)monitoringEvent;
            sessionOpenEvent.end();
            if (sessionOpenEvent.shouldCommit()) {
                sessionOpenEvent.sessionIdentifier = this.getSessionIdentifier(session);
                sessionOpenEvent.commit();
            }
        }
    }

    public SessionClosedEvent beginSessionClosedEvent() {
        if (sessionClosedEventType.isEnabled()) {
            SessionClosedEvent sessionClosedEvent = new SessionClosedEvent();
            sessionClosedEvent.begin();
            return sessionClosedEvent;
        }
        return null;
    }

    public void completeSessionClosedEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session) {
        if (monitoringEvent != null) {
            SessionClosedEvent sessionClosedEvent = (SessionClosedEvent)monitoringEvent;
            sessionClosedEvent.end();
            if (sessionClosedEvent.shouldCommit()) {
                sessionClosedEvent.sessionIdentifier = this.getSessionIdentifier(session);
                sessionClosedEvent.commit();
            }
        }
    }

    public JdbcConnectionAcquisitionEvent beginJdbcConnectionAcquisitionEvent() {
        if (jdbcConnectionAcquisitionEventType.isEnabled()) {
            JdbcConnectionAcquisitionEvent jdbcConnectionAcquisitionEvent = new JdbcConnectionAcquisitionEvent();
            jdbcConnectionAcquisitionEvent.begin();
            return jdbcConnectionAcquisitionEvent;
        }
        return null;
    }

    public void completeJdbcConnectionAcquisitionEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, Object tenantId) {
        if (monitoringEvent != null) {
            JdbcConnectionAcquisitionEvent jdbcConnectionAcquisitionEvent = (JdbcConnectionAcquisitionEvent)monitoringEvent;
            jdbcConnectionAcquisitionEvent.end();
            if (jdbcConnectionAcquisitionEvent.shouldCommit()) {
                jdbcConnectionAcquisitionEvent.sessionIdentifier = this.getSessionIdentifier(session);
                jdbcConnectionAcquisitionEvent.tenantIdentifier = tenantId == null ? null : session.getFactory().getTenantIdentifierJavaType().toString(tenantId);
                jdbcConnectionAcquisitionEvent.commit();
            }
        }
    }

    public JdbcConnectionReleaseEvent beginJdbcConnectionReleaseEvent() {
        if (jdbcConnectionReleaseEventType.isEnabled()) {
            JdbcConnectionReleaseEvent jdbcConnectionReleaseEvent = new JdbcConnectionReleaseEvent();
            jdbcConnectionReleaseEvent.begin();
            return jdbcConnectionReleaseEvent;
        }
        return null;
    }

    public void completeJdbcConnectionReleaseEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, Object tenantId) {
        if (monitoringEvent != null) {
            JdbcConnectionReleaseEvent jdbcConnectionReleaseEvent = (JdbcConnectionReleaseEvent)monitoringEvent;
            jdbcConnectionReleaseEvent.end();
            if (jdbcConnectionReleaseEvent.shouldCommit()) {
                jdbcConnectionReleaseEvent.sessionIdentifier = this.getSessionIdentifier(session);
                jdbcConnectionReleaseEvent.tenantIdentifier = tenantId == null ? null : session.getFactory().getTenantIdentifierJavaType().toString(tenantId);
                jdbcConnectionReleaseEvent.commit();
            }
        }
    }

    public JdbcPreparedStatementCreationEvent beginJdbcPreparedStatementCreationEvent() {
        if (jdbcPreparedStatementCreationEventType.isEnabled()) {
            JdbcPreparedStatementCreationEvent jdbcPreparedStatementCreation = new JdbcPreparedStatementCreationEvent();
            jdbcPreparedStatementCreation.begin();
            return jdbcPreparedStatementCreation;
        }
        return null;
    }

    public void completeJdbcPreparedStatementCreationEvent(DiagnosticEvent monitoringEvent, String preparedStatementSql) {
        if (monitoringEvent != null) {
            JdbcPreparedStatementCreationEvent jdbcPreparedStatementCreation = (JdbcPreparedStatementCreationEvent)monitoringEvent;
            jdbcPreparedStatementCreation.end();
            if (jdbcPreparedStatementCreation.shouldCommit()) {
                jdbcPreparedStatementCreation.sql = preparedStatementSql;
                jdbcPreparedStatementCreation.commit();
            }
        }
    }

    public JdbcPreparedStatementExecutionEvent beginJdbcPreparedStatementExecutionEvent() {
        if (jdbcPreparedStatementExecutionEventType.isEnabled()) {
            JdbcPreparedStatementExecutionEvent jdbcPreparedStatementExecutionEvent = new JdbcPreparedStatementExecutionEvent();
            jdbcPreparedStatementExecutionEvent.begin();
            return jdbcPreparedStatementExecutionEvent;
        }
        return null;
    }

    public void completeJdbcPreparedStatementExecutionEvent(DiagnosticEvent monitoringEvent, String preparedStatementSql) {
        if (monitoringEvent != null) {
            JdbcPreparedStatementExecutionEvent jdbcPreparedStatementExecutionEvent = (JdbcPreparedStatementExecutionEvent)monitoringEvent;
            jdbcPreparedStatementExecutionEvent.end();
            if (jdbcPreparedStatementExecutionEvent.shouldCommit()) {
                jdbcPreparedStatementExecutionEvent.sql = preparedStatementSql;
                jdbcPreparedStatementExecutionEvent.commit();
            }
        }
    }

    public JdbcBatchExecutionEvent beginJdbcBatchExecutionEvent() {
        if (jdbcBatchExecutionEventType.isEnabled()) {
            JdbcBatchExecutionEvent jdbcBatchExecutionEvent = new JdbcBatchExecutionEvent();
            jdbcBatchExecutionEvent.begin();
            return jdbcBatchExecutionEvent;
        }
        return null;
    }

    public void completeJdbcBatchExecutionEvent(DiagnosticEvent monitoringEvent, String statementSql) {
        if (monitoringEvent != null) {
            JdbcBatchExecutionEvent jdbcBatchExecutionEvent = (JdbcBatchExecutionEvent)monitoringEvent;
            jdbcBatchExecutionEvent.end();
            if (jdbcBatchExecutionEvent.shouldCommit()) {
                jdbcBatchExecutionEvent.sql = statementSql;
                jdbcBatchExecutionEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginCachePutEvent() {
        if (cachePutEventType.isEnabled()) {
            CachePutEvent cachePutEvent = new CachePutEvent();
            cachePutEvent.begin();
            return cachePutEvent;
        }
        return null;
    }

    public void completeCachePutEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, Region region, boolean cacheContentChanged, EventMonitor.CacheActionDescription description) {
        if (monitoringEvent != null) {
            CachePutEvent cachePutEvent = (CachePutEvent)monitoringEvent;
            cachePutEvent.end();
            if (cachePutEvent.shouldCommit()) {
                cachePutEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cachePutEvent.regionName = region.getName();
                cachePutEvent.description = description.getText();
                cachePutEvent.cacheChanged = cacheContentChanged;
                cachePutEvent.commit();
            }
        }
    }

    public void completeCachePutEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, CachedDomainDataAccess cachedDomainDataAccess, EntityPersister persister, boolean cacheContentChanged, EventMonitor.CacheActionDescription description) {
        this.completeCachePutEvent(monitoringEvent, session, cachedDomainDataAccess, persister, cacheContentChanged, false, description);
    }

    public void completeCachePutEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, CachedDomainDataAccess cachedDomainDataAccess, EntityPersister persister, boolean cacheContentChanged, boolean isNatualId, EventMonitor.CacheActionDescription description) {
        if (monitoringEvent != null) {
            CachePutEvent cachePutEvent = (CachePutEvent)monitoringEvent;
            cachePutEvent.end();
            if (cachePutEvent.shouldCommit()) {
                cachePutEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cachePutEvent.regionName = cachedDomainDataAccess.getRegion().getName();
                cachePutEvent.entityName = this.getEntityName(persister);
                cachePutEvent.description = description.getText();
                cachePutEvent.isNaturalId = isNatualId;
                cachePutEvent.cacheChanged = cacheContentChanged;
                cachePutEvent.commit();
            }
        }
    }

    public void completeCachePutEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, CachedDomainDataAccess cachedDomainDataAccess, CollectionPersister persister, boolean cacheContentChanged, EventMonitor.CacheActionDescription description) {
        if (monitoringEvent != null) {
            CachePutEvent cachePutEvent = (CachePutEvent)monitoringEvent;
            cachePutEvent.end();
            if (cachePutEvent.shouldCommit()) {
                cachePutEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cachePutEvent.regionName = cachedDomainDataAccess.getRegion().getName();
                cachePutEvent.collectionName = persister.getNavigableRole().getFullPath();
                cachePutEvent.description = description.getText();
                cachePutEvent.cacheChanged = cacheContentChanged;
                cachePutEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginCacheGetEvent() {
        if (cacheGetEventType.isEnabled()) {
            CacheGetEvent cacheGetEvent = new CacheGetEvent();
            cacheGetEvent.begin();
            return cacheGetEvent;
        }
        return null;
    }

    public void completeCacheGetEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, Region region, boolean hit) {
        if (monitoringEvent != null) {
            CacheGetEvent cacheGetEvent = (CacheGetEvent)monitoringEvent;
            cacheGetEvent.end();
            if (cacheGetEvent.shouldCommit()) {
                cacheGetEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cacheGetEvent.regionName = region.getName();
                cacheGetEvent.hit = hit;
                cacheGetEvent.commit();
            }
        }
    }

    public void completeCacheGetEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, Region region, EntityPersister persister, boolean isNaturalKey, boolean hit) {
        if (monitoringEvent != null) {
            CacheGetEvent cacheGetEvent = (CacheGetEvent)monitoringEvent;
            cacheGetEvent.end();
            if (cacheGetEvent.shouldCommit()) {
                cacheGetEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cacheGetEvent.entityName = this.getEntityName(persister);
                cacheGetEvent.regionName = region.getName();
                cacheGetEvent.isNaturalId = isNaturalKey;
                cacheGetEvent.hit = hit;
                cacheGetEvent.commit();
            }
        }
    }

    public void completeCacheGetEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, Region region, CollectionPersister persister, boolean hit) {
        if (monitoringEvent != null) {
            CacheGetEvent cacheGetEvent = (CacheGetEvent)monitoringEvent;
            cacheGetEvent.end();
            if (cacheGetEvent.shouldCommit()) {
                cacheGetEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cacheGetEvent.collectionName = persister.getNavigableRole().getFullPath();
                cacheGetEvent.regionName = region.getName();
                cacheGetEvent.hit = hit;
                cacheGetEvent.commit();
            }
        }
    }

    public FlushEvent beginFlushEvent() {
        if (flushEventType.isEnabled()) {
            FlushEvent flushEvent = new FlushEvent();
            flushEvent.begin();
            return flushEvent;
        }
        return null;
    }

    public void completeFlushEvent(DiagnosticEvent flushEvent, org.hibernate.event.spi.FlushEvent event) {
        this.completeFlushEvent(flushEvent, event, false);
    }

    public void completeFlushEvent(DiagnosticEvent monitoringEvent, org.hibernate.event.spi.FlushEvent hibernateFlushEvent, boolean autoFlush) {
        if (monitoringEvent != null) {
            FlushEvent jfrFlushEvent = (FlushEvent)monitoringEvent;
            jfrFlushEvent.end();
            if (jfrFlushEvent.shouldCommit()) {
                jfrFlushEvent.sessionIdentifier = this.getSessionIdentifier((SharedSessionContractImplementor)hibernateFlushEvent.getSession());
                jfrFlushEvent.numberOfEntitiesProcessed = hibernateFlushEvent.getNumberOfEntitiesProcessed();
                jfrFlushEvent.numberOfCollectionsProcessed = hibernateFlushEvent.getNumberOfCollectionsProcessed();
                jfrFlushEvent.isAutoFlush = autoFlush;
                jfrFlushEvent.commit();
            }
        }
    }

    public PartialFlushEvent beginPartialFlushEvent() {
        if (partialFlushEventType.isEnabled()) {
            PartialFlushEvent partialFlushEvent = new PartialFlushEvent();
            partialFlushEvent.begin();
            return partialFlushEvent;
        }
        return null;
    }

    public void completePartialFlushEvent(DiagnosticEvent monitoringEvent, AutoFlushEvent hibernateAutoFlushEvent) {
        if (monitoringEvent != null) {
            PartialFlushEvent jfrPartialFlushEvent = (PartialFlushEvent)monitoringEvent;
            jfrPartialFlushEvent.end();
            if (jfrPartialFlushEvent.shouldCommit()) {
                jfrPartialFlushEvent.sessionIdentifier = this.getSessionIdentifier((SharedSessionContractImplementor)hibernateAutoFlushEvent.getSession());
                jfrPartialFlushEvent.numberOfEntitiesProcessed = hibernateAutoFlushEvent.getNumberOfEntitiesProcessed();
                jfrPartialFlushEvent.numberOfCollectionsProcessed = hibernateAutoFlushEvent.getNumberOfCollectionsProcessed();
                jfrPartialFlushEvent.isAutoFlush = true;
                jfrPartialFlushEvent.commit();
            }
        }
    }

    public DirtyCalculationEvent beginDirtyCalculationEvent() {
        if (dirtyCalculationEventType.isEnabled()) {
            DirtyCalculationEvent dirtyCalculationEvent = new DirtyCalculationEvent();
            dirtyCalculationEvent.begin();
            return dirtyCalculationEvent;
        }
        return null;
    }

    public void completeDirtyCalculationEvent(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session, EntityPersister persister, EntityEntry entry, int[] dirtyProperties) {
        if (monitoringEvent != null) {
            DirtyCalculationEvent dirtyCalculationEvent = (DirtyCalculationEvent)monitoringEvent;
            dirtyCalculationEvent.end();
            if (dirtyCalculationEvent.shouldCommit()) {
                dirtyCalculationEvent.sessionIdentifier = this.getSessionIdentifier(session);
                dirtyCalculationEvent.entityName = this.getEntityName(persister);
                dirtyCalculationEvent.entityStatus = entry.getStatus().name();
                dirtyCalculationEvent.dirty = dirtyProperties != null;
                dirtyCalculationEvent.commit();
            }
        }
    }

    public PrePartialFlushEvent beginPrePartialFlush() {
        if (prePartialFlushEventType.isEnabled()) {
            PrePartialFlushEvent partialFlushEvent = new PrePartialFlushEvent();
            partialFlushEvent.begin();
            return partialFlushEvent;
        }
        return null;
    }

    public void completePrePartialFlush(DiagnosticEvent monitoringEvent, SharedSessionContractImplementor session) {
        if (monitoringEvent != null) {
            PrePartialFlushEvent prePartialFlushEvent = (PrePartialFlushEvent)monitoringEvent;
            prePartialFlushEvent.end();
            if (prePartialFlushEvent.shouldCommit()) {
                prePartialFlushEvent.sessionIdentifier = this.getSessionIdentifier(session);
                prePartialFlushEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginEntityInsertEvent() {
        if (entityInsertEventType.isEnabled()) {
            EntityInsertEvent event = new EntityInsertEvent();
            event.begin();
            return event;
        }
        return null;
    }

    public void completeEntityInsertEvent(DiagnosticEvent event, Object id, String entityName, boolean success, SharedSessionContractImplementor session) {
        if (event != null) {
            EntityInsertEvent entityInsertEvent = (EntityInsertEvent)event;
            entityInsertEvent.end();
            if (entityInsertEvent.shouldCommit()) {
                entityInsertEvent.sessionIdentifier = this.getSessionIdentifier(session);
                entityInsertEvent.entityName = entityName;
                entityInsertEvent.id = Objects.toString(id);
                entityInsertEvent.success = success;
                entityInsertEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginEntityUpdateEvent() {
        if (entityUpdateEventType.isEnabled()) {
            EntityUpdateEvent event = new EntityUpdateEvent();
            event.begin();
            return event;
        }
        return null;
    }

    public void completeEntityUpdateEvent(DiagnosticEvent event, Object id, String entityName, boolean success, SharedSessionContractImplementor session) {
        if (event != null) {
            EntityUpdateEvent entityUpdateEvent = (EntityUpdateEvent)event;
            entityUpdateEvent.end();
            if (entityUpdateEvent.shouldCommit()) {
                entityUpdateEvent.sessionIdentifier = this.getSessionIdentifier(session);
                entityUpdateEvent.entityName = entityName;
                entityUpdateEvent.id = Objects.toString(id);
                entityUpdateEvent.success = success;
                entityUpdateEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginEntityUpsertEvent() {
        if (entityUpsertEventType.isEnabled()) {
            EntityUpsertEvent event = new EntityUpsertEvent();
            event.begin();
            return event;
        }
        return null;
    }

    public void completeEntityUpsertEvent(DiagnosticEvent event, Object id, String entityName, boolean success, SharedSessionContractImplementor session) {
        if (event != null) {
            EntityUpsertEvent entityUpsertEvent = (EntityUpsertEvent)event;
            entityUpsertEvent.end();
            if (entityUpsertEvent.shouldCommit()) {
                entityUpsertEvent.sessionIdentifier = this.getSessionIdentifier(session);
                entityUpsertEvent.entityName = entityName;
                entityUpsertEvent.id = Objects.toString(id);
                entityUpsertEvent.success = success;
                entityUpsertEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginEntityDeleteEvent() {
        if (entityDeleteEventType.isEnabled()) {
            EntityDeleteEvent event = new EntityDeleteEvent();
            event.begin();
            return event;
        }
        return null;
    }

    public void completeEntityDeleteEvent(DiagnosticEvent event, Object id, String entityName, boolean success, SharedSessionContractImplementor session) {
        if (event != null) {
            EntityDeleteEvent entityDeleteEvent = (EntityDeleteEvent)event;
            entityDeleteEvent.end();
            if (entityDeleteEvent.shouldCommit()) {
                entityDeleteEvent.sessionIdentifier = this.getSessionIdentifier(session);
                entityDeleteEvent.entityName = entityName;
                entityDeleteEvent.id = Objects.toString(id);
                entityDeleteEvent.success = success;
                entityDeleteEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginEntityLockEvent() {
        if (entityLockEventType.isEnabled()) {
            EntityLockEvent event = new EntityLockEvent();
            event.begin();
            return event;
        }
        return null;
    }

    public void completeEntityLockEvent(DiagnosticEvent event, Object id, String entityName, LockMode lockMode, boolean success, SharedSessionContractImplementor session) {
        if (event != null) {
            EntityLockEvent entityLockEvent = (EntityLockEvent)event;
            entityLockEvent.end();
            if (entityLockEvent.shouldCommit()) {
                entityLockEvent.sessionIdentifier = this.getSessionIdentifier(session);
                entityLockEvent.entityName = entityName;
                entityLockEvent.id = Objects.toString(id);
                entityLockEvent.lockMode = lockMode;
                entityLockEvent.success = success;
                entityLockEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginCollectionRecreateEvent() {
        if (collectionRecreateEventType.isEnabled()) {
            CollectionRecreateEvent event = new CollectionRecreateEvent();
            event.begin();
            return event;
        }
        return null;
    }

    public void completeCollectionRecreateEvent(DiagnosticEvent event, Object id, String role, boolean success, SharedSessionContractImplementor session) {
        if (event != null) {
            CollectionRecreateEvent collectionRecreateEvent = (CollectionRecreateEvent)event;
            collectionRecreateEvent.end();
            if (collectionRecreateEvent.shouldCommit()) {
                collectionRecreateEvent.sessionIdentifier = this.getSessionIdentifier(session);
                collectionRecreateEvent.role = role;
                collectionRecreateEvent.id = Objects.toString(id);
                collectionRecreateEvent.success = success;
                collectionRecreateEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginCollectionUpdateEvent() {
        if (collectionUpdateEventType.isEnabled()) {
            CollectionUpdateEvent event = new CollectionUpdateEvent();
            event.begin();
            return event;
        }
        return null;
    }

    public void completeCollectionUpdateEvent(DiagnosticEvent event, Object id, String role, boolean success, SharedSessionContractImplementor session) {
        if (event != null) {
            CollectionUpdateEvent collectionUpdateEvent = (CollectionUpdateEvent)event;
            collectionUpdateEvent.end();
            if (collectionUpdateEvent.shouldCommit()) {
                collectionUpdateEvent.sessionIdentifier = this.getSessionIdentifier(session);
                collectionUpdateEvent.role = role;
                collectionUpdateEvent.id = Objects.toString(id);
                collectionUpdateEvent.success = success;
                collectionUpdateEvent.commit();
            }
        }
    }

    public DiagnosticEvent beginCollectionRemoveEvent() {
        if (collectionRemoveEventType.isEnabled()) {
            CollectionRemoveEvent event = new CollectionRemoveEvent();
            event.begin();
            return event;
        }
        return null;
    }

    public void completeCollectionRemoveEvent(DiagnosticEvent event, Object id, String role, boolean success, SharedSessionContractImplementor session) {
        if (event != null) {
            CollectionRemoveEvent collectionRemoveEvent = (CollectionRemoveEvent)event;
            collectionRemoveEvent.end();
            if (collectionRemoveEvent.shouldCommit()) {
                collectionRemoveEvent.sessionIdentifier = this.getSessionIdentifier(session);
                collectionRemoveEvent.role = role;
                collectionRemoveEvent.id = Objects.toString(id);
                collectionRemoveEvent.success = success;
                collectionRemoveEvent.commit();
            }
        }
    }

    private String getSessionIdentifier(SharedSessionContractImplementor session) {
        if (session == null) {
            return null;
        }
        return session.getSessionIdentifier().toString();
    }

    private String getEntityName(EntityPersister persister) {
        return StatsHelper.getRootEntityRole((EntityPersister)persister).getFullPath();
    }
}

