/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.jfr.internal;

import jdk.jfr.EventType;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.jfr.internal.CacheGetEvent;
import org.hibernate.event.jfr.internal.CachePutEvent;
import org.hibernate.event.jfr.internal.DirtyCalculationEvent;
import org.hibernate.event.jfr.internal.FlushEvent;
import org.hibernate.event.jfr.internal.JdbcBatchExecutionEvent;
import org.hibernate.event.jfr.internal.JdbcConnectionAcquisitionEvent;
import org.hibernate.event.jfr.internal.JdbcConnectionReleaseEvent;
import org.hibernate.event.jfr.internal.JdbcPreparedStatementCreationEvent;
import org.hibernate.event.jfr.internal.JdbcPreparedStatementExecutionEvent;
import org.hibernate.event.jfr.internal.PartialFlushEvent;
import org.hibernate.event.jfr.internal.PrePartialFlushEvent;
import org.hibernate.event.jfr.internal.SessionClosedEvent;
import org.hibernate.event.jfr.internal.SessionOpenEvent;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.internal.build.AllowNonPortable;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.internal.StatsHelper;

@AllowNonPortable
public class JfrEventManager
implements EventManager {
    private static final EventType sessionOpenEventType = EventType.getEventType(SessionOpenEvent.class);
    private static final EventType sessionClosedEventType = EventType.getEventType(SessionClosedEvent.class);
    private static final EventType jdbcConnectionAcquisitionEventType = EventType.getEventType(JdbcConnectionAcquisitionEvent.class);
    private static final EventType jdbcConnectionReleaseEventType = EventType.getEventType(JdbcConnectionReleaseEvent.class);
    private static final EventType jdbcPreparedStatementCreationEventType = EventType.getEventType(JdbcPreparedStatementCreationEvent.class);
    private static final EventType jdbcPreparedStatementExecutionEventType = EventType.getEventType(JdbcPreparedStatementExecutionEvent.class);
    private static final EventType jdbcBatchExecutionEventType = EventType.getEventType(JdbcBatchExecutionEvent.class);
    private static final EventType cachePutEventType = EventType.getEventType(CachePutEvent.class);
    private static final EventType cacheGetEventType = EventType.getEventType(CacheGetEvent.class);
    private static final EventType flushEventType = EventType.getEventType(FlushEvent.class);
    private static final EventType partialFlushEventType = EventType.getEventType(PartialFlushEvent.class);
    private static final EventType dirtyCalculationEventType = EventType.getEventType(DirtyCalculationEvent.class);
    private static final EventType prePartialFlushEventType = EventType.getEventType(PrePartialFlushEvent.class);

    public SessionOpenEvent beginSessionOpenEvent() {
        if (sessionOpenEventType.isEnabled()) {
            SessionOpenEvent sessionOpenEvent = new SessionOpenEvent();
            sessionOpenEvent.begin();
            return sessionOpenEvent;
        }
        return null;
    }

    public void completeSessionOpenEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session) {
        if (monitoringEvent != null) {
            SessionOpenEvent sessionOpenEvent = (SessionOpenEvent)monitoringEvent;
            sessionOpenEvent.end();
            if (sessionOpenEvent.shouldCommit()) {
                sessionOpenEvent.sessionIdentifier = this.getSessionIdentifier(session);
                sessionOpenEvent.commit();
            }
        }
    }

    public SessionClosedEvent beginSessionClosedEvent() {
        if (sessionClosedEventType.isEnabled()) {
            SessionClosedEvent sessionClosedEvent = new SessionClosedEvent();
            sessionClosedEvent.begin();
            return sessionClosedEvent;
        }
        return null;
    }

    public void completeSessionClosedEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session) {
        if (monitoringEvent != null) {
            SessionClosedEvent sessionClosedEvent = (SessionClosedEvent)monitoringEvent;
            sessionClosedEvent.end();
            if (sessionClosedEvent.shouldCommit()) {
                sessionClosedEvent.sessionIdentifier = this.getSessionIdentifier(session);
                sessionClosedEvent.commit();
            }
        }
    }

    public JdbcConnectionAcquisitionEvent beginJdbcConnectionAcquisitionEvent() {
        if (jdbcConnectionAcquisitionEventType.isEnabled()) {
            JdbcConnectionAcquisitionEvent jdbcConnectionAcquisitionEvent = new JdbcConnectionAcquisitionEvent();
            jdbcConnectionAcquisitionEvent.begin();
            return jdbcConnectionAcquisitionEvent;
        }
        return null;
    }

    public void completeJdbcConnectionAcquisitionEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, Object tenantId) {
        if (monitoringEvent != null) {
            JdbcConnectionAcquisitionEvent jdbcConnectionAcquisitionEvent = (JdbcConnectionAcquisitionEvent)monitoringEvent;
            jdbcConnectionAcquisitionEvent.end();
            if (jdbcConnectionAcquisitionEvent.shouldCommit()) {
                jdbcConnectionAcquisitionEvent.sessionIdentifier = this.getSessionIdentifier(session);
                jdbcConnectionAcquisitionEvent.tenantIdentifier = tenantId == null ? null : session.getFactory().getTenantIdentifierJavaType().toString(tenantId);
                jdbcConnectionAcquisitionEvent.commit();
            }
        }
    }

    public JdbcConnectionReleaseEvent beginJdbcConnectionReleaseEvent() {
        if (jdbcConnectionReleaseEventType.isEnabled()) {
            JdbcConnectionReleaseEvent jdbcConnectionReleaseEvent = new JdbcConnectionReleaseEvent();
            jdbcConnectionReleaseEvent.begin();
            return jdbcConnectionReleaseEvent;
        }
        return null;
    }

    public void completeJdbcConnectionReleaseEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, Object tenantId) {
        if (monitoringEvent != null) {
            JdbcConnectionReleaseEvent jdbcConnectionReleaseEvent = (JdbcConnectionReleaseEvent)monitoringEvent;
            jdbcConnectionReleaseEvent.end();
            if (jdbcConnectionReleaseEvent.shouldCommit()) {
                jdbcConnectionReleaseEvent.sessionIdentifier = this.getSessionIdentifier(session);
                jdbcConnectionReleaseEvent.tenantIdentifier = tenantId == null ? null : session.getFactory().getTenantIdentifierJavaType().toString(tenantId);
                jdbcConnectionReleaseEvent.commit();
            }
        }
    }

    public JdbcPreparedStatementCreationEvent beginJdbcPreparedStatementCreationEvent() {
        if (jdbcPreparedStatementCreationEventType.isEnabled()) {
            JdbcPreparedStatementCreationEvent jdbcPreparedStatementCreation = new JdbcPreparedStatementCreationEvent();
            jdbcPreparedStatementCreation.begin();
            return jdbcPreparedStatementCreation;
        }
        return null;
    }

    public void completeJdbcPreparedStatementCreationEvent(HibernateMonitoringEvent monitoringEvent, String preparedStatementSql) {
        if (monitoringEvent != null) {
            JdbcPreparedStatementCreationEvent jdbcPreparedStatementCreation = (JdbcPreparedStatementCreationEvent)monitoringEvent;
            jdbcPreparedStatementCreation.end();
            if (jdbcPreparedStatementCreation.shouldCommit()) {
                jdbcPreparedStatementCreation.sql = preparedStatementSql;
                jdbcPreparedStatementCreation.commit();
            }
        }
    }

    public JdbcPreparedStatementExecutionEvent beginJdbcPreparedStatementExecutionEvent() {
        if (jdbcPreparedStatementExecutionEventType.isEnabled()) {
            JdbcPreparedStatementExecutionEvent jdbcPreparedStatementExecutionEvent = new JdbcPreparedStatementExecutionEvent();
            jdbcPreparedStatementExecutionEvent.begin();
            return jdbcPreparedStatementExecutionEvent;
        }
        return null;
    }

    public void completeJdbcPreparedStatementExecutionEvent(HibernateMonitoringEvent monitoringEvent, String preparedStatementSql) {
        if (monitoringEvent != null) {
            JdbcPreparedStatementExecutionEvent jdbcPreparedStatementExecutionEvent = (JdbcPreparedStatementExecutionEvent)monitoringEvent;
            jdbcPreparedStatementExecutionEvent.end();
            if (jdbcPreparedStatementExecutionEvent.shouldCommit()) {
                jdbcPreparedStatementExecutionEvent.sql = preparedStatementSql;
                jdbcPreparedStatementExecutionEvent.commit();
            }
        }
    }

    public JdbcBatchExecutionEvent beginJdbcBatchExecutionEvent() {
        if (jdbcBatchExecutionEventType.isEnabled()) {
            JdbcBatchExecutionEvent jdbcBatchExecutionEvent = new JdbcBatchExecutionEvent();
            jdbcBatchExecutionEvent.begin();
            return jdbcBatchExecutionEvent;
        }
        return null;
    }

    public void completeJdbcBatchExecutionEvent(HibernateMonitoringEvent monitoringEvent, String statementSql) {
        if (monitoringEvent != null) {
            JdbcBatchExecutionEvent jdbcBatchExecutionEvent = (JdbcBatchExecutionEvent)monitoringEvent;
            jdbcBatchExecutionEvent.end();
            if (jdbcBatchExecutionEvent.shouldCommit()) {
                jdbcBatchExecutionEvent.sql = statementSql;
                jdbcBatchExecutionEvent.commit();
            }
        }
    }

    public HibernateMonitoringEvent beginCachePutEvent() {
        if (cachePutEventType.isEnabled()) {
            CachePutEvent cachePutEvent = new CachePutEvent();
            cachePutEvent.begin();
            return cachePutEvent;
        }
        return null;
    }

    public void completeCachePutEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, Region region, boolean cacheContentChanged, EventManager.CacheActionDescription description) {
        if (monitoringEvent != null) {
            CachePutEvent cachePutEvent = (CachePutEvent)monitoringEvent;
            cachePutEvent.end();
            if (cachePutEvent.shouldCommit()) {
                cachePutEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cachePutEvent.regionName = region.getName();
                cachePutEvent.description = description.getText();
                cachePutEvent.cacheChanged = cacheContentChanged;
                cachePutEvent.commit();
            }
        }
    }

    public void completeCachePutEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, CachedDomainDataAccess cachedDomainDataAccess, EntityPersister persister, boolean cacheContentChanged, EventManager.CacheActionDescription description) {
        this.completeCachePutEvent(monitoringEvent, session, cachedDomainDataAccess, persister, cacheContentChanged, false, description);
    }

    public void completeCachePutEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, CachedDomainDataAccess cachedDomainDataAccess, EntityPersister persister, boolean cacheContentChanged, boolean isNatualId, EventManager.CacheActionDescription description) {
        if (monitoringEvent != null) {
            CachePutEvent cachePutEvent = (CachePutEvent)monitoringEvent;
            cachePutEvent.end();
            if (cachePutEvent.shouldCommit()) {
                cachePutEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cachePutEvent.regionName = cachedDomainDataAccess.getRegion().getName();
                cachePutEvent.entityName = this.getEntityName(persister);
                cachePutEvent.description = description.getText();
                cachePutEvent.isNaturalId = isNatualId;
                cachePutEvent.cacheChanged = cacheContentChanged;
                cachePutEvent.commit();
            }
        }
    }

    public void completeCachePutEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, CachedDomainDataAccess cachedDomainDataAccess, CollectionPersister persister, boolean cacheContentChanged, EventManager.CacheActionDescription description) {
        if (monitoringEvent != null) {
            CachePutEvent cachePutEvent = (CachePutEvent)monitoringEvent;
            cachePutEvent.end();
            if (cachePutEvent.shouldCommit()) {
                cachePutEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cachePutEvent.regionName = cachedDomainDataAccess.getRegion().getName();
                cachePutEvent.collectionName = persister.getNavigableRole().getFullPath();
                cachePutEvent.description = description.getText();
                cachePutEvent.cacheChanged = cacheContentChanged;
                cachePutEvent.commit();
            }
        }
    }

    public HibernateMonitoringEvent beginCacheGetEvent() {
        if (cacheGetEventType.isEnabled()) {
            CacheGetEvent cacheGetEvent = new CacheGetEvent();
            cacheGetEvent.begin();
            return cacheGetEvent;
        }
        return null;
    }

    public void completeCacheGetEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, Region region, boolean hit) {
        if (monitoringEvent != null) {
            CacheGetEvent cacheGetEvent = (CacheGetEvent)monitoringEvent;
            cacheGetEvent.end();
            if (cacheGetEvent.shouldCommit()) {
                cacheGetEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cacheGetEvent.regionName = region.getName();
                cacheGetEvent.hit = hit;
                cacheGetEvent.commit();
            }
        }
    }

    public void completeCacheGetEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, Region region, EntityPersister persister, boolean isNaturalKey, boolean hit) {
        if (monitoringEvent != null) {
            CacheGetEvent cacheGetEvent = (CacheGetEvent)monitoringEvent;
            cacheGetEvent.end();
            if (cacheGetEvent.shouldCommit()) {
                cacheGetEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cacheGetEvent.entityName = this.getEntityName(persister);
                cacheGetEvent.regionName = region.getName();
                cacheGetEvent.isNaturalId = isNaturalKey;
                cacheGetEvent.hit = hit;
                cacheGetEvent.commit();
            }
        }
    }

    public void completeCacheGetEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, Region region, CollectionPersister persister, boolean hit) {
        if (monitoringEvent != null) {
            CacheGetEvent cacheGetEvent = (CacheGetEvent)monitoringEvent;
            cacheGetEvent.end();
            if (cacheGetEvent.shouldCommit()) {
                cacheGetEvent.sessionIdentifier = this.getSessionIdentifier(session);
                cacheGetEvent.collectionName = persister.getNavigableRole().getFullPath();
                cacheGetEvent.regionName = region.getName();
                cacheGetEvent.hit = hit;
                cacheGetEvent.commit();
            }
        }
    }

    public FlushEvent beginFlushEvent() {
        if (flushEventType.isEnabled()) {
            FlushEvent flushEvent = new FlushEvent();
            flushEvent.begin();
            return flushEvent;
        }
        return null;
    }

    public void completeFlushEvent(HibernateMonitoringEvent flushEvent, org.hibernate.event.spi.FlushEvent event) {
        this.completeFlushEvent(flushEvent, event, false);
    }

    public void completeFlushEvent(HibernateMonitoringEvent monitoringEvent, org.hibernate.event.spi.FlushEvent hibernateFlushEvent, boolean autoFlush) {
        if (monitoringEvent != null) {
            FlushEvent jfrFlushEvent = (FlushEvent)monitoringEvent;
            jfrFlushEvent.end();
            if (jfrFlushEvent.shouldCommit()) {
                jfrFlushEvent.sessionIdentifier = this.getSessionIdentifier((SharedSessionContractImplementor)hibernateFlushEvent.getSession());
                jfrFlushEvent.numberOfEntitiesProcessed = hibernateFlushEvent.getNumberOfEntitiesProcessed();
                jfrFlushEvent.numberOfCollectionsProcessed = hibernateFlushEvent.getNumberOfCollectionsProcessed();
                jfrFlushEvent.isAutoFlush = autoFlush;
                jfrFlushEvent.commit();
            }
        }
    }

    public PartialFlushEvent beginPartialFlushEvent() {
        if (partialFlushEventType.isEnabled()) {
            PartialFlushEvent partialFlushEvent = new PartialFlushEvent();
            partialFlushEvent.begin();
            return partialFlushEvent;
        }
        return null;
    }

    public void completePartialFlushEvent(HibernateMonitoringEvent monitoringEvent, AutoFlushEvent hibernateAutoFlushEvent) {
        if (monitoringEvent != null) {
            PartialFlushEvent jfrPartialFlushEvent = (PartialFlushEvent)monitoringEvent;
            jfrPartialFlushEvent.end();
            if (jfrPartialFlushEvent.shouldCommit()) {
                jfrPartialFlushEvent.sessionIdentifier = this.getSessionIdentifier((SharedSessionContractImplementor)hibernateAutoFlushEvent.getSession());
                jfrPartialFlushEvent.numberOfEntitiesProcessed = hibernateAutoFlushEvent.getNumberOfEntitiesProcessed();
                jfrPartialFlushEvent.numberOfCollectionsProcessed = hibernateAutoFlushEvent.getNumberOfCollectionsProcessed();
                jfrPartialFlushEvent.isAutoFlush = true;
                jfrPartialFlushEvent.commit();
            }
        }
    }

    public DirtyCalculationEvent beginDirtyCalculationEvent() {
        if (dirtyCalculationEventType.isEnabled()) {
            DirtyCalculationEvent dirtyCalculationEvent = new DirtyCalculationEvent();
            dirtyCalculationEvent.begin();
            return dirtyCalculationEvent;
        }
        return null;
    }

    public void completeDirtyCalculationEvent(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session, EntityPersister persister, EntityEntry entry, int[] dirtyProperties) {
        if (monitoringEvent != null) {
            DirtyCalculationEvent dirtyCalculationEvent = (DirtyCalculationEvent)monitoringEvent;
            dirtyCalculationEvent.end();
            if (dirtyCalculationEvent.shouldCommit()) {
                dirtyCalculationEvent.sessionIdentifier = this.getSessionIdentifier(session);
                dirtyCalculationEvent.entityName = this.getEntityName(persister);
                dirtyCalculationEvent.entityStatus = entry.getStatus().name();
                dirtyCalculationEvent.dirty = dirtyProperties != null;
                dirtyCalculationEvent.commit();
            }
        }
    }

    public PrePartialFlushEvent beginPrePartialFlush() {
        if (prePartialFlushEventType.isEnabled()) {
            PrePartialFlushEvent partialFlushEvent = new PrePartialFlushEvent();
            partialFlushEvent.begin();
            return partialFlushEvent;
        }
        return null;
    }

    public void completePrePartialFlush(HibernateMonitoringEvent monitoringEvent, SharedSessionContractImplementor session) {
        if (monitoringEvent != null) {
            PrePartialFlushEvent prePartialFlushEvent = (PrePartialFlushEvent)monitoringEvent;
            prePartialFlushEvent.end();
            if (prePartialFlushEvent.shouldCommit()) {
                prePartialFlushEvent.sessionIdentifier = this.getSessionIdentifier(session);
                prePartialFlushEvent.commit();
            }
        }
    }

    private String getSessionIdentifier(SharedSessionContractImplementor session) {
        if (session == null) {
            return null;
        }
        return session.getSessionIdentifier().toString();
    }

    private String getEntityName(EntityPersister persister) {
        return StatsHelper.INSTANCE.getRootEntityRole(persister).getFullPath();
    }
}

