/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hikaricp.internal;

import com.zaxxer.hikari.HikariConfig;
import java.util.Map;
import java.util.Properties;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;

public class HikariConfigurationUtil {
    public static final String CONFIG_PREFIX = "hibernate.hikari.";

    public static HikariConfig loadConfiguration(Map<String, Object> properties) {
        Properties hikariProps = new Properties();
        HikariConfigurationUtil.copyProperty("hibernate.connection.autocommit", properties, "autoCommit", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.pool_size", properties, "maximumPoolSize", hikariProps);
        HikariConfigurationUtil.copyProperty(properties, "driverClassName", hikariProps, "jakarta.persistence.jdbc.driver", "hibernate.connection.driver_class", "javax.persistence.jdbc.driver");
        HikariConfigurationUtil.copyProperty(properties, "jdbcUrl", hikariProps, "jakarta.persistence.jdbc.url", "hibernate.connection.url", "javax.persistence.jdbc.url");
        HikariConfigurationUtil.copyProperty(properties, "username", hikariProps, "jakarta.persistence.jdbc.user", "hibernate.connection.username", "javax.persistence.jdbc.user");
        HikariConfigurationUtil.copyProperty(properties, "password", hikariProps, "jakarta.persistence.jdbc.password", "hibernate.connection.password", "javax.persistence.jdbc.password");
        HikariConfigurationUtil.copyIsolationSetting(properties, hikariProps);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            hikariProps.setProperty(key.substring(CONFIG_PREFIX.length()), entry.getValue().toString());
        }
        return new HikariConfig(hikariProps);
    }

    private static void copyProperty(String srcKey, Map<String, Object> src, String dstKey, Properties dst) {
        if (src.containsKey(srcKey)) {
            dst.setProperty(dstKey, src.get(srcKey).toString());
        }
    }

    private static void copyProperty(Map<String, Object> src, String dstKey, Properties dst, String ... srcKeys) {
        ConnectionProviderInitiator.consumeSetting(src, (name, value) -> dst.setProperty(dstKey, value), (String[])srcKeys);
    }

    private static void copyIsolationSetting(Map<String, Object> props, Properties hikariProps) {
        Integer isolation = ConnectionProviderInitiator.extractIsolation(props);
        if (isolation != null) {
            hikariProps.put("transactionIsolation", ConnectionProviderInitiator.toIsolationConnectionConstantName((Integer)isolation));
        }
    }
}

