/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hikaricp.internal;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProviderConfigurationException;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentInitiator;
import org.hibernate.hikaricp.internal.HikariConfigurationUtil;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class HikariCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -9131625057941275711L;
    private boolean isMetadataAccessAllowed = true;
    private HikariConfig hikariConfig = null;
    private HikariDataSource hikariDataSource = null;

    public void configure(Map<String, Object> configurationValues) throws HibernateException {
        try {
            this.isMetadataAccessAllowed = JdbcEnvironmentInitiator.allowJdbcMetadataAccess(configurationValues);
            ConnectionInfoLogger.INSTANCE.configureConnectionPool("HikariCP");
            this.hikariConfig = HikariConfigurationUtil.loadConfiguration(configurationValues);
            this.hikariDataSource = new HikariDataSource(this.hikariConfig);
        }
        catch (Exception e) {
            ConnectionInfoLogger.INSTANCE.unableToInstantiateConnectionPool(e);
            throw new ConnectionProviderConfigurationException("Could not configure HikariCP: " + e.getMessage(), (Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.hikariDataSource != null ? this.hikariDataSource.getConnection() : null;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return new DatabaseConnectionInfoImpl(HikariCPConnectionProvider.class, this.hikariConfig.getJdbcUrl(), StringHelper.isBlank((String)this.hikariConfig.getDriverClassName()) ? this.extractDriverNameFromMetadata() : this.hikariConfig.getDriverClassName(), dialect.getVersion(), Boolean.toString(this.hikariConfig.isAutoCommit()), this.hikariConfig.getTransactionIsolation(), Integer.valueOf(this.hikariConfig.getMinimumIdle()), Integer.valueOf(this.hikariConfig.getMaximumPoolSize()));
    }

    private String extractDriverNameFromMetadata() {
        if (this.isMetadataAccessAllowed) {
            String string;
            block9: {
                Connection conn = this.getConnection();
                try {
                    string = conn.getMetaData().getDriverName();
                    if (conn == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                conn.close();
            }
            return string;
        }
        return null;
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return ConnectionProvider.class.equals(unwrapType) || HikariCPConnectionProvider.class.isAssignableFrom(unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || HikariCPConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.hikariDataSource;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        if (this.hikariDataSource != null) {
            ConnectionInfoLogger.INSTANCE.cleaningUpConnectionPool("HikariCP");
            this.hikariDataSource.close();
        }
    }
}

