/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.lang.reflect.Method;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.orm.tooling.gradle.Helper;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.HibernateVersion;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementHelper;

public class HibernateOrmPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            project.getLogger().debug("Adding Hibernate extensions to the build [{}]", (Object)project.getPath());
            HibernateOrmSpec ormDsl = (HibernateOrmSpec)project.getExtensions().create("hibernate", HibernateOrmSpec.class, new Object[0]);
            this.prepareEnhancement(ormDsl, project);
            this.prepareHbmTransformation(ormDsl, project);
            project.getDependencies().add("implementation", (Object)ormDsl.getUseSameVersion().map(use -> use != false ? "org.hibernate.orm:hibernate-core:" + HibernateVersion.version : null));
        });
    }

    private void prepareEnhancement(final HibernateOrmSpec ormDsl, Project project) {
        project.getGradle().getTaskGraph().whenReady(graph -> {
            if (!ormDsl.getEnhancement().isPresent()) {
                return;
            }
            SourceSet sourceSet = this.resolveSourceSet((String)ormDsl.getSourceSet().get(), project);
            Set languages = (Set)ormDsl.getLanguages().getOrNull();
            if (languages == null) {
                return;
            }
            for (String language : languages) {
                String languageCompileTaskName = sourceSet.getCompileTaskName(language);
                final Task languageCompileTask = (Task)project.getTasks().findByName(languageCompileTaskName);
                if (languageCompileTask == null) continue;
                final FileCollection classesDirs = sourceSet.getOutput().getClassesDirs();
                Configuration compileConfig = project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName());
                final Set dependencyFiles = compileConfig.getFiles();
                languageCompileTask.doLast((Action)new Action<Task>(){

                    public void execute(Task t) {
                        try {
                            Method getDestinationDirectory = languageCompileTask.getClass().getMethod("getDestinationDirectory", new Class[0]);
                            DirectoryProperty classesDirectory = (DirectoryProperty)getDestinationDirectory.invoke((Object)languageCompileTask, new Object[0]);
                            ClassLoader classLoader = Helper.toClassLoader(classesDirs, dependencyFiles);
                            EnhancementHelper.enhance(classesDirectory, classLoader, ormDsl);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
    }

    private SourceSet resolveSourceSet(String name, Project project) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        return (SourceSet)javaPluginExtension.getSourceSets().getByName(name);
    }

    private void prepareHbmTransformation(HibernateOrmSpec ormDsl, Project project) {
    }
}

