/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.misc;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.HbmXmlTransformer;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.orm.tooling.gradle.misc.OriginImpl;
import org.hibernate.orm.tooling.gradle.misc.TransformationNaming;
import org.hibernate.service.ServiceRegistry;

@CacheableTask
public abstract class TransformHbmXmlTask
extends SourceTask {
    public TransformHbmXmlTask() {
        this.getTargetDatabaseName().convention((Object)"H2");
        this.getUnsupportedFeatures().convention((Object)UnsupportedFeatureHandling.ERROR);
        this.getDeleteHbmFiles().convention((Object)false);
    }

    @Nested
    public abstract TransformationNaming getRenaming();

    @Input
    public abstract Property<String> getTargetDatabaseName();

    @Input
    public abstract Property<UnsupportedFeatureHandling> getUnsupportedFeatures();

    @Input
    public abstract Property<Boolean> getDeleteHbmFiles();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    public void renaming(Action<TransformationNaming> action) {
        action.execute((Object)this.getRenaming());
    }

    @TaskAction
    public void transformFiles() {
        MappingBinder mappingBinder = new MappingBinder(MappingBinder.class.getClassLoader()::getResourceAsStream, (UnsupportedFeatureHandling)this.getUnsupportedFeatures().get());
        ArrayList<Binding<JaxbHbmHibernateMapping>> hbmBindings = new ArrayList<Binding<JaxbHbmHibernateMapping>>();
        this.getSource().forEach(hbmXmlFile -> {
            OriginImpl origin = new OriginImpl((File)hbmXmlFile);
            Binding<JaxbHbmHibernateMapping> hbmBinding = this.bindMapping(mappingBinder, (File)hbmXmlFile, origin);
            hbmBindings.add(hbmBinding);
        });
        try (StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().clearSettings().applySetting("jakarta.persistence.database-product-name", this.getTargetDatabaseName().get()).applySetting("hibernate.boot.allow_jdbc_metadata_access", (Object)false).build();){
            this.performTransformation(hbmBindings, mappingBinder, serviceRegistry);
        }
    }

    private void performTransformation(List<Binding<JaxbHbmHibernateMapping>> hbmBindings, MappingBinder mappingBinder, StandardServiceRegistry serviceRegistry) {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        hbmBindings.forEach(arg_0 -> ((MetadataSources)metadataSources).addHbmXmlBinding(arg_0));
        List transformedBindings = HbmXmlTransformer.transform(hbmBindings, (MetadataImplementor)((MetadataImplementor)metadataSources.buildMetadata()), (UnsupportedFeatureHandling)((UnsupportedFeatureHandling)this.getUnsupportedFeatures().get()));
        for (int i = 0; i < hbmBindings.size(); ++i) {
            Marshaller marshaller;
            boolean deleted;
            Binding<JaxbHbmHibernateMapping> hbmBinding = hbmBindings.get(i);
            Binding transformedBinding = (Binding)transformedBindings.get(i);
            OriginImpl origin = (OriginImpl)hbmBinding.getOrigin();
            File hbmXmlFile = origin.getHbmXmlFile();
            if (((Boolean)this.getDeleteHbmFiles().get()).booleanValue() && !(deleted = hbmXmlFile.delete())) {
                this.getProject().getLogger().warn("Unable to delete hbm.xml file `{}`", (Object)hbmXmlFile.getAbsoluteFile());
            }
            String copyName = this.determineCopyName(hbmXmlFile);
            File copyFile = this.determineCopyFile(copyName, hbmXmlFile);
            copyFile.getParentFile().mkdirs();
            try {
                marshaller = mappingBinder.mappingJaxbContext().createMarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException("Unable to create JAXB Marshaller", e);
            }
            try {
                marshaller.marshal(transformedBinding.getRoot(), copyFile);
                continue;
            }
            catch (JAXBException e) {
                throw new RuntimeException("Unable to marshall mapping JAXB representation to file `" + copyFile.getAbsolutePath() + "`", e);
            }
        }
    }

    private Binding<JaxbHbmHibernateMapping> bindMapping(MappingBinder mappingBinder, File hbmXmlFile, Origin origin) {
        Binding binding;
        FileInputStream fileStream = new FileInputStream(hbmXmlFile);
        try {
            binding = mappingBinder.bind((InputStream)fileStream, origin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.getProject().getLogger().warn("Unable to open hbm.xml file `" + hbmXmlFile.getAbsolutePath() + "` for transformation", (Throwable)e);
                return null;
            }
        }
        fileStream.close();
        return binding;
    }

    private File determineCopyFile(String copyName, File hbmXmlFile) {
        if (this.getOutputDirectory().isPresent()) {
            return ((Directory)this.getOutputDirectory().get()).file(copyName).getAsFile();
        }
        return new File(hbmXmlFile.getParentFile(), copyName);
    }

    private String determineCopyName(File hbmXmlFile) {
        String extension;
        String suffix;
        String hbmXmlFileExtension;
        String copyBaseName;
        String hbmXmlFileName = hbmXmlFile.getName();
        if (this.getRenaming().areNoneDefined()) {
            return hbmXmlFileName;
        }
        int legacyConventionExtensionIndex = hbmXmlFileName.indexOf(".hbm.xml");
        if (legacyConventionExtensionIndex > 0) {
            copyBaseName = hbmXmlFileName.substring(0, legacyConventionExtensionIndex);
            hbmXmlFileExtension = ".hbm.xml";
        } else {
            int extensionIndex = hbmXmlFileName.lastIndexOf(".'");
            if (extensionIndex > 0) {
                copyBaseName = hbmXmlFileName.substring(0, legacyConventionExtensionIndex);
                hbmXmlFileExtension = hbmXmlFileName.substring(extensionIndex + 1);
            } else {
                copyBaseName = hbmXmlFileName;
                hbmXmlFileExtension = null;
            }
        }
        Object copyName = copyBaseName;
        String prefix = (String)this.getRenaming().getPrefix().getOrNull();
        if (prefix != null) {
            copyName = (String)this.getRenaming().getPrefix().get() + (String)copyName;
        }
        if ((suffix = (String)this.getRenaming().getSuffix().getOrNull()) != null) {
            copyName = (String)copyName + suffix;
        }
        if ((extension = (String)this.getRenaming().getExtension().getOrNull()) != null) {
            copyName = (String)copyName + ".";
            copyName = (String)copyName + extension;
        } else if (hbmXmlFileExtension != null) {
            copyName = (String)copyName + ".";
            copyName = (String)copyName + hbmXmlFileExtension;
        }
        return copyName;
    }
}

