/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.enhance;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSetContainer;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;

public class EnhancementSpec {
    public static final String ENHANCE = "enhance";
    public static final String ENHANCEMENT = "enhancement";
    public static final String DSL_NAME = "enhancement";
    private final Property<Boolean> enableLazyInitialization;
    private final Property<Boolean> enableDirtyTracking;
    private final Property<Boolean> enableAssociationManagement;
    private final Property<Boolean> enableExtendedEnhancement;
    private final ListProperty<String> classNames;

    @Inject
    public EnhancementSpec(HibernateOrmSpec ormDsl, Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        this.enableLazyInitialization = EnhancementSpec.makeProperty(project).convention((Object)true);
        this.enableDirtyTracking = EnhancementSpec.makeProperty(project).convention((Object)true);
        this.enableAssociationManagement = EnhancementSpec.makeProperty(project).convention((Object)false);
        this.enableExtendedEnhancement = EnhancementSpec.makeProperty(project).convention((Object)false);
        this.classNames = project.getObjects().listProperty(String.class).convention(new ArrayList());
    }

    public static Property<Boolean> makeProperty(Project project) {
        return project.getObjects().property(Boolean.class);
    }

    public boolean hasAnythingToDo() {
        return (Boolean)this.enableLazyInitialization.get() != false || (Boolean)this.enableDirtyTracking.get() != false || (Boolean)this.enableAssociationManagement.get() != false || (Boolean)this.enableExtendedEnhancement.get() != false;
    }

    public Property<Boolean> getEnableLazyInitialization() {
        return this.enableLazyInitialization;
    }

    public Property<Boolean> getEnableDirtyTracking() {
        return this.enableDirtyTracking;
    }

    public Property<Boolean> getEnableAssociationManagement() {
        return this.enableAssociationManagement;
    }

    public Property<Boolean> getEnableExtendedEnhancement() {
        return this.enableExtendedEnhancement;
    }

    public ListProperty<String> getClassNames() {
        return this.classNames;
    }

    @Deprecated(forRemoval=true)
    public void setEnableLazyInitialization(boolean enable) {
        this.enableLazyInitialization.set((Object)enable);
    }

    @Deprecated(forRemoval=true)
    public void enableLazyInitialization(boolean enable) {
        this.setEnableLazyInitialization(enable);
    }

    @Deprecated(forRemoval=true)
    public void lazyInitialization(boolean enable) {
        this.setEnableLazyInitialization(enable);
    }

    @Deprecated(forRemoval=true)
    public void setLazyInitialization(boolean enable) {
        this.setEnableLazyInitialization(enable);
    }

    @Deprecated(forRemoval=true)
    public void setEnableDirtyTracking(boolean enable) {
        this.enableDirtyTracking.set((Object)enable);
    }

    @Deprecated(forRemoval=true)
    public void enableDirtyTracking(boolean enable) {
        this.setEnableDirtyTracking(enable);
    }

    @Deprecated(forRemoval=true)
    public void dirtyTracking(boolean enable) {
        this.setEnableDirtyTracking(enable);
    }

    @Deprecated(forRemoval=true)
    public void setDirtyTracking(boolean enable) {
        this.setEnableDirtyTracking(enable);
    }

    @Deprecated(forRemoval=true)
    public void setEnableAssociationManagement(boolean enable) {
        this.enableAssociationManagement.set((Object)enable);
    }

    @Deprecated(forRemoval=true)
    public void enableAssociationManagement(boolean enable) {
        this.setEnableAssociationManagement(enable);
    }

    @Deprecated(forRemoval=true)
    public void associationManagement(boolean enable) {
        this.setEnableAssociationManagement(enable);
    }

    @Deprecated(forRemoval=true)
    public void setEnableExtendedEnhancement(boolean enable) {
        this.enableExtendedEnhancement.set((Object)enable);
    }

    @Deprecated(forRemoval=true)
    public void enableExtendedEnhancement(boolean enable) {
        this.setEnableExtendedEnhancement(enable);
    }

    @Deprecated(forRemoval=true)
    public void extendedEnhancement(boolean enable) {
        this.setEnableExtendedEnhancement(enable);
    }

    public void setClassNames(List<String> classNames) {
        this.classNames.set(classNames);
    }

    public void setClassNames(Provider<List<String>> classNames) {
        this.classNames.set(classNames);
    }

    public void includeClassName(String className) {
        this.classNames.add((Object)className);
    }
}

