/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.lang.reflect.Method;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.orm.tooling.gradle.Helper;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.HibernateVersion;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementHelper;

public class HibernateOrmPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JvmEcosystemPlugin.class);
        project.getLogger().debug("Adding Hibernate extensions to the build [{}]", (Object)project.getPath());
        HibernateOrmSpec ormDsl = (HibernateOrmSpec)project.getExtensions().create("hibernate", HibernateOrmSpec.class, new Object[]{project});
        this.prepareEnhancement(ormDsl, project);
        this.prepareHbmTransformation(ormDsl, project);
        project.getDependencies().add("implementation", (Object)ormDsl.getUseSameVersion().map(use -> use != false ? "org.hibernate.orm:hibernate-core:" + HibernateVersion.version : null));
    }

    private void prepareEnhancement(final HibernateOrmSpec ormDsl, final Project project) {
        project.getGradle().getTaskGraph().whenReady(graph -> {
            if (!ormDsl.isEnhancementEnabled()) {
                return;
            }
            final SourceSet sourceSet = (SourceSet)ormDsl.getSourceSet().get();
            Set languages = (Set)ormDsl.getLanguages().getOrNull();
            if (languages == null) {
                return;
            }
            for (String language : languages) {
                String languageCompileTaskName = sourceSet.getCompileTaskName(language);
                final Task languageCompileTask = (Task)project.getTasks().findByName(languageCompileTaskName);
                if (languageCompileTask == null) continue;
                languageCompileTask.doLast((Action)new Action<Task>(){

                    public void execute(Task t) {
                        try {
                            Method getDestinationDirectory = languageCompileTask.getClass().getMethod("getDestinationDirectory", new Class[0]);
                            DirectoryProperty classesDirectory = (DirectoryProperty)getDestinationDirectory.invoke((Object)languageCompileTask, new Object[0]);
                            ClassLoader classLoader = Helper.toClassLoader(sourceSet, project);
                            EnhancementHelper.enhance(classesDirectory, classLoader, ormDsl, project);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
    }

    private void prepareHbmTransformation(HibernateOrmSpec ormDsl, Project project) {
    }
}

