/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.bytecode.enhance.spi.Enhancer;

public class Helper {
    public static ClassLoader toClassLoader(SourceSet sourceSet, Project project) {
        ArrayList<URL> urls = new ArrayList<URL>();
        FileCollection classesDirs = sourceSet.getOutput().getClassesDirs();
        for (File classesDir : classesDirs) {
            urls.add(Helper.toUrl(classesDir));
        }
        Configuration compileConfig = project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName());
        Set dependencyFiles = compileConfig.getResolvedConfiguration().getFiles();
        for (File dependencyFile : dependencyFiles) {
            urls.add(Helper.toUrl(dependencyFile));
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Enhancer.class.getClassLoader());
    }

    private static URL toUrl(File file) {
        URI classesDirUri = file.toURI();
        try {
            return classesDirUri.toURL();
        }
        catch (MalformedURLException e) {
            throw new GradleException("Unable to resolve classpath entry to URL : " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public static ClassLoader toClassLoader(FileCollection directories) {
        Set files = directories.getFiles();
        URL[] urls = new URL[files.size()];
        int index = 0;
        for (File classesDir : files) {
            URI classesDirUri = classesDir.toURI();
            try {
                urls[index] = classesDirUri.toURL();
            }
            catch (MalformedURLException e) {
                throw new GradleException("Unable to resolve classpath entry to URL : " + classesDir.getAbsolutePath(), (Throwable)e);
            }
            ++index;
        }
        return new URLClassLoader(urls, Enhancer.class.getClassLoader());
    }

    public static ClassLoader toClassLoader(File classesDir) {
        URI classesDirUri = classesDir.toURI();
        try {
            URL url = classesDirUri.toURL();
            return new URLClassLoader(new URL[]{url}, Enhancer.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new GradleException("Unable to resolve classpath entry to URL : " + classesDir.getAbsolutePath(), (Throwable)e);
        }
    }

    public static String determineClassName(File root, File javaClassFile) {
        Path relativeClassPath = root.toPath().relativize(javaClassFile.toPath());
        String relativeClassPathString = relativeClassPath.toString();
        String classNameBase = relativeClassPathString.substring(0, relativeClassPathString.length() - ".class".length());
        return classNameBase.replace(File.separatorChar, '.');
    }
}

