/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.metamodel;

import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;

public class JpaMetamodelGenerationSpec {
    public static final String JPA_METAMODEL = "jpaMetamodel";
    public static final String DSL_NAME = "jpaMetamodel";
    private final Project project;
    private final DirectoryProperty generationOutputDirectory;
    private final DirectoryProperty compileOutputDirectory;
    private final Property<Boolean> applyGeneratedAnnotation;
    private final SetProperty<String> suppressions;

    @Inject
    public JpaMetamodelGenerationSpec(HibernateOrmSpec ormDsl, Project project) {
        this.project = project;
        this.generationOutputDirectory = project.getObjects().directoryProperty();
        this.generationOutputDirectory.convention(project.getLayout().getBuildDirectory().dir("generated/sources/jpaMetamodel"));
        this.compileOutputDirectory = project.getObjects().directoryProperty();
        this.compileOutputDirectory.convention(project.getLayout().getBuildDirectory().dir("classes/java/jpaMetamodel"));
        this.applyGeneratedAnnotation = project.getObjects().property(Boolean.class);
        this.applyGeneratedAnnotation.convention((Object)true);
        this.suppressions = project.getObjects().setProperty(String.class);
        this.suppressions.convention(Arrays.asList("raw", "deprecation"));
    }

    public Property<Boolean> getApplyGeneratedAnnotation() {
        return this.applyGeneratedAnnotation;
    }

    public SetProperty<String> getSuppressions() {
        return this.suppressions;
    }

    public DirectoryProperty getGenerationOutputDirectory() {
        return this.generationOutputDirectory;
    }

    public DirectoryProperty getCompileOutputDirectory() {
        return this.compileOutputDirectory;
    }

    @Deprecated(forRemoval=true)
    public void applyGeneratedAnnotation(boolean apply) {
        this.applyGeneratedAnnotation.set((Object)apply);
    }

    @Deprecated(forRemoval=true)
    public void suppress(String warning) {
        this.suppressions.add((Object)warning);
    }

    @Deprecated(forRemoval=true)
    public void generationOutputDirectory(Object ref) {
        this.generationOutputDirectory.set(this.project.file(ref));
    }

    @Deprecated(forRemoval=true)
    public void compileOutputDirectory(Object ref) {
        this.compileOutputDirectory.set(this.project.file(ref));
    }
}

