/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.metamodel.model;

import java.util.Locale;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.orm.tooling.gradle.metamodel.model.AttributeBag;
import org.hibernate.orm.tooling.gradle.metamodel.model.AttributeList;
import org.hibernate.orm.tooling.gradle.metamodel.model.AttributeMap;
import org.hibernate.orm.tooling.gradle.metamodel.model.AttributeSet;
import org.hibernate.orm.tooling.gradle.metamodel.model.AttributeSingular;
import org.hibernate.orm.tooling.gradle.metamodel.model.MetamodelAttribute;
import org.hibernate.orm.tooling.gradle.metamodel.model.MetamodelClass;

public class ObjectFactory {
    private final MetadataImplementor metadata;

    public ObjectFactory(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    public MetamodelClass metamodelClass(PersistentClass entityDescriptor) {
        return new MetamodelClass(entityDescriptor.getMappedClass().getName(), this.determineSuperTypeName(entityDescriptor));
    }

    private String determineSuperTypeName(PersistentClass entityDescriptor) {
        if (entityDescriptor.getSuperMappedSuperclass() != null) {
            return entityDescriptor.getSuperMappedSuperclass().getMappedClass().getName();
        }
        if (entityDescriptor.getSuperclass() != null) {
            return entityDescriptor.getSuperclass().getMappedClass().getName();
        }
        return null;
    }

    public MetamodelClass metamodelClass(MappedSuperclass mappedSuperclassDescriptor) {
        return new MetamodelClass(mappedSuperclassDescriptor.getMappedClass().getName(), this.determineSuperTypeName(mappedSuperclassDescriptor));
    }

    private String determineSuperTypeName(MappedSuperclass mappedSuperclassDescriptor) {
        if (mappedSuperclassDescriptor.getSuperMappedSuperclass() != null) {
            return mappedSuperclassDescriptor.getSuperMappedSuperclass().getMappedClass().getName();
        }
        if (mappedSuperclassDescriptor.getSuperPersistentClass() != null) {
            return mappedSuperclassDescriptor.getSuperPersistentClass().getMappedClass().getName();
        }
        return null;
    }

    public MetamodelClass metamodelClass(Component embeddedMapping) {
        return new MetamodelClass(embeddedMapping.getComponentClassName(), null);
    }

    public MetamodelAttribute attribute(Property property, Value propertyValueMapping, MetamodelClass metamodelClass, Consumer<Component> componentConsumer) {
        if (propertyValueMapping instanceof DependantValue) {
            DependantValue dependantValue = (DependantValue)propertyValueMapping;
            KeyValue wrappedValue = dependantValue.getWrappedValue();
            return this.attribute(property, (Value)wrappedValue, metamodelClass, componentConsumer);
        }
        if (propertyValueMapping instanceof Collection) {
            return this.pluralAttribute(property, (Collection)propertyValueMapping, metamodelClass, componentConsumer);
        }
        Class<?> propertyJavaType = this.determineSingularJavaType(property, propertyValueMapping, metamodelClass, componentConsumer);
        return new AttributeSingular(metamodelClass, property.getName(), (Class)propertyJavaType);
    }

    private Class<?> determineSingularJavaType(Property property, Value propertyValueMapping, MetamodelClass metamodelClass, Consumer<Component> componentConsumer) {
        if (propertyValueMapping instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)propertyValueMapping;
            return basicValue.resolve().getDomainJavaType().getJavaTypeClass();
        }
        if (propertyValueMapping instanceof Component) {
            Component component = (Component)propertyValueMapping;
            componentConsumer.accept(component);
            return component.getComponentClass();
        }
        if (propertyValueMapping instanceof Any) {
            return Object.class;
        }
        if (propertyValueMapping instanceof ToOne) {
            ToOne toOne = (ToOne)propertyValueMapping;
            String referencedEntityName = toOne.getReferencedEntityName();
            PersistentClass entityBinding = this.metadata.getEntityBinding(referencedEntityName);
            Class mappedClass = entityBinding.getMappedClass();
            if (mappedClass == null) {
                throw new GradleException(String.format(Locale.ROOT, "Could not determine ToOne java type : %s#%s", metamodelClass.getDomainClassName(), property.getName()));
            }
            return mappedClass;
        }
        propertyValueMapping.setTypeUsingReflection(metamodelClass.getDomainClassName(), property.getName());
        return propertyValueMapping.getType().getReturnedClass();
    }

    private MetamodelAttribute pluralAttribute(Property property, Collection collectionMapping, MetamodelClass metamodelClass, Consumer<Component> componentConsumer) {
        if (collectionMapping instanceof Set) {
            return new AttributeSet(metamodelClass, property.getName(), this.determineCollectionPartJavaType(property, collectionMapping.getElement(), metamodelClass, componentConsumer));
        }
        if (collectionMapping instanceof Bag) {
            return new AttributeBag(metamodelClass, property.getName(), this.determineCollectionPartJavaType(property, collectionMapping.getElement(), metamodelClass, componentConsumer));
        }
        if (collectionMapping instanceof List) {
            return new AttributeList(metamodelClass, property.getName(), this.determineCollectionPartJavaType(property, collectionMapping.getElement(), metamodelClass, componentConsumer));
        }
        if (collectionMapping instanceof Map) {
            return new AttributeMap(metamodelClass, property.getName(), this.determineCollectionPartJavaType(property, ((Map)collectionMapping).getIndex(), metamodelClass, componentConsumer), this.determineCollectionPartJavaType(property, collectionMapping.getElement(), metamodelClass, componentConsumer));
        }
        throw new UnsupportedOperationException("Unsupported plural value type : " + collectionMapping.getClass().getName());
    }

    private Class<?> determineCollectionPartJavaType(Property property, Value partJavaType, MetamodelClass metamodelClass, Consumer<Component> componentConsumer) {
        if (partJavaType instanceof DependantValue) {
            DependantValue dependantValue = (DependantValue)partJavaType;
            KeyValue wrappedValue = dependantValue.getWrappedValue();
            return this.determineCollectionPartJavaType(property, (Value)wrappedValue, metamodelClass, componentConsumer);
        }
        if (partJavaType instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)partJavaType;
            return basicValue.resolve().getDomainJavaType().getJavaTypeClass();
        }
        if (partJavaType instanceof Component) {
            Component component = (Component)partJavaType;
            componentConsumer.accept(component);
            return component.getComponentClass();
        }
        if (partJavaType instanceof Any) {
            return Object.class;
        }
        if (partJavaType instanceof OneToMany) {
            OneToMany oneToMany = (OneToMany)partJavaType;
            PersistentClass associatedClass = oneToMany.getAssociatedClass();
            return associatedClass.getMappedClass();
        }
        if (partJavaType instanceof ToOne) {
            Class mappedClass;
            PersistentClass entityBinding;
            ToOne toOne = (ToOne)partJavaType;
            String referencedEntityName = toOne.getReferencedEntityName();
            if (referencedEntityName != null && (entityBinding = this.metadata.getEntityBinding(referencedEntityName)) != null && (mappedClass = entityBinding.getMappedClass()) != null) {
                return mappedClass;
            }
            throw new GradleException(String.format(Locale.ROOT, "Could not determine ToOne java type : %s#%s", metamodelClass.getDomainClassName(), property.getName()));
        }
        return partJavaType.getType().getReturnedClass();
    }
}

