/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.metamodel;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.hibernate.orm.tooling.gradle.Helper;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.metamodel.PersistenceUnitInfoImpl;
import org.hibernate.orm.tooling.gradle.metamodel.model.GenerationOptions;
import org.hibernate.orm.tooling.gradle.metamodel.model.JpaStaticMetamodelGenerator;

public class JpaMetamodelGenerationTask
extends DefaultTask {
    public static final String GEN_TASK_NAME = "generateJpaMetamodel";
    public static final String COMPILE_META_TASK_NAME = "compileJpaMetamodel";
    private final Property<SourceSet> sourceSetProperty;
    private final DirectoryProperty generationOutputDirectory;
    private final Property<Boolean> applyGeneratedAnnotation;
    private final SetProperty<String> suppressions;

    @Inject
    public JpaMetamodelGenerationTask() {
        this.setGroup("hibernate");
        this.setDescription("Generates the JPA 'static metamodel'");
        this.sourceSetProperty = this.getProject().getObjects().property(SourceSet.class);
        this.generationOutputDirectory = this.getProject().getObjects().directoryProperty();
        this.applyGeneratedAnnotation = this.getProject().getObjects().property(Boolean.class);
        this.suppressions = this.getProject().getObjects().setProperty(String.class);
    }

    public void injectSourceSet(Provider<SourceSet> sourceSetAccess) {
        this.sourceSetProperty.set(sourceSetAccess);
    }

    @OutputDirectory
    public DirectoryProperty getGenerationOutputDirectory() {
        return this.generationOutputDirectory;
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSources() {
        return ((SourceSet)this.sourceSetProperty.get()).getOutput();
    }

    @Input
    public Property<Boolean> getApplyGeneratedAnnotation() {
        return this.applyGeneratedAnnotation;
    }

    @Input
    public SetProperty<String> getSuppressions() {
        return this.suppressions;
    }

    @TaskAction
    public void generateJpaMetamodel() {
        ClassLoader classLoader = Helper.toClassLoader((FileCollection)((SourceSet)this.sourceSetProperty.get()).getOutput());
        PersistenceUnitInfoImpl unitInfo = new PersistenceUnitInfoImpl(this.determineUnitUrl(), this.generateIntegrationSettings(), classLoader);
        this.getSources().forEach(dir -> {
            ConfigurableFileTree files = this.getProject().fileTree(dir);
            files.forEach(file -> {
                if (file.getName().endsWith(".class")) {
                    String className = Helper.determineClassName(dir, file);
                    unitInfo.addManagedClassName(className);
                } else if (this.isMappingFile((File)file)) {
                    unitInfo.addMappingFile(file.getName());
                }
            });
        });
        JpaStaticMetamodelGenerator.processMetamodel(unitInfo, this.createGenerationOptions());
    }

    private GenerationOptions createGenerationOptions() {
        return new GenerationOptions(){

            @Override
            public Provider<Directory> getGenerationDirectory() {
                return JpaMetamodelGenerationTask.this.generationOutputDirectory;
            }

            @Override
            public Provider<Boolean> getApplyGeneratedAnnotation() {
                return JpaMetamodelGenerationTask.this.applyGeneratedAnnotation;
            }

            @Override
            public SetProperty<String> getSuppressions() {
                return JpaMetamodelGenerationTask.this.suppressions;
            }
        };
    }

    private URL determineUnitUrl() {
        try {
            return this.getProject().getProjectDir().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Could not interpret project directory as URL");
        }
    }

    private Properties generateIntegrationSettings() {
        Properties settings = new Properties();
        settings.put("hibernate.temp.use_jdbc_metadata_defaults", "false");
        settings.put("hibernate.dialect", "H2");
        settings.put("hibernate.cache.use_second_level_cache", (Object)false);
        settings.put("hibernate.cache.use_query_cache", (Object)false);
        return settings;
    }

    private boolean isMappingFile(File file) {
        String fileName = file.getName();
        return fileName.endsWith(".hbm.xml") || fileName.endsWith(".orm.xml");
    }

    public static void apply(HibernateOrmSpec pluginDsl, Project project) {
    }
}

