/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.enhance;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.cfg.Environment;
import org.hibernate.orm.tooling.gradle.Helper;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementSpec;

public class EnhancementHelper {
    public static void enhance(DirectoryProperty classesDirectoryProperty, ClassLoader classLoader, HibernateOrmSpec ormDsl, Project project) {
        Directory classesDirectory = (Directory)classesDirectoryProperty.get();
        File classesDir = classesDirectory.getAsFile();
        EnhancementSpec enhancementDsl = ormDsl.getEnhancement();
        if (!((Boolean)enhancementDsl.getEnableLazyInitialization().get()).booleanValue()) {
            project.getLogger().warn("The 'enableLazyInitialization' configuration is deprecated and will be removed. Set the value to 'true' to get rid of this warning");
        }
        if (!((Boolean)enhancementDsl.getEnableDirtyTracking().get()).booleanValue()) {
            project.getLogger().warn("The 'enableDirtyTracking' configuration is deprecated and will be removed. Set the value to 'true' to get rid of this warning");
        }
        Enhancer enhancer = EnhancementHelper.generateEnhancer(classLoader, ormDsl);
        EnhancementHelper.walk(classesDir, classesDir, enhancer, project);
    }

    private static void walk(File classesDir, File dir, Enhancer enhancer, Project project) {
        for (File subLocation : dir.listFiles()) {
            if (subLocation.isDirectory()) {
                EnhancementHelper.walk(classesDir, subLocation, enhancer, project);
                continue;
            }
            if (!subLocation.isFile() || !subLocation.getName().endsWith(".class")) continue;
            String className = Helper.determineClassName(classesDir, subLocation);
            long lastModified = subLocation.lastModified();
            EnhancementHelper.enhance(subLocation, className, enhancer, project);
            boolean timestampReset = subLocation.setLastModified(lastModified);
            if (timestampReset) continue;
            project.getLogger().debug("`{}`.setLastModified failed", (Object)project.relativePath((Object)subLocation));
        }
    }

    private static void enhance(File javaClassFile, String className, Enhancer enhancer, Project project) {
        byte[] enhancedBytecode = EnhancementHelper.doEnhancement(javaClassFile, className, enhancer);
        if (enhancedBytecode != null) {
            EnhancementHelper.writeOutEnhancedClass(enhancedBytecode, javaClassFile, project.getLogger());
            project.getLogger().info("Successfully enhanced class : " + className);
        } else {
            project.getLogger().info("Skipping class : " + className);
        }
    }

    private static byte[] doEnhancement(File javaClassFile, String className, Enhancer enhancer) {
        try {
            return enhancer.enhance(className, Files.readAllBytes(javaClassFile.toPath()));
        }
        catch (Exception e) {
            throw new GradleException("Unable to enhance class : " + className, (Throwable)e);
        }
    }

    public static Enhancer generateEnhancer(final ClassLoader classLoader, HibernateOrmSpec ormDsl) {
        final EnhancementSpec enhancementDsl = ormDsl.getEnhancement();
        DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

            public ClassLoader getLoadingClassLoader() {
                return classLoader;
            }

            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return (Boolean)enhancementDsl.getEnableAssociationManagement().get();
            }

            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return (Boolean)enhancementDsl.getEnableDirtyTracking().get();
            }

            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return (Boolean)enhancementDsl.getEnableLazyInitialization().get();
            }

            public boolean isLazyLoadable(UnloadedField field) {
                return (Boolean)enhancementDsl.getEnableLazyInitialization().get();
            }

            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return (Boolean)enhancementDsl.getEnableExtendedEnhancement().get();
            }
        };
        return Environment.getBytecodeProvider().getEnhancer((EnhancementContext)enhancementContext);
    }

    private static void writeOutEnhancedClass(byte[] enhancedBytecode, File file, Logger logger) {
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    logger.error("Unable to recreate class file : " + file.getAbsolutePath());
                }
            } else {
                logger.error("Unable to delete class file : " + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            logger.warn("Problem preparing class file for writing out enhancements [" + file.getAbsolutePath() + "]");
        }
        try {
            Files.write(file.toPath(), enhancedBytecode, new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            throw new GradleException("Error opening class file for writing : " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new GradleException("Error writing enhanced class to file [" + file.getAbsolutePath() + "]", (Throwable)e);
        }
    }

    private EnhancementHelper() {
    }
}

