/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.metamodel.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.hibernate.orm.tooling.gradle.metamodel.JpaMetamodelGenerationSpec;
import org.hibernate.orm.tooling.gradle.metamodel.model.JpaStaticMetamodelGenerator;
import org.hibernate.orm.tooling.gradle.metamodel.model.MetamodelAttribute;

public class MetamodelClass {
    private final String domainClassName;
    private final String metamodelClassName;
    private final String metamodelSuperClassName;
    private final TreeSet<MetamodelAttribute> attributes = new TreeSet<MetamodelAttribute>(Comparator.comparing(MetamodelAttribute::getName));

    public MetamodelClass(String domainClassName, String superTypeName) {
        this.domainClassName = domainClassName;
        this.metamodelClassName = domainClassName + "_";
        this.metamodelSuperClassName = superTypeName == null ? null : superTypeName + "_";
    }

    public String getMetamodelClassName() {
        return this.metamodelClassName;
    }

    public String getDomainClassName() {
        return this.domainClassName;
    }

    public void addAttribute(MetamodelAttribute attribute) {
        assert (attribute != null);
        this.attributes.add(attribute);
    }

    public void writeToFile(File outputFile, JpaMetamodelGenerationSpec spec) {
        this.prepareOutputFile(outputFile);
        Path path = outputFile.toPath();
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.WRITE);){
            this.renderClassPreamble(writer, spec);
            writer.write(13);
            writer.write("public abstract class " + this.metamodelClassName);
            if (this.metamodelSuperClassName != null) {
                writer.write(" extends " + this.metamodelSuperClassName);
            }
            writer.write(" {");
            writer.write(13);
            writer.write(13);
            writer.write("    // Attribute name constants");
            writer.write(13);
            this.attributes.forEach(attribute -> attribute.renderNameConstant(writer));
            writer.write(13);
            writer.write(13);
            writer.write("    // JPA static metamodel fields");
            writer.write(13);
            this.attributes.forEach(attribute -> attribute.renderJpaMembers(writer));
            writer.write(13);
            writer.write("}");
            writer.write(13);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open file : " + outputFile.getAbsolutePath(), e);
        }
    }

    private void renderClassPreamble(BufferedWriter writer, JpaMetamodelGenerationSpec spec) throws IOException {
        Set suppressions;
        String nowFormatted = DateFormat.getDateInstance().format(new Date());
        writer.write("// Generated by Hibernate ORM Gradle tooling - " + nowFormatted);
        writer.write(13);
        writer.write(13);
        writer.write("import javax.persistence.*;");
        writer.write(13);
        writer.write("import javax.persistence.metamodel.*;");
        writer.write(13);
        writer.write(13);
        writer.write("/** JPA static metamodel descriptor for the `" + this.domainClassName + "` domain class */");
        writer.write(13);
        if (((Boolean)spec.getApplyGeneratedAnnotation().getOrElse((Object)true)).booleanValue()) {
            JavaVersion javaVersion = (JavaVersion)spec.getTargetJavaVersionAccess().getOrElse((Object)JavaVersion.current());
            String qualifiedAnnotationName = javaVersion.isJava9Compatible() ? "javax.annotation.processing.Generated" : "javax.annotation.Generated";
            String generatedAnnotationFragment = String.format(Locale.ROOT, "@%s( value=\"%s\", date=\"%s\", comments=\"%s\" )", qualifiedAnnotationName, JpaStaticMetamodelGenerator.class.getName(), nowFormatted, "Generated by Hibernate ORM Gradle tooling");
            writer.write(generatedAnnotationFragment);
            writer.write(13);
        }
        if (!(suppressions = (Set)spec.getSuppressions().getOrElse(Collections.emptySet())).isEmpty()) {
            writer.write("@SuppressWarnings( { ");
            for (String suppression : suppressions) {
                writer.write("\"" + suppression + "\", ");
            }
            writer.write(" } )");
            writer.write(13);
        }
        writer.write("@StaticMetamodel( " + this.domainClassName + ".class )");
    }

    public void prepareOutputFile(File outputFile) {
        try {
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
        }
        catch (IOException e) {
            throw new GradleException("Unable to prepare output file `" + outputFile.getAbsolutePath() + "`", (Throwable)e);
        }
    }
}

