/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.metamodel;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.orm.tooling.gradle.Helper;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.metamodel.model.JpaStaticMetamodelGenerator;
import org.hibernate.orm.tooling.gradle.metamodel.model.MetamodelClass;

public class JpaMetamodelGenerationTask
extends DefaultTask {
    public static final String DSL_NAME = "generateJpaMetamodel";
    public static final String COMPILE_DSL_NAME = "compileJpaMetamodel";
    private final HibernateOrmSpec ormSpec;
    private final DirectoryProperty resourcesOutputDir;
    private final SourceSet mainSourceSet;

    @Inject
    public JpaMetamodelGenerationTask(HibernateOrmSpec ormSpec, SourceSet mainSourceSet, JavaCompile mainCompileTask, Project project) {
        this.ormSpec = ormSpec;
        this.dependsOn(new Object[]{mainCompileTask});
        this.mainSourceSet = mainSourceSet;
        SourceSetOutput mainSourceSetOutput = mainSourceSet.getOutput();
        this.resourcesOutputDir = project.getObjects().directoryProperty();
        this.resourcesOutputDir.set(project.getLayout().dir(project.provider(() -> ((SourceSetOutput)mainSourceSetOutput).getResourcesDir())));
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getJavaClassDirs() {
        return this.mainSourceSet.getOutput();
    }

    @InputFiles
    @SkipWhenEmpty
    public DirectoryProperty getResourcesOutputDir() {
        return this.resourcesOutputDir;
    }

    @OutputDirectory
    public DirectoryProperty getGenerationOutputDirectory() {
        return this.ormSpec.getJpaMetamodelSpec().getGenerationOutputDirectory();
    }

    @TaskAction
    public void generateJpaMetamodel() {
        ClassLoader classLoader = JpaMetamodelGenerationTask.determineUnitClassLoader(this.getProject(), this.mainSourceSet);
        PersistenceUnitInfoImpl unitInfo = new PersistenceUnitInfoImpl(this.determineUnitUrl(), this.generateIntegrationSettings(), classLoader);
        this.getJavaClassDirs().forEach(classesDir -> {
            ConfigurableFileTree files = this.getProject().fileTree(classesDir);
            files.forEach(file -> {
                if (file.getName().endsWith(".class")) {
                    String className = Helper.determineClassName(classesDir, file);
                    unitInfo.addManagedClassName(className);
                } else if (this.isMappingFile((File)file)) {
                    unitInfo.addMappingFile(file.getName());
                }
            });
        });
        this.resourcesOutputDir.getAsFileTree().forEach(file -> {
            if (this.isMappingFile((File)file)) {
                unitInfo.addMappingFile(file.getName());
            }
        });
        JpaStaticMetamodelGenerator.processMetamodel(unitInfo, this.ormSpec.getJpaMetamodelSpec());
    }

    private URL determineUnitUrl() {
        try {
            return this.getProject().getProjectDir().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Could not interpret project directory as URL");
        }
    }

    private static ClassLoader determineUnitClassLoader(Project project, SourceSet mainSourceSet) {
        String compileJavaTaskName = mainSourceSet.getCompileJavaTaskName();
        JavaCompile javaCompileTask = (JavaCompile)project.getTasks().getByName(compileJavaTaskName);
        URL projectClassesDirUrl = JpaMetamodelGenerationTask.toUrl(((Directory)javaCompileTask.getDestinationDirectory().get()).getAsFile());
        return new URLClassLoader(new URL[]{projectClassesDirUrl}, MetamodelClass.class.getClassLoader());
    }

    private static URL toUrl(File file) {
        URI uri = file.toURI();
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new GradleException("Could not convert classpath entry into URL : " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private Properties generateIntegrationSettings() {
        Properties settings = new Properties();
        settings.put("hibernate.temp.use_jdbc_metadata_defaults", "false");
        settings.put("hibernate.dialect", "H2");
        settings.put("hibernate.cache.use_second_level_cache", (Object)false);
        settings.put("hibernate.cache.use_query_cache", (Object)false);
        return settings;
    }

    private boolean isMappingFile(File file) {
        String fileName = file.getName();
        return fileName.endsWith(".hbm.xml") || fileName.endsWith(".orm.xml");
    }

    public static void apply(HibernateOrmSpec ormDsl, SourceSet mainSourceSet, Project project) {
        String mainCompileTaskName = mainSourceSet.getCompileJavaTaskName();
        JavaCompile mainCompileTask = (JavaCompile)project.getTasks().getByName(mainCompileTaskName);
        JpaMetamodelGenerationTask genTask = (JpaMetamodelGenerationTask)project.getTasks().create(DSL_NAME, JpaMetamodelGenerationTask.class, new Object[]{ormDsl, mainSourceSet, mainCompileTask, project});
        genTask.setGroup("hibernate");
        genTask.setDescription("Generates the JPA 'static metamodel'");
        genTask.dependsOn(new Object[]{mainCompileTask});
        Task compileResourcesTask = project.getTasks().getByName("processResources");
        genTask.dependsOn(new Object[]{compileResourcesTask});
        JavaCompile compileJpaMetamodelTask = (JavaCompile)project.getTasks().create(COMPILE_DSL_NAME, JavaCompile.class);
        compileJpaMetamodelTask.setGroup("hibernate");
        compileJpaMetamodelTask.setDescription("Compiles the JPA static metamodel generated by `generateJpaMetamodel`");
        compileJpaMetamodelTask.setSourceCompatibility(mainCompileTask.getSourceCompatibility());
        compileJpaMetamodelTask.setTargetCompatibility(mainCompileTask.getTargetCompatibility());
        genTask.finalizedBy(new Object[]{compileJpaMetamodelTask});
        compileJpaMetamodelTask.dependsOn(new Object[]{genTask});
        compileJpaMetamodelTask.source(new Object[]{project.files(new Object[]{ormDsl.getJpaMetamodelSpec().getGenerationOutputDirectory()})});
        compileJpaMetamodelTask.getDestinationDirectory().set((Provider)ormDsl.getJpaMetamodelSpec().getCompileOutputDirectory());
        compileJpaMetamodelTask.setClasspath(project.getConfigurations().getByName("runtimeClasspath").plus(mainSourceSet.getRuntimeClasspath()));
        compileJpaMetamodelTask.doFirst(task -> {
            project.getLogger().lifecycle("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            project.getLogger().lifecycle("compileJpaMetamodel classpath");
            project.getLogger().lifecycle("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            ((JavaCompile)task).getClasspath().forEach(entry -> project.getLogger().lifecycle("    > {}", new Object[]{entry.getAbsolutePath()}));
            project.getLogger().lifecycle("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        });
    }

    private static class PersistenceUnitInfoImpl
    implements PersistenceUnitInfo {
        private final URL unitRoot;
        private final Properties properties;
        private final ClassLoader classLoader;
        private final List<String> managedClassNames = new ArrayList<String>();
        private final List<String> mappingFileNames = new ArrayList<String>();

        public PersistenceUnitInfoImpl(URL unitRoot, Properties properties, ClassLoader classLoader) {
            this.unitRoot = unitRoot;
            this.properties = properties;
            this.classLoader = classLoader;
        }

        public String getPersistenceUnitName() {
            return "jpa-static-metamodel-gen";
        }

        public URL getPersistenceUnitRootUrl() {
            return this.unitRoot;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public List<String> getManagedClassNames() {
            return this.managedClassNames;
        }

        public void addManagedClassName(String className) {
            this.getManagedClassNames().add(className);
        }

        public List<String> getMappingFileNames() {
            return this.mappingFileNames;
        }

        public void addMappingFile(String fileName) {
            this.getMappingFileNames().add(fileName);
        }

        public String getPersistenceProviderClassName() {
            return HibernatePersistenceProvider.class.getName();
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return null;
        }

        public DataSource getJtaDataSource() {
            return null;
        }

        public DataSource getNonJtaDataSource() {
            return null;
        }

        public List<URL> getJarFileUrls() {
            return null;
        }

        public boolean excludeUnlistedClasses() {
            return true;
        }

        public SharedCacheMode getSharedCacheMode() {
            return null;
        }

        public ValidationMode getValidationMode() {
            return null;
        }

        public String getPersistenceXMLSchemaVersion() {
            return null;
        }

        public void addTransformer(ClassTransformer transformer) {
        }

        public ClassLoader getNewTempClassLoader() {
            return null;
        }
    }
}

