/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.metamodel;

import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;

public class JpaMetamodelGenerationSpec {
    public static final String JPA_METAMODEL = "jpaMetamodel";
    public static final String DSL_NAME = "jpaMetamodel";
    private final Property<Boolean> applyGeneratedAnnotation;
    private final SetProperty<String> suppressions;
    private final DirectoryProperty generationOutputDirectory;
    private final DirectoryProperty compileOutputDirectory;
    private final Provider<JavaVersion> targetJavaVersionAccess;

    @Inject
    public JpaMetamodelGenerationSpec(HibernateOrmSpec ormDsl, Project project) {
        this.applyGeneratedAnnotation = project.getObjects().property(Boolean.class);
        this.applyGeneratedAnnotation.convention((Object)true);
        this.suppressions = project.getObjects().setProperty(String.class);
        this.suppressions.convention(Arrays.asList("raw", "deprecation"));
        this.generationOutputDirectory = project.getObjects().directoryProperty();
        this.generationOutputDirectory.convention(project.getLayout().getBuildDirectory().dir("generated/sources/jpaMetamodel"));
        this.compileOutputDirectory = project.getObjects().directoryProperty();
        this.compileOutputDirectory.convention(project.getLayout().getBuildDirectory().dir("classes/java/jpaMetamodel"));
        this.targetJavaVersionAccess = project.provider(() -> {
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            assert (javaPluginConvention != null);
            SourceSet sourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName("main");
            String compileTaskName = sourceSet.getCompileJavaTaskName();
            JavaCompile compileTask = (JavaCompile)project.getTasks().getByName(compileTaskName);
            return JavaVersion.toVersion((Object)compileTask.getTargetCompatibility());
        });
    }

    public Provider<JavaVersion> getTargetJavaVersionAccess() {
        return this.targetJavaVersionAccess;
    }

    public Property<Boolean> getApplyGeneratedAnnotation() {
        return this.applyGeneratedAnnotation;
    }

    public SetProperty<String> getSuppressions() {
        return this.suppressions;
    }

    public DirectoryProperty getGenerationOutputDirectory() {
        return this.generationOutputDirectory;
    }

    public DirectoryProperty getCompileOutputDirectory() {
        return this.compileOutputDirectory;
    }
}

