/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.hibernate.bytecode.enhance.spi.Enhancer;

public class Helper {
    public static ClassLoader toClassLoader(Directory classesDir) {
        File classesDirFile = classesDir.getAsFile();
        URI classesDirUri = classesDirFile.toURI();
        try {
            URL url = classesDirUri.toURL();
            return new URLClassLoader(new URL[]{url}, Enhancer.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new GradleException("Unable to resolve classpath entry to URL : " + classesDirFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public static String determineClassName(File root, File javaClassFile) {
        Path relativeClassPath = root.toPath().relativize(javaClassFile.toPath());
        String relativeClassPathString = relativeClassPath.toString();
        String classNameBase = relativeClassPathString.substring(0, relativeClassPathString.length() - ".class".length());
        return classNameBase.replace(File.separatorChar, '.');
    }
}

