/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graalvm.internal;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.hibernate.internal.build.AllowSysOut;
import org.hibernate.internal.util.ReflectHelper;

@AutomaticFeature
public final class QueryParsingSupport
implements Feature {
    private final AtomicBoolean triggered = new AtomicBoolean(false);
    private static final boolean log = Boolean.getBoolean("org.hibernate.graalvm.diagnostics");

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class lexerClazz = access.findClassByName("org.hibernate.grammars.hql.HqlLexer");
        Class parserClazz = access.findClassByName("org.hibernate.grammars.hql.HqlParser");
        access.registerReachabilityHandler(this::enableHQLSupport, new Object[]{lexerClazz});
        access.registerReachabilityHandler(this::enableHQLSupport, new Object[]{parserClazz});
    }

    @AllowSysOut
    private void enableHQLSupport(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        boolean needsEnablingYet = this.triggered.compareAndSet(false, true);
        if (needsEnablingYet) {
            if (log) {
                System.out.println("Hibernate ORM 's automatic feature for GraalVM native images: enabling support for HQL query parsing");
            }
            this.enableAntlrParsersSupport();
        }
    }

    private void enableAntlrParsersSupport() {
        Class[] needsHavingSimpleConstructors = QueryParsingSupport.typesNeedingDefaultConstructorAccessible();
        Class[] neddingAllConstructorsAccessible = QueryParsingSupport.typesNeedingAllConstructorsAccessible();
        ArrayList executables = new ArrayList(needsHavingSimpleConstructors.length + neddingAllConstructorsAccessible.length * 3);
        for (Class c : needsHavingSimpleConstructors) {
            executables.add(ReflectHelper.getDefaultConstructor((Class)c));
        }
        for (Class c : neddingAllConstructorsAccessible) {
            for (Constructor<?> declaredConstructor : c.getDeclaredConstructors()) {
                executables.add(declaredConstructor);
            }
        }
        RuntimeReflection.register((Class[])needsHavingSimpleConstructors);
        RuntimeReflection.register((Class[])neddingAllConstructorsAccessible);
        RuntimeReflection.register((Executable[])executables.toArray(new Executable[0]));
    }

    public static Class[] typesNeedingAllConstructorsAccessible() {
        return new Class[0];
    }

    public static Class[] typesNeedingDefaultConstructorAccessible() {
        return new Class[0];
    }
}

