/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.SQLServerLegacySqlAstTranslator;
import org.hibernate.community.dialect.pagination.SQLServer2005LimitHandler;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.SQLServerAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.SQLServerFormatEmulation;
import org.hibernate.dialect.function.SqlServerConvertTruncFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.SQLServerIdentityColumnSupport;
import org.hibernate.dialect.lock.PessimisticLockStyle;
import org.hibernate.dialect.lock.internal.TransactSQLLockingSupport;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.SQLServer2012LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SQLServer16SequenceSupport;
import org.hibernate.dialect.sequence.SQLServerSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.SQLServerLocalTemporaryTableStrategy;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.dialect.type.SQLServerCastingXmlArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.SQLServerCastingXmlJdbcType;
import org.hibernate.dialect.unique.AlterTableUniqueIndexDelegate;
import org.hibernate.dialect.unique.SkipNullableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.internal.StandardSequenceExporter;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsJdbcTimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntAsSmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class SQLServerLegacyDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 2100;
    private static final int GEOMETRY_TYPE_CODE = -157;
    private static final int GEOGRAPHY_TYPE_CODE = -158;
    private final StandardSequenceExporter exporter;
    private final UniqueDelegate uniqueDelegate;
    private final Dialect.SizeStrategy sizeStrategy = new Dialect.SizeStrategyImpl(){

        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            switch (jdbcType.getDdlTypeCode()) {
                case 2004: 
                case 2005: 
                case 2011: {
                    return super.resolveSize(jdbcType, javaType, precision, scale, Long.valueOf(length == null ? SQLServerLegacyDialect.this.getDefaultLobLength() : length.longValue()));
                }
            }
            return super.resolveSize(jdbcType, javaType, precision, scale, length);
        }
    };
    private final StandardTableExporter sqlServerTableExporter = new StandardTableExporter((Dialect)this){

        protected void applyAggregateColumnCheck(StringBuilder buf, AggregateColumn aggregateColumn) {
            JdbcType jdbcType = aggregateColumn.getType().getJdbcType();
            if (jdbcType.isXml()) {
                return;
            }
            super.applyAggregateColumnCheck(buf, aggregateColumn);
        }
    };
    private final LockingSupport lockingSupport = this.buildLockingSupport();

    public SQLServerLegacyDialect() {
        this(DatabaseVersion.make((Integer)8, (Integer)0));
    }

    public SQLServerLegacyDialect(DatabaseVersion version) {
        super(version);
        this.exporter = this.createSequenceExporter(version);
        this.uniqueDelegate = this.createUniqueDelgate(version);
    }

    public SQLServerLegacyDialect(DialectResolutionInfo info) {
        super(info);
        this.exporter = this.createSequenceExporter((DatabaseVersion)info);
        this.uniqueDelegate = this.createUniqueDelgate((DatabaseVersion)info);
    }

    protected LockingSupport buildLockingSupport() {
        boolean sameOrAfter9 = this.getVersion().isSameOrAfter(9);
        return new TransactSQLLockingSupport(PessimisticLockStyle.TABLE_HINT, LockTimeoutType.CONNECTION, sameOrAfter9 ? LockTimeoutType.QUERY : LockTimeoutType.NONE, sameOrAfter9 ? LockTimeoutType.QUERY : LockTimeoutType.NONE, RowLockStrategy.TABLE, OuterJoinLockingType.IDENTIFIED, (ConnectionLockTimeoutStrategy)TransactSQLLockingSupport.SQLServerImpl.IMPL);
    }

    private StandardSequenceExporter createSequenceExporter(DatabaseVersion version) {
        return version.isSameOrAfter(11) ? new SqlServerSequenceExporter((Dialect)this) : null;
    }

    private UniqueDelegate createUniqueDelgate(DatabaseVersion version) {
        return version.isSameOrAfter(10) ? new AlterTableUniqueIndexDelegate((Dialect)this) : new SkipNullableUniqueDelegate((Dialect)this);
    }

    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("top");
        this.registerKeyword("key");
    }

    protected String columnType(int sqlTypeCode) {
        if (sqlTypeCode == 8) {
            return "float";
        }
        if (this.getVersion().isSameOrAfter(9)) {
            switch (sqlTypeCode) {
                case 2005: {
                    return "varchar(max)";
                }
                case 2011: {
                    return "nvarchar(max)";
                }
                case 2004: {
                    return "varbinary(max)";
                }
                case 91: {
                    return this.getVersion().isSameOrAfter(10) ? "date" : super.columnType(sqlTypeCode);
                }
                case 92: {
                    return this.getVersion().isSameOrAfter(10) ? "time" : super.columnType(sqlTypeCode);
                }
                case 93: {
                    return this.getVersion().isSameOrAfter(10) ? "datetime2($p)" : super.columnType(sqlTypeCode);
                }
                case 2013: 
                case 2014: {
                    return this.getVersion().isSameOrAfter(10) ? "datetimeoffset($p)" : super.columnType(sqlTypeCode);
                }
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected String castType(int sqlTypeCode) {
        if (this.getVersion().isSameOrAfter(9)) {
            switch (sqlTypeCode) {
                case 12: 
                case 2005: 
                case 4001: {
                    return "varchar(max)";
                }
                case -9: 
                case 2011: 
                case 4002: {
                    return "nvarchar(max)";
                }
                case -3: 
                case 2004: 
                case 4003: {
                    return "varbinary(max)";
                }
            }
        }
        return super.castType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        if (this.getVersion().isSameOrAfter(10)) {
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3200, "geometry", (Dialect)this));
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3250, "geography", (Dialect)this));
        }
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2009, "xml", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3000, "uniqueidentifier", (Dialect)this));
    }

    public int getPreferredSqlTypeCodeForArray() {
        return 3019;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                switch (columnTypeName) {
                    case "uniqueidentifier": {
                        jdbcTypeCode = 3000;
                    }
                }
                break;
            }
            case -157: {
                jdbcTypeCode = 3200;
                break;
            }
            case -158: {
                jdbcTypeCode = 3250;
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getMaxVarcharLength() {
        return 8000;
    }

    public int getMaxNVarcharLength() {
        return 4000;
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return this.getVersion().isSameOrAfter(10) ? TimeZoneSupport.NATIVE : TimeZoneSupport.NONE;
    }

    public long getDefaultLobLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxIdentifierLength() {
        return 128;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeJdbcType((JdbcType)TimestampUtcAsJdbcTimestampJdbcType.INSTANCE);
        typeContributions.getTypeConfiguration().getJdbcTypeRegistry().addDescriptor(-6, (JdbcType)TinyIntAsSmallIntJdbcType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)SQLServerCastingXmlJdbcType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)UUIDJdbcType.INSTANCE);
        typeContributions.contributeJdbcTypeConstructor((JdbcTypeConstructor)SQLServerCastingXmlArrayJdbcTypeConstructor.INSTANCE);
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        BasicType timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        BasicType timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionContributions.getFunctionRegistry().register("count", (SqmFunctionDescriptor)new CountFunction((Dialect)this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "count_big", "+", "varchar(max)", false, "varbinary(max)"));
        functionFactory.avg_castingNonDoubleArguments((Dialect)this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.log_log();
        functionFactory.round_round();
        functionFactory.everyAny_minMaxIif();
        functionFactory.octetLength_pattern("datalength(?1)");
        functionFactory.bitLength_pattern("datalength(?1)*8");
        if (this.getVersion().isSameOrAfter(10)) {
            functionFactory.locate_charindex();
            functionFactory.stddevPopSamp_stdevp();
            functionFactory.varPopSamp_varp();
        }
        if (this.getVersion().isSameOrAfter(11)) {
            functionContributions.getFunctionRegistry().register("format", (SqmFunctionDescriptor)new SQLServerFormatEmulation(functionContributions.getTypeConfiguration()));
            functionFactory.translate();
            functionFactory.median_percentileCont(true);
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("datefromparts").setInvariantType(dateType).setExactArgumentCount(3).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("timefromparts").setInvariantType(timeType).setExactArgumentCount(5).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("smalldatetimefromparts").setInvariantType(timestampType).setExactArgumentCount(5).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetimefromparts").setInvariantType(timestampType).setExactArgumentCount(7).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetime2fromparts").setInvariantType(timestampType).setExactArgumentCount(8).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
            functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetimeoffsetfromparts").setInvariantType(timestampType).setExactArgumentCount(10).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
        }
        functionFactory.windowFunctions();
        functionFactory.inverseDistributionOrderedSetAggregates_windowEmulation();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        if (this.getVersion().isSameOrAfter(13)) {
            functionFactory.jsonValue_sqlserver();
            functionFactory.jsonQuery_sqlserver();
            functionFactory.jsonExists_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonObject_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonArray_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonSet_sqlserver();
            functionFactory.jsonRemove_sqlserver();
            functionFactory.jsonReplace_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonInsert_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonArrayAppend_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonArrayInsert_sqlserver();
            functionFactory.jsonTable_sqlserver();
        }
        functionFactory.xmlelement_sqlserver();
        functionFactory.xmlcomment_sqlserver();
        functionFactory.xmlforest_sqlserver();
        functionFactory.xmlconcat_sqlserver();
        functionFactory.xmlpi_sqlserver();
        functionFactory.xmlquery_sqlserver();
        functionFactory.xmlexists_sqlserver();
        functionFactory.xmlagg_sqlserver();
        functionFactory.xmltable_sqlserver();
        functionFactory.unnest_sqlserver();
        if (this.getVersion().isSameOrAfter(14)) {
            functionFactory.listagg_stringAggWithinGroup("varchar(max)");
            functionFactory.jsonArrayAgg_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonObjectAgg_sqlserver(this.getVersion().isSameOrAfter(16));
        }
        if (this.getVersion().isSameOrAfter(16)) {
            functionFactory.leastGreatest();
            functionFactory.dateTrunc_datetrunc();
            functionFactory.trunc_round_datetrunc();
            functionFactory.generateSeries_sqlserver(this.getMaximumSeriesSize());
        } else {
            functionContributions.getFunctionRegistry().register("trunc", (SqmFunctionDescriptor)new SqlServerConvertTruncFunction(functionContributions.getTypeConfiguration()));
            functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
            if (this.supportsRecursiveCTE()) {
                functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), false, false);
            }
        }
        if (this.getVersion().isSameOrAfter(17)) {
            functionFactory.regexpLike_predicateFunction();
        }
    }

    protected int getMaximumSeriesSize() {
        if (this.getVersion().isSameOrAfter(16)) {
            return 10000;
        }
        return 100;
    }

    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        if (this.getVersion().isSameOrAfter(16)) {
            switch (specification) {
                case BOTH: {
                    return isWhitespace ? "trim(?1)" : "trim(?2 from ?1)";
                }
                case LEADING: {
                    return isWhitespace ? "ltrim(?1)" : "ltrim(?1,?2)";
                }
                case TRAILING: {
                    return isWhitespace ? "rtrim(?1)" : "rtrim(?1,?2)";
                }
            }
            throw new UnsupportedOperationException("Unsupported specification: " + String.valueOf(specification));
        }
        return super.trimPattern(specification, isWhitespace);
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SQLServerLegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public AggregateSupport getAggregateSupport() {
        return SQLServerAggregateSupport.valueOf((Dialect)this);
    }

    public Dialect.SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case TIMESTAMP: {
                    return "format(?1,'yyyy-MM-dd HH:mm:ss')";
                }
                case TIME: {
                    return "format(?1,'hh\\:mm\\:ss')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    public String currentTimestamp() {
        return "sysdatetime()";
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData metadata) throws SQLException {
        if (metadata == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, metadata);
    }

    public String currentTime() {
        return "convert(time,getdate())";
    }

    public String currentDate() {
        return "convert(date,getdate())";
    }

    public String currentTimestampWithTimeZone() {
        return "sysdatetimeoffset()";
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public LimitHandler getLimitHandler() {
        if (this.getVersion().isSameOrAfter(11)) {
            return SQLServer2012LimitHandler.INSTANCE;
        }
        if (this.getVersion().isSameOrAfter(9)) {
            return new SQLServer2005LimitHandler();
        }
        return new TopLimitHandler(false);
    }

    public boolean supportsValuesList() {
        return this.getVersion().isSameOrAfter(10);
    }

    public boolean supportsDistinctFromPredicate() {
        return this.getVersion().isSameOrAfter(16);
    }

    public char closeQuote() {
        return ']';
    }

    public String getCurrentSchemaCommand() {
        return "select schema_name()";
    }

    public boolean supportsIfExistsBeforeTableName() {
        if (this.getVersion().isSameOrAfter(16)) {
            return true;
        }
        return super.supportsIfExistsBeforeTableName();
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        if (this.getVersion().isSameOrAfter(16)) {
            return true;
        }
        return super.supportsIfExistsBeforeConstraintName();
    }

    public char openQuote() {
        return '[';
    }

    public LockingSupport getLockingSupport() {
        return this.lockingSupport;
    }

    public String appendLockHint(LockOptions lockOptions, String tableName) {
        if (this.getVersion().isSameOrAfter(9)) {
            LockMode lockMode = lockOptions.getLockMode();
            Timeout timeout = lockOptions.getTimeout();
            int timeoutMillis = timeout.milliseconds();
            String writeLockStr = timeoutMillis == -2 ? "updlock" : "updlock,holdlock";
            String readLockStr = timeoutMillis == -2 ? "updlock" : "holdlock";
            String noWaitStr = timeoutMillis == 0 ? ",nowait" : "";
            String skipLockStr = timeoutMillis == -2 ? ",readpast" : "";
            return switch (lockMode) {
                case LockMode.PESSIMISTIC_WRITE, LockMode.WRITE -> tableName + " with (" + writeLockStr + ",rowlock" + noWaitStr + skipLockStr + ")";
                case LockMode.PESSIMISTIC_READ -> tableName + " with (" + readLockStr + ",rowlock" + noWaitStr + skipLockStr + ")";
                case LockMode.UPGRADE_SKIPLOCKED -> tableName + " with (updlock,rowlock,readpast" + noWaitStr + ")";
                case LockMode.UPGRADE_NOWAIT -> tableName + " with (updlock,holdlock,rowlock,nowait)";
                default -> tableName;
            };
        }
        return switch (lockOptions.getLockMode()) {
            case LockMode.PESSIMISTIC_WRITE, LockMode.WRITE, LockMode.UPGRADE_NOWAIT -> tableName + " with (updlock,rowlock)";
            case LockMode.PESSIMISTIC_READ -> tableName + " with (holdlock,rowlock)";
            case LockMode.UPGRADE_SKIPLOCKED -> tableName + " with (updlock,rowlock,readpast)";
            default -> tableName;
        };
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 2100;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return SQLServerIdentityColumnSupport.INSTANCE;
    }

    public boolean supportsNonQueryWithCTE() {
        return this.getVersion().isSameOrAfter(9);
    }

    public SequenceSupport getSequenceSupport() {
        if (this.getVersion().isBefore(11)) {
            return NoSequenceSupport.INSTANCE;
        }
        if (this.getVersion().isSameOrAfter(16)) {
            return SQLServer16SequenceSupport.INSTANCE;
        }
        return SQLServerSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return this.getVersion().isBefore(11) ? super.getQuerySequencesString() : "select * from INFORMATION_SCHEMA.SEQUENCES";
    }

    public String getQueryHintString(String sql, String hints) {
        if (this.getVersion().isBefore(11)) {
            return super.getQueryHintString(sql, hints);
        }
        StringBuilder buffer = new StringBuilder(sql.length() + hints.length() + 12);
        int pos = sql.indexOf(59);
        if (pos > -1) {
            buffer.append(sql, 0, pos);
        } else {
            buffer.append(sql);
        }
        buffer.append(" OPTION (").append(hints).append(")");
        if (pos > -1) {
            buffer.append(";");
        }
        sql = buffer.toString();
        return sql;
    }

    public boolean supportsNullPrecedence() {
        return false;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(9);
    }

    public boolean supportsRecursiveCTE() {
        return this.getVersion().isSameOrAfter(9);
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return this.getVersion().isSameOrAfter(11);
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return new TemplatedViolatedConstraintNameExtractor(sqle -> {
            switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqle)) {
                case 2601: 
                case 2627: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"'", (String)"'", (String)sqle.getMessage());
                }
            }
            return null;
        });
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        if (this.getVersion().isBefore(9)) {
            return super.buildSQLExceptionConversionDelegate();
        }
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqlException);
            if ("HY008".equals(sqlState)) {
                return new QueryTimeoutException(message, sqlException, sql);
            }
            int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException);
            switch (errorCode) {
                case 1222: {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                case 2627: {
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                }
                case 2601: {
                    return new ConstraintViolationException(message, sqlException, sql, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                }
            }
            return null;
        };
    }

    public int getDefaultTimestampPrecision() {
        return 7;
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1L;
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case TIMEZONE_HOUR: {
                return "(datepart(tz,?2)/60)";
            }
            case TIMEZONE_MINUTE: {
                return "(datepart(tz,?2)%60)";
            }
            case SECOND: {
                return "(datepart(second,?2)+datepart(nanosecond,?2)/1000000000)";
            }
            case EPOCH: {
                return "datediff_big(second, '1970-01-01', ?2)";
            }
            case WEEK: {
                if (!this.getVersion().isBefore(10)) break;
                return "(DATEPART(dy,DATEADD(dd,DATEDIFF(dd,'17530101',?2)/7*7,'17530104'))+6)/7)";
            }
        }
        return "datepart(?1,?2)";
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "dateadd(nanosecond,?2%1000000000,dateadd(second,?2/1000000000,?3))";
            }
        }
        return "dateadd(?1,?2,?3)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == TemporalUnit.NATIVE) {
            return "datediff_big(nanosecond,?2,?3)";
        }
        return unit.normalized() == TemporalUnit.NANOSECOND ? "datediff_big(?1,?2,?3)" : "datediff(?1,?2,?3)";
    }

    public String translateDurationField(TemporalUnit unit) {
        if (unit == TemporalUnit.NATIVE) {
            return "nanosecond";
        }
        return super.translateDurationField(unit);
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "isowk";
            }
            case OFFSET: {
                return "tz";
            }
        }
        return super.translateExtractField(unit);
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SQLServerLegacyDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "\"").replace("G", "g").replace("EEEE", "dddd").replace("EEE", "ddd").replace("a", "tt").replace("S", "F").replace("XXX", "K").replace("xxx", "zzz").replace("x", "zz");
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("0x");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
    }

    public void appendUUIDLiteral(SqlAppender appender, UUID literal) {
        appender.appendSql("cast('");
        appender.appendSql(literal.toString());
        appender.appendSql("' as uniqueidentifier)");
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone);
                    appender.appendSql("' as datetimeoffset)");
                    break;
                }
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)false, (TimeZone)jdbcTimeZone);
                appender.appendSql("' as datetime2)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Date)date);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql("' as datetimeoffset)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql("' as datetime2)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public TemporaryTableStrategy getLocalTemporaryTableStrategy() {
        return SQLServerLocalTemporaryTableStrategy.INSTANCE;
    }

    public String getCreateTemporaryTableColumnAnnotation(int sqlTypeCode) {
        return SQLServerLocalTemporaryTableStrategy.INSTANCE.getCreateTemporaryTableColumnAnnotation(sqlTypeCode);
    }

    public String[] getDropSchemaCommand(String schemaName) {
        if (this.getVersion().isSameOrAfter(13)) {
            return new String[]{"drop schema if exists " + schemaName};
        }
        return super.getDropSchemaCommand(schemaName);
    }

    public String getCreateIndexString(boolean unique) {
        return unique ? "create unique nonclustered index" : "create index";
    }

    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        if (unique) {
            StringBuilder tail = new StringBuilder();
            for (Column column : columns) {
                if (!column.isNullable()) continue;
                tail.append(tail.length() == 0 ? " where " : " and ").append(column.getQuotedName((Dialect)this)).append(" is not null");
            }
            return tail.toString();
        }
        return "";
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.BOTH;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public Exporter<Table> getTableExporter() {
        return this.sqlServerTableExporter;
    }

    public Exporter<Sequence> getSequenceExporter() {
        if (this.exporter == null) {
            return super.getSequenceExporter();
        }
        return this.exporter;
    }

    public String generatedAs(String generatedAs) {
        return " as (" + generatedAs + ") persisted";
    }

    public boolean hasDataTypeBeforeGeneratedAs() {
        return false;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    public String getCheckConstraintString(CheckConstraint checkConstraint) {
        String constraintName = checkConstraint.getName();
        Object checkWithName = StringHelper.isBlank((String)constraintName) ? " check" : " constraint " + constraintName + " check";
        return this.appendCheckConstraintOptions(checkConstraint, (String)checkWithName) + " (" + checkConstraint.getConstraint() + ")";
    }

    public String appendCheckConstraintOptions(CheckConstraint checkConstraint, String sqlCheckConstraint) {
        return StringHelper.isNotEmpty((String)checkConstraint.getOptions()) ? sqlCheckConstraint + " " + checkConstraint.getOptions() : sqlCheckConstraint;
    }

    public boolean supportsJoinsInDelete() {
        return true;
    }

    public boolean supportsSimpleQueryGrouping() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    private static class SqlServerSequenceExporter
    extends StandardSequenceExporter {
        public SqlServerSequenceExporter(Dialect dialect) {
            super(dialect);
        }

        protected String getFormattedSequenceName(QualifiedSequenceName name, Metadata metadata, SqlStringGenerationContext context) {
            return context.formatWithoutCatalog(name);
        }
    }
}

