/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.RDMSOS2200SqlAstTranslator;
import org.hibernate.community.dialect.sequence.RDMSSequenceSupport;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.internal.LockingSupportSimple;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.FetchLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.internal.NonLockingClauseStrategy;
import org.hibernate.sql.ast.spi.LockingClauseStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class RDMSOS2200Dialect
extends Dialect {
    public RDMSOS2200Dialect() {
        super((DatabaseVersion)SimpleDatabaseVersion.ZERO_VERSION);
    }

    public RDMSOS2200Dialect(DialectResolutionInfo info) {
        super(info);
    }

    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -6, 16 -> "smallint";
            case -5 -> "numeric(19,0)";
            case -15, -9, 1, 12, 4001, 4002 -> "unicode($l)";
            case 2005, 2011 -> "clob($l)";
            case -3, -2, 2004, 4003 -> "blob($l)";
            case 2014 -> this.columnType(93);
            default -> super.columnType(sqlTypeCode);
        };
    }

    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    public int getMaxVarbinaryLength() {
        return -1;
    }

    public DatabaseVersion getVersion() {
        return SimpleDatabaseVersion.ZERO_VERSION;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    public int getDefaultDecimalPrecision() {
        return 21;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.cot();
        functionFactory.log();
        functionFactory.log10();
        functionFactory.pi();
        functionFactory.rand();
        functionFactory.trunc();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.initcap();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.translate();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.ascii();
        functionFactory.chr_char();
        functionFactory.insert();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new RDMSOS2200SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.SECOND -> "(second(?2)+microsecond(?2)/1e6)";
            case TemporalUnit.DAY_OF_WEEK -> "dayofweek(?2)";
            case TemporalUnit.DAY_OF_MONTH -> "dayofmonth(?2)";
            case TemporalUnit.DAY_OF_YEAR -> "dayofyear(?2)";
            default -> "?1(?2)";
        };
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return switch (unit) {
            case TemporalUnit.NANOSECOND -> "timestampadd('SQL_TSI_FRAC_SECOND',(?2)/1e3,?3)";
            case TemporalUnit.NATIVE -> "timestampadd('SQL_TSI_FRAC_SECOND',?2,?3)";
            default -> "dateadd('?1',?2,?3)";
        };
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return switch (unit) {
            case TemporalUnit.NANOSECOND -> "timestampdiff('SQL_TSI_FRAC_SECOND',?2,?3)*1e3";
            case TemporalUnit.NATIVE -> "timestampdiff('SQL_TSI_FRAC_SECOND',?2,?3)";
            default -> "dateadd('?1',?2,?3)";
        };
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public LockingSupport getLockingSupport() {
        return LockingSupportSimple.NO_OUTER_JOIN;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getNullColumnString() {
        return " null";
    }

    public SequenceSupport getSequenceSupport() {
        return RDMSSequenceSupport.INSTANCE;
    }

    public String getCascadeConstraintsString() {
        return " including contents";
    }

    public LimitHandler getLimitHandler() {
        return FetchLimitHandler.INSTANCE;
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    protected LockingStrategy buildPessimisticWriteStrategy(EntityPersister lockable, LockMode lockMode, Locking.Scope lockScope) {
        return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
    }

    protected LockingStrategy buildPessimisticReadStrategy(EntityPersister lockable, LockMode lockMode, Locking.Scope lockScope) {
        return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
    }

    public LockingClauseStrategy getLockingClauseStrategy(QuerySpec querySpec, LockOptions lockOptions) {
        return NonLockingClauseStrategy.NON_CLAUSE_STRATEGY;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)true, (boolean)false).replace("SSSSSS", "MLS").replace("SSSSS", "MLS").replace("SSSS", "MLS").replace("SSS", "MLS").replace("SS", "MLS").replace("S", "MLS").result());
    }

    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        return AbstractTransactSQLDialect.replaceLtrimRtrim((TrimSpec)specification, (boolean)isWhitespace);
    }

    public String getDual() {
        return "rdms.rdms_dummy";
    }

    public String getFromDualForSelectOnly() {
        return " from " + this.getDual() + " where key_col=1";
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }
}

