/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstTranslatorWithMerge;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class InformixSqlAstTranslator<T extends JdbcOperation>
extends SqlAstTranslatorWithMerge<T> {
    public InformixSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void visitQueryClauses(QuerySpec querySpec) {
        this.visitSelectClause(querySpec.getSelectClause());
        this.visitFromClause(querySpec.getFromClause());
        if (!this.hasFrom(querySpec.getFromClause()) && this.hasWhere(querySpec.getWhereClauseRestrictions()) && this.getDialect().getFromDualForSelectOnly().isBlank()) {
            this.append(" from ");
            this.append(this.getDual());
        }
        this.visitWhereClause(querySpec.getWhereClauseRestrictions());
        this.visitGroupByClause(querySpec, this.getDialect().getGroupBySelectItemReferenceStrategy());
        this.visitHavingClause(querySpec);
        this.visitOrderBy(querySpec.getSortSpecifications());
        this.visitOffsetFetchClause((QueryPart)querySpec);
    }

    public void visitSelectClause(SelectClause selectClause) {
        this.getClauseStack().push((Object)Clause.SELECT);
        try {
            this.appendSql("select ");
            this.visitSqlSelections(selectClause);
            this.renderVirtualSelections(selectClause);
        }
        finally {
            this.getClauseStack().pop();
        }
    }

    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        QuerySpec querySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
        if (this.isRowsOnlyFetchClauseType((QueryPart)querySpec)) {
            if (this.supportsSkipFirstClause()) {
                this.renderSkipFirstClause(querySpec);
            } else {
                this.renderFirstClause(querySpec);
            }
        }
        if (selectClause.isDistinct()) {
            this.appendSql("distinct ");
        }
        super.visitSqlSelections(selectClause);
    }

    protected boolean needsRowsToSkip() {
        return !this.supportsSkipFirstClause();
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    protected void beforeQueryGroup(QueryGroup queryGroup, QueryPart currentQueryPart) {
        if (queryGroup.isRoot() && queryGroup.hasOffsetOrFetchClause()) {
            this.append("select ");
            this.renderFirstSkipClause(queryGroup.getOffsetClauseExpression(), queryGroup.getFetchClauseExpression());
            this.append("* from ");
            this.append('(');
        }
    }

    protected void afterQueryGroup(QueryGroup queryGroup, QueryPart currentQueryPart) {
        if (queryGroup.isRoot() && queryGroup.hasOffsetOrFetchClause()) {
            this.append(')');
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("dummy_.x");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        this.renderIntoIntoAndTable(tableInsert);
        this.appendSql("values (0)");
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return this.getDialect().getVersion().isSameOrAfter(11);
    }

    private boolean supportsSkipFirstClause() {
        return this.getDialect().getVersion().isSameOrAfter(11);
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
    }

    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.getDialect().supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    protected void visitArithmeticOperand(Expression expression) {
        if (expression instanceof SqmParameterInterpretation && expression.getExpressionType() != null && expression.getExpressionType().getJdbcTypeCount() == 1) {
            String castType;
            switch (expression.getExpressionType().getSingleJdbcMapping().getCastType()) {
                case FLOAT: 
                case DOUBLE: {
                    String string = "float";
                    break;
                }
                case INTEGER: {
                    String string = "integer";
                    break;
                }
                case LONG: {
                    String string = "bigint";
                    break;
                }
                default: {
                    String string = castType = null;
                }
            }
            if (castType != null) {
                this.append("cast(");
            }
            super.visitArithmeticOperand(expression);
            if (castType != null) {
                this.append(" as ");
                this.append(castType);
                this.append(")");
            }
        } else {
            super.visitArithmeticOperand(expression);
        }
    }

    private static boolean isConcatFunction(Expression expression) {
        FunctionExpression fn;
        return expression instanceof FunctionExpression && (fn = (FunctionExpression)expression).getFunctionName().equals("concat");
    }

    private void caseArgument(Expression expression) {
        if (InformixSqlAstTranslator.isConcatFunction(expression)) {
            this.append("cast(");
            expression.accept((SqlAstWalker)this);
            this.append(" as varchar(255))");
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    protected void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, boolean inSelect) {
        this.visitAnsiCaseSearchedExpression(caseSearchedExpression, this::caseArgument);
    }

    protected void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, boolean inSelect) {
        this.visitAnsiCaseSimpleExpression(caseSimpleExpression, this::caseArgument);
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql("floor");
        }
        super.visitBinaryArithmeticExpression(arithmeticExpression);
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getDialect().getVersion().isSameOrAfter(12, 10) && this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        }
    }

    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        if (InformixSqlAstTranslator.hasNonTrivialFromClause((FromClause)statement.getFromClause())) {
            this.visitUpdateStatementEmulateMerge(statement);
        } else {
            super.visitUpdateStatementOnly(statement);
        }
    }
}

