/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.Month;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.community.dialect.HANALegacyDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.jboss.logging.Logger;

public class HANALegacyServerConfiguration {
    private static final Pattern CLOUD_VERSION_PATTERN = Pattern.compile("\\(fa/CE(\\d+)\\.(\\d+)\\)");
    public static final int MAX_LOB_PREFETCH_SIZE_DEFAULT_VALUE = 1024;
    private final DatabaseVersion fullVersion;
    private final int maxLobPrefetchSize;

    public HANALegacyServerConfiguration(DatabaseVersion fullVersion) {
        this(fullVersion, 1024);
    }

    public HANALegacyServerConfiguration(DatabaseVersion fullVersion, int maxLobPrefetchSize) {
        this.fullVersion = fullVersion;
        this.maxLobPrefetchSize = maxLobPrefetchSize;
    }

    public DatabaseVersion getFullVersion() {
        return this.fullVersion;
    }

    public int getMaxLobPrefetchSize() {
        return this.maxLobPrefetchSize;
    }

    public static HANALegacyServerConfiguration fromDialectResolutionInfo(DialectResolutionInfo info) {
        Integer maxLobPrefetchSize = null;
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        DatabaseVersion databaseVersion = null;
        if (databaseMetaData != null) {
            int databaseMajorVersion = -1;
            try {
                databaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (SQLException e) {
                Logger.getLogger(HANALegacyServerConfiguration.class).debug((Object)"An error occurred while trying to determine the database version.", (Throwable)e);
            }
            if (databaseMajorVersion > 0 && databaseMajorVersion < 4) {
                try (Statement statement = databaseMetaData.getConnection().createStatement();
                     ResultSet rs = statement.executeQuery("SELECT TOP 1 VALUE,MAP(LAYER_NAME,'DEFAULT',1,'SYSTEM',2,'DATABASE',3,4) AS LAYER FROM SYS.M_CONFIGURATION_PARAMETER_VALUES WHERE FILE_NAME='indexserver.ini' AND SECTION='session' AND KEY='max_lob_prefetch_size' ORDER BY LAYER DESC");){
                    if (rs.next()) {
                        maxLobPrefetchSize = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    Logger.getLogger(HANALegacyServerConfiguration.class).debug((Object)"An error occurred while trying to determine the value of the HANA parameter indexserver.ini / session / max_lob_prefetch_size.", (Throwable)e);
                }
            } else {
                databaseVersion = HANALegacyServerConfiguration.determineDatabaseVersion(info);
            }
        }
        if (maxLobPrefetchSize == null) {
            maxLobPrefetchSize = ConfigurationHelper.getInt((String)"hibernate.dialect.hana.max_lob_prefetch_size", (Map)info.getConfigurationValues(), (int)1024);
        }
        if (databaseVersion == null) {
            databaseVersion = HANALegacyServerConfiguration.staticDetermineDatabaseVersion(info);
        }
        return new HANALegacyServerConfiguration(databaseVersion, maxLobPrefetchSize);
    }

    public static DatabaseVersion determineDatabaseVersion(DialectResolutionInfo info) {
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        String databaseVersion = null;
        if (databaseMetaData != null) {
            try (Statement statement = databaseMetaData.getConnection().createStatement();
                 ResultSet rs = statement.executeQuery("SELECT VALUE FROM M_SYSTEM_OVERVIEW WHERE NAME='Version'");){
                if (rs.next()) {
                    databaseVersion = rs.getString(1);
                }
            }
            catch (SQLException e) {
                Logger.getLogger(HANALegacyServerConfiguration.class).debug((Object)"An error occurred while trying to determine the HANA Cloud version.", (Throwable)e);
            }
        }
        return databaseVersion == null ? HANALegacyServerConfiguration.staticDetermineDatabaseVersion(info) : HANALegacyServerConfiguration.determineDatabaseVersion(databaseVersion);
    }

    public static DatabaseVersion determineDatabaseVersion(String versionString) {
        if (versionString == null) {
            return HANALegacyDialect.DEFAULT_VERSION;
        }
        String[] components = StringHelper.split((String)" ", (String)versionString);
        DatabaseVersion databaseVersion = HANALegacyServerConfiguration.staticDetermineDatabaseVersion(components[0]);
        if (components.length == 1 || databaseVersion.isBefore(4)) {
            return databaseVersion;
        }
        Matcher matcher = CLOUD_VERSION_PATTERN.matcher(components[1]);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int week = Integer.parseInt(matcher.group(2));
            return new SimpleDatabaseVersion(databaseVersion.getDatabaseMajorVersion(), HANALegacyServerConfiguration.getHanaCloudVersion(LocalDate.of(year, 1, 1).plusWeeks(week)), databaseVersion.getDatabaseMicroVersion());
        }
        return databaseVersion;
    }

    private static int getHanaCloudVersion(LocalDate date) {
        int quarter = switch (date.getMonth()) {
            default -> throw new IncompatibleClassChangeError();
            case Month.JANUARY, Month.FEBRUARY, Month.MARCH -> 1;
            case Month.APRIL, Month.MAY, Month.JUNE -> 2;
            case Month.JULY, Month.AUGUST, Month.SEPTEMBER -> 3;
            case Month.OCTOBER, Month.NOVEMBER, Month.DECEMBER -> 4;
        };
        return date.getYear() * 10 + quarter;
    }

    public static DatabaseVersion staticDetermineDatabaseVersion(DialectResolutionInfo info) {
        return HANALegacyServerConfiguration.staticDetermineDatabaseVersion(info.getDatabaseVersion());
    }

    public static DatabaseVersion staticDetermineDatabaseVersion(String versionString) {
        int majorVersion = 1;
        int minorVersion = 0;
        int patchLevel = 0;
        if (versionString == null) {
            return HANALegacyDialect.DEFAULT_VERSION;
        }
        String[] components = StringHelper.split((String)".", (String)versionString);
        if (components.length >= 3) {
            try {
                majorVersion = Integer.parseInt(components[0]);
                minorVersion = Integer.parseInt(components[1]);
                patchLevel = Integer.parseInt(components[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DatabaseVersion.make((Integer)majorVersion, (Integer)minorVersion, (Integer)patchLevel);
    }
}

