/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractSimpleLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class TimesTenLimitHandler
extends AbstractSimpleLimitHandler {
    public static final TimesTenLimitHandler INSTANCE = new TimesTenLimitHandler();

    public boolean supportsLimitOffset() {
        return true;
    }

    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult + 1;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    protected String limitClause(boolean hasFirstRow) {
        return hasFirstRow ? " rows ? to ?" : " first ?";
    }

    protected String limitClause(boolean hasFirstRow, int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        String firstParameter = parameterMarkerStrategy.createMarker(1, null);
        if (hasFirstRow) {
            return " rows " + firstParameter + " to " + parameterMarkerStrategy.createMarker(2, null);
        }
        return " first " + firstParameter;
    }

    protected String offsetOnlyClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return " rows " + parameterMarkerStrategy.createMarker(1, null) + " to 2147483647";
    }

    public int getParameterPositionStart(Limit limit) {
        return TimesTenLimitHandler.hasMaxRows((Limit)limit) ? (TimesTenLimitHandler.hasFirstRow((Limit)limit) ? 3 : 2) : (TimesTenLimitHandler.hasFirstRow((Limit)limit) ? 2 : 1);
    }
}

