/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Red Hat Inc. and Hibernate Authors
 */
package org.hibernate.community.dialect.identity;

/**
 * @author Andrea Boriero
 */
public class Ingres10IdentityColumnSupport extends Ingres9IdentityColumnSupport {

	public static final Ingres10IdentityColumnSupport INSTANCE = new Ingres10IdentityColumnSupport();

	@Override
	public boolean supportsIdentityColumns() {
		return true;
	}

	@Override
	public boolean hasDataTypeInIdentityColumn() {
		return true;
	}

	@Override
	public String getIdentityColumnString(int type) {
		return "not null generated by default as identity";
	}

	@Override
	public String getIdentityInsertString() {
		return "default";
	}
}
