/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.HANALegacyServerConfiguration;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.HANAServerConfiguration;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.HANAAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.IntegralTimestampaddFunction;
import org.hibernate.dialect.identity.HANAIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.sequence.HANASequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sql.ast.HANASqlAstTranslator;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.NClobImplementer;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorHANADatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.DoubleJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.DecimalJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NCharJdbcType;
import org.hibernate.type.descriptor.jdbc.NClobJdbcType;
import org.hibernate.type.descriptor.jdbc.NVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.NumericJdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntAsSmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class HANALegacyDialect
extends Dialect {
    static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make((Integer)1, (Integer)0, (Integer)120);
    public static final String USE_DEFAULT_TABLE_TYPE_COLUMN = "hibernate.dialect.hana.use_default_table_type_column";
    private static final String USE_LEGACY_BOOLEAN_TYPE_PARAMETER_NAME = "hibernate.dialect.hana.use_legacy_boolean_type";
    private static final String USE_UNICODE_STRING_TYPES_PARAMETER_NAME = "hibernate.dialect.hana.use_unicode_string_types";
    private static final String TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_PARAMETER_NAME = "hibernate.dialect.hana.treat_double_typed_fields_as_decimal";
    private static final Boolean USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE = Boolean.FALSE;
    private static final Boolean TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_DEFAULT_VALUE = Boolean.FALSE;
    private static final String SQL_IGNORE_LOCKED = " ignore locked";
    private final int maxLobPrefetchSize;
    private boolean defaultTableTypeColumn;
    private boolean useLegacyBooleanType = USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE;
    private boolean useUnicodeStringTypes;
    private boolean treatDoubleTypedFieldsAsDecimal;
    private final StandardTableExporter hanaTableExporter = new StandardTableExporter(this){

        public String[] getSqlCreateStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
            String[] sqlCreateStrings = super.getSqlCreateStrings(table, metadata, context);
            return this.quoteTypeIfNecessary(table, sqlCreateStrings, HANALegacyDialect.this.getCreateTableString());
        }

        public String[] getSqlDropStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
            String[] sqlDropStrings = super.getSqlDropStrings(table, metadata, context);
            return this.quoteTypeIfNecessary(table, sqlDropStrings, "drop table");
        }

        private String[] quoteTypeIfNecessary(Table table, String[] strings, String prefix) {
            if (table.getNameIdentifier() == null || table.getNameIdentifier().isQuoted() || !"type".equalsIgnoreCase(table.getNameIdentifier().getText())) {
                return strings;
            }
            Pattern createTableTypePattern = Pattern.compile("(" + prefix + "\\s+)(" + table.getNameIdentifier().getText() + ")(.+)");
            Pattern commentOnTableTypePattern = Pattern.compile("(comment\\s+on\\s+table\\s+)(" + table.getNameIdentifier().getText() + ")(.+)");
            for (int i = 0; i < strings.length; ++i) {
                Matcher createTableTypeMatcher = createTableTypePattern.matcher(strings[i]);
                Matcher commentOnTableTypeMatcher = commentOnTableTypePattern.matcher(strings[i]);
                if (createTableTypeMatcher.matches()) {
                    strings[i] = createTableTypeMatcher.group(1) + "\"TYPE\"" + createTableTypeMatcher.group(3);
                }
                if (!commentOnTableTypeMatcher.matches()) continue;
                strings[i] = commentOnTableTypeMatcher.group(1) + "\"TYPE\"" + commentOnTableTypeMatcher.group(3);
            }
            return strings;
        }
    };

    public HANALegacyDialect(DialectResolutionInfo info) {
        this(HANAServerConfiguration.fromDialectResolutionInfo((DialectResolutionInfo)info), true);
        this.registerKeywords(info);
    }

    public HANALegacyDialect() {
        this(DEFAULT_VERSION);
    }

    public HANALegacyDialect(DatabaseVersion version) {
        this(new HANAServerConfiguration(version), true);
    }

    public HANALegacyDialect(DatabaseVersion version, boolean defaultTableTypeColumn) {
        this(new HANAServerConfiguration(version), defaultTableTypeColumn);
    }

    public HANALegacyDialect(HANAServerConfiguration configuration, boolean defaultTableTypeColumn) {
        super(configuration.getFullVersion());
        this.defaultTableTypeColumn = defaultTableTypeColumn;
        this.maxLobPrefetchSize = configuration.getMaxLobPrefetchSize();
        this.useUnicodeStringTypes = this.useUnicodeStringTypesDefault();
    }

    public DatabaseVersion determineDatabaseVersion(DialectResolutionInfo info) {
        return HANALegacyServerConfiguration.staticDetermineDatabaseVersion(info);
    }

    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.requireService(ConfigurationService.class);
        this.defaultTableTypeColumn = (Boolean)configurationService.getSetting(USE_DEFAULT_TABLE_TYPE_COLUMN, StandardConverters.BOOLEAN, (Object)this.defaultTableTypeColumn);
        if (this.supportsAsciiStringTypes()) {
            this.useUnicodeStringTypes = (Boolean)configurationService.getSetting(USE_UNICODE_STRING_TYPES_PARAMETER_NAME, StandardConverters.BOOLEAN, (Object)this.useUnicodeStringTypesDefault());
        }
        this.useLegacyBooleanType = (Boolean)configurationService.getSetting(USE_LEGACY_BOOLEAN_TYPE_PARAMETER_NAME, StandardConverters.BOOLEAN, (Object)USE_LEGACY_BOOLEAN_TYPE_DEFAULT_VALUE);
        this.treatDoubleTypedFieldsAsDecimal = (Boolean)configurationService.getSetting(TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_PARAMETER_NAME, StandardConverters.BOOLEAN, (Object)TREAT_DOUBLE_TYPED_FIELDS_AS_DECIMAL_DEFAULT_VALUE);
        super.contribute(typeContributions, serviceRegistry);
    }

    protected boolean isDefaultTableTypeColumn() {
        return this.defaultTableTypeColumn;
    }

    protected boolean isCloud() {
        return this.getVersion().isSameOrAfter(4);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return this.useLegacyBooleanType ? "tinyint" : super.columnType(sqlTypeCode);
            }
            case 2: {
                return this.columnType(3);
            }
            case 8: {
                return "double";
            }
            case 92: 
            case 2013: {
                return "time";
            }
            case 93: 
            case 2014: {
                return "timestamp";
            }
            case 1: 
            case 12: {
                return this.isUseUnicodeStringTypes() ? this.columnType(-9) : super.columnType(12);
            }
            case -15: {
                return this.columnType(-9);
            }
            case 4001: {
                return this.isUseUnicodeStringTypes() ? this.columnType(4002) : super.columnType(4001);
            }
            case 2005: {
                return this.isUseUnicodeStringTypes() ? this.columnType(2011) : super.columnType(2005);
            }
            case -6: {
                return "smallint";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-2, (CapacityDependentDdlType.LobKind)CapacityDependentDdlType.LobKind.BIGGEST_LOB, (String)"blob", (Dialect)this).withTypeCapacity((long)this.getMaxVarbinaryLength(), "varbinary($l)").build());
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3200, "st_geometry", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3201, "st_point", (Dialect)this));
    }

    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    public boolean getDefaultUseGetGeneratedKeys() {
        return false;
    }

    public String castPattern(CastType from, CastType to) {
        if (to == CastType.BOOLEAN) {
            switch (from) {
                case INTEGER_BOOLEAN: 
                case INTEGER: 
                case LONG: {
                    return "case ?1 when 1 then true when 0 then false else null end";
                }
                case YN_BOOLEAN: {
                    return "case ?1 when 'Y' then true when 'N' then false else null end";
                }
                case TF_BOOLEAN: {
                    return "case ?1 when 'T' then true when 'F' then false else null end";
                }
            }
        }
        return super.castPattern(from, to);
    }

    public int getDefaultTimestampPrecision() {
        return 7;
    }

    public int getDefaultDecimalPrecision() {
        return 34;
    }

    public int getMaxVarcharLength() {
        return 5000;
    }

    public int getMaxNVarcharLength() {
        return 5000;
    }

    public int getMaxVarbinaryLength() {
        return 5000;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "locate(?2,?1)", "locate(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, typeConfiguration).setArgumentListSignature("(pattern, string[, start])");
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.trim2();
        functionFactory.cot();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.trunc_roundMode();
        functionFactory.log10_log();
        functionFactory.log();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.hourMinuteSecond();
        functionFactory.yearMonthDay();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.characterLength_length(SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.ascii();
        functionFactory.chr_char();
        functionFactory.addYearsMonthsDaysHoursMinutesSeconds();
        functionFactory.daysBetween();
        functionFactory.secondsBetween();
        functionFactory.format_toVarchar();
        functionFactory.currentUtcdatetimetimestamp();
        functionFactory.everyAny_minMaxCase();
        functionFactory.octetLength_pattern("length(to_binary(?1))");
        functionFactory.bitLength_pattern("length(to_binary(?1))*8");
        functionFactory.repeat_rpad();
        functionFactory.median();
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("varchar");
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        functionFactory.radians_acos();
        functionFactory.degrees_acos();
        functionContributions.getFunctionRegistry().register("timestampadd", (SqmFunctionDescriptor)new IntegralTimestampaddFunction((Dialect)this, typeConfiguration));
        functionContributions.getFunctionRegistry().registerNamed("score", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE));
        functionContributions.getFunctionRegistry().registerNamed("snippets");
        functionContributions.getFunctionRegistry().registerNamed("highlighted");
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("contains", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN), "contains(?1,?2)", "contains(?1,?2,?3)", FunctionParameterType.ANY, FunctionParameterType.ANY, FunctionParameterType.ANY, typeConfiguration);
        if (this.getVersion().isSameOrAfter(2, 0)) {
            functionFactory.jsonValue_no_passing();
            functionFactory.jsonQuery_no_passing();
            functionFactory.jsonExists_hana();
            functionFactory.unnest_hana();
            functionFactory.jsonTable_hana();
            functionFactory.generateSeries_hana(this.getMaximumSeriesSize());
            if (this.getVersion().isSameOrAfter(2, 0, 20)) {
                if (this.getVersion().isSameOrAfter(2, 0, 40)) {
                    functionFactory.jsonObject_hana();
                    functionFactory.jsonArray_hana();
                    functionFactory.jsonArrayAgg_hana();
                    functionFactory.jsonObjectAgg_hana();
                }
                functionFactory.xmltable_hana();
            }
        }
    }

    protected int getMaximumSeriesSize() {
        return 10000;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new HANASqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public AggregateSupport getAggregateSupport() {
        return HANAAggregateSupport.valueOf((Dialect)this);
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(mod(weekday(?2)+1,7)+1)";
            }
            case DAY: 
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case QUARTER: {
                return "((month(?2)+2)/3)";
            }
            case EPOCH: {
                return "seconds_between('1970-01-01', ?2)";
            }
        }
        return "?1(?2)";
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException);
            if (errorCode == 131) {
                return new LockTimeoutException(message, sqlException, sql);
            }
            if (errorCode == 146) {
                return new LockTimeoutException(message, sqlException, sql);
            }
            if (errorCode == 132) {
                return new LockAcquisitionException(message, sqlException, sql);
            }
            if (errorCode == 133) {
                return new LockAcquisitionException(message, sqlException, sql);
            }
            if (errorCode == 257 || errorCode >= 259 && errorCode <= 263) {
                return new SQLGrammarException(message, sqlException, sql);
            }
            if (errorCode == 287 || errorCode == 301 || errorCode == 461 || errorCode == 462) {
                String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                return new ConstraintViolationException(message, sqlException, sql, errorCode == 301 ? ConstraintViolationException.ConstraintKind.UNIQUE : ConstraintViolationException.ConstraintKind.OTHER, constraintName);
            }
            return null;
        };
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    public String getCreateTableString() {
        return this.isDefaultTableTypeColumn() ? "create column table" : "create row table";
    }

    public String getAddColumnString() {
        return "add (";
    }

    public String getAddColumnSuffixString() {
        return ")";
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp from sys.dummy";
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.findGreatestLockMode();
        lockOptions.setLockMode(lockMode);
        if (aliases == null || aliases.isEmpty()) {
            return this.getForUpdateString(lockOptions);
        }
        return this.getForUpdateString(aliases, lockMode, lockOptions.getTimeOut());
    }

    private String getForUpdateString(String aliases, LockMode lockMode, int timeout) {
        return switch (lockMode) {
            case LockMode.PESSIMISTIC_READ -> this.getReadLockString(aliases, timeout);
            case LockMode.PESSIMISTIC_WRITE -> this.getWriteLockString(aliases, timeout);
            case LockMode.UPGRADE_NOWAIT, LockMode.PESSIMISTIC_FORCE_INCREMENT -> this.getForUpdateNowaitString(aliases);
            case LockMode.UPGRADE_SKIPLOCKED -> this.getForUpdateSkipLockedString(aliases);
            default -> "";
        };
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait";
    }

    public String getQuerySequencesString() {
        return "select * from sys.sequences";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorHANADatabaseImpl.INSTANCE;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("all");
        this.registerKeyword("alter");
        this.registerKeyword("as");
        this.registerKeyword("before");
        this.registerKeyword("begin");
        this.registerKeyword("both");
        this.registerKeyword("case");
        this.registerKeyword("char");
        this.registerKeyword("condition");
        this.registerKeyword("connect");
        this.registerKeyword("cross");
        this.registerKeyword("cube");
        this.registerKeyword("current_connection");
        this.registerKeyword("current_date");
        this.registerKeyword("current_schema");
        this.registerKeyword("current_time");
        this.registerKeyword("current_timestamp");
        this.registerKeyword("current_transaction_isolation_level");
        this.registerKeyword("current_user");
        this.registerKeyword("current_utcdate");
        this.registerKeyword("current_utctime");
        this.registerKeyword("current_utctimestamp");
        this.registerKeyword("currval");
        this.registerKeyword("cursor");
        this.registerKeyword("declare");
        this.registerKeyword("deferred");
        this.registerKeyword("distinct");
        this.registerKeyword("else");
        this.registerKeyword("elseif");
        this.registerKeyword("end");
        this.registerKeyword("except");
        this.registerKeyword("exception");
        this.registerKeyword("exec");
        this.registerKeyword("false");
        this.registerKeyword("for");
        this.registerKeyword("from");
        this.registerKeyword("full");
        this.registerKeyword("group");
        this.registerKeyword("having");
        this.registerKeyword("if");
        this.registerKeyword("in");
        this.registerKeyword("inner");
        this.registerKeyword("inout");
        this.registerKeyword("intersect");
        this.registerKeyword("into");
        this.registerKeyword("is");
        this.registerKeyword("join");
        this.registerKeyword("lateral");
        this.registerKeyword("leading");
        this.registerKeyword("left");
        this.registerKeyword("limit");
        this.registerKeyword("loop");
        this.registerKeyword("minus");
        this.registerKeyword("natural");
        this.registerKeyword("nchar");
        this.registerKeyword("nextval");
        this.registerKeyword("null");
        this.registerKeyword("on");
        this.registerKeyword("order");
        this.registerKeyword("out");
        this.registerKeyword("prior");
        this.registerKeyword("return");
        this.registerKeyword("returns");
        this.registerKeyword("reverse");
        this.registerKeyword("right");
        this.registerKeyword("rollup");
        this.registerKeyword("rowid");
        this.registerKeyword("select");
        this.registerKeyword("session_user");
        this.registerKeyword("set");
        this.registerKeyword("sql");
        this.registerKeyword("start");
        this.registerKeyword("sysuuid");
        this.registerKeyword("tablesample");
        this.registerKeyword("top");
        this.registerKeyword("trailing");
        this.registerKeyword("true");
        this.registerKeyword("union");
        this.registerKeyword("unknown");
        this.registerKeyword("using");
        this.registerKeyword("utctimestamp");
        this.registerKeyword("values");
        this.registerKeyword("when");
        this.registerKeyword("where");
        this.registerKeyword("while");
        this.registerKeyword("with");
        if (this.isCloud()) {
            this.registerKeyword("array");
            this.registerKeyword("at");
            this.registerKeyword("authorization");
            this.registerKeyword("between");
            this.registerKeyword("by");
            this.registerKeyword("collate");
            this.registerKeyword("empty");
            this.registerKeyword("filter");
            this.registerKeyword("grouping");
            this.registerKeyword("no");
            this.registerKeyword("not");
            this.registerKeyword("of");
            this.registerKeyword("over");
            this.registerKeyword("recursive");
            this.registerKeyword("row");
            this.registerKeyword("table");
            this.registerKeyword("to");
            this.registerKeyword("unnest");
            this.registerKeyword("window");
            this.registerKeyword("within");
        }
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.FORWARD_ONLY;
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public SequenceSupport getSequenceSupport() {
        return HANASequenceSupport.INSTANCE;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    public boolean dropConstraints() {
        return false;
    }

    public int getMaxAliasLength() {
        return 128;
    }

    public int getMaxIdentifierLength() {
        return 127;
    }

    public LimitHandler getLimitHandler() {
        return LimitOffsetLimitHandler.INSTANCE;
    }

    public String getSelectGUIDString() {
        return "select sysuuid from sys.dummy";
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.UPPER);
        final IdentifierHelper identifierHelper = super.buildIdentifierHelper(builder, dbMetaData);
        return new IdentifierHelper(){
            private final IdentifierHelper helper;
            {
                this.helper = identifierHelper;
            }

            public String toMetaDataSchemaName(Identifier schemaIdentifier) {
                return this.helper.toMetaDataSchemaName(schemaIdentifier);
            }

            public String toMetaDataObjectName(Identifier identifier) {
                return this.helper.toMetaDataObjectName(identifier);
            }

            public String toMetaDataCatalogName(Identifier catalogIdentifier) {
                return this.helper.toMetaDataCatalogName(catalogIdentifier);
            }

            public Identifier toIdentifier(String text) {
                return this.normalizeQuoting(Identifier.toIdentifier((String)text));
            }

            public Identifier toIdentifier(String text, boolean quoted) {
                return this.normalizeQuoting(Identifier.toIdentifier((String)text, (boolean)quoted));
            }

            public Identifier normalizeQuoting(Identifier identifier) {
                Identifier normalizedIdentifier = this.helper.normalizeQuoting(identifier);
                if (normalizedIdentifier == null) {
                    return null;
                }
                if (!normalizedIdentifier.isQuoted() && !normalizedIdentifier.getText().matches("\\w+")) {
                    normalizedIdentifier = Identifier.quote((Identifier)normalizedIdentifier);
                }
                return normalizedIdentifier;
            }

            public boolean isReservedWord(String word) {
                return this.helper.isReservedWord(word);
            }

            public Identifier applyGlobalQuoting(String text) {
                return this.helper.applyGlobalQuoting(text);
            }
        };
    }

    public String getCurrentSchemaCommand() {
        return "select current_schema from sys.dummy";
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases) + " nowait";
    }

    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.getWriteLockString(aliases, timeout);
    }

    public String getWriteLockString(int timeout) {
        if (timeout > 0) {
            return this.getForUpdateString() + " wait " + this.getTimeoutInSeconds(timeout);
        }
        if (timeout == 0) {
            return this.getForUpdateNowaitString();
        }
        return this.getForUpdateString();
    }

    public String getWriteLockString(String aliases, int timeout) {
        if (timeout > 0) {
            return this.getForUpdateString(aliases) + " wait " + this.getTimeoutInSeconds(timeout);
        }
        if (timeout == 0) {
            return this.getForUpdateNowaitString(aliases);
        }
        return this.getForUpdateString(aliases);
    }

    public String getQueryHintString(String query, List<String> hints) {
        return query + " with hint (" + String.join((CharSequence)",", hints) + ")";
    }

    public String getTableComment(String comment) {
        return " comment '" + comment + "'";
    }

    public String getColumnComment(String comment) {
        return " comment '" + comment + "'";
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
        JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
        if (this.treatDoubleTypedFieldsAsDecimal) {
            typeConfiguration.getBasicTypeRegistry().register((BasicType)new BasicTypeImpl((JavaType)DoubleJavaType.INSTANCE, (JdbcType)NumericJdbcType.INSTANCE), Double.class.getName());
            Map jdbcToHibernateTypeContributionMap = typeConfiguration.getJdbcToHibernateTypeContributionMap();
            jdbcToHibernateTypeContributionMap.computeIfAbsent(6, code -> new HashSet()).clear();
            jdbcToHibernateTypeContributionMap.computeIfAbsent(7, code -> new HashSet()).clear();
            jdbcToHibernateTypeContributionMap.computeIfAbsent(8, code -> new HashSet()).clear();
            ((Set)jdbcToHibernateTypeContributionMap.get(6)).add(StandardBasicTypes.BIG_DECIMAL.getName());
            ((Set)jdbcToHibernateTypeContributionMap.get(7)).add(StandardBasicTypes.BIG_DECIMAL.getName());
            ((Set)jdbcToHibernateTypeContributionMap.get(8)).add(StandardBasicTypes.BIG_DECIMAL.getName());
            jdbcTypeRegistry.addDescriptor(6, (JdbcType)NumericJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(7, (JdbcType)NumericJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(8, (JdbcType)NumericJdbcType.INSTANCE);
        }
        jdbcTypeRegistry.addDescriptor(2005, (JdbcType)new HANAClobJdbcType(this.maxLobPrefetchSize, this.useUnicodeStringTypes));
        jdbcTypeRegistry.addDescriptor(2011, (JdbcType)new HANANClobJdbcType(this.maxLobPrefetchSize));
        jdbcTypeRegistry.addDescriptor(2004, (JdbcType)new HANABlobType(this.maxLobPrefetchSize));
        jdbcTypeRegistry.addDescriptor(-6, (JdbcType)TinyIntAsSmallIntJdbcType.INSTANCE);
        if (this.isUseUnicodeStringTypes()) {
            jdbcTypeRegistry.addDescriptor(12, (JdbcType)NVarcharJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(1, (JdbcType)NCharJdbcType.INSTANCE);
        }
        if (this.treatDoubleTypedFieldsAsDecimal) {
            jdbcTypeRegistry.addDescriptor(8, (JdbcType)DecimalJdbcType.INSTANCE);
        }
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.useLegacyBooleanType) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return HANAIdentityColumnSupport.INSTANCE;
    }

    public Exporter<Table> getTableExporter() {
        return this.hanaTableExporter;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        return position;
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        return 0;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(2, 0, 40);
    }

    public boolean supportsNoWait() {
        return true;
    }

    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    public boolean supportsNoColumnsInsert() {
        return false;
    }

    public boolean supportsOrderByInSubquery() {
        return true;
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)false, (boolean)false).result());
    }

    public boolean supportsFractionalTimestampArithmetic() {
        return false;
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 100L;
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                if (temporalType == TemporalType.TIME) {
                    return "cast(add_nano100(cast('1970-01-01 '||(?3) as timestamp),?2/100) as time)";
                }
                return "add_nano100(?3,?2/100)";
            }
            case NATIVE: {
                if (temporalType == TemporalType.TIME) {
                    return "cast(add_nano100(cast('1970-01-01 '||(?3) as timestamp),?2) as time)";
                }
                return "add_nano100(?3,?2)";
            }
            case QUARTER: {
                return "add_months(?3,3*?2)";
            }
            case WEEK: {
                return "add_days(?3,7*?2)";
            }
            case MINUTE: {
                if (temporalType == TemporalType.TIME) {
                    return "cast(add_seconds(cast('1970-01-01 '||(?3) as timestamp),60*?2) as time)";
                }
                return "add_seconds(?3,60*?2)";
            }
            case HOUR: {
                if (temporalType == TemporalType.TIME) {
                    return "cast(add_seconds(cast('1970-01-01 '||(?3) as timestamp),3600*?2) as time)";
                }
                return "add_seconds(?3,3600*?2)";
            }
            case SECOND: {
                if (temporalType != TemporalType.TIME) break;
                return "cast(add_seconds(cast('1970-01-01 '||(?3) as timestamp),?2) as time)";
            }
        }
        return "add_?1s(?3,?2)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: {
                if (fromTemporalType == TemporalType.TIME && toTemporalType == TemporalType.TIME) {
                    return "seconds_between(?2,?3)*1000000000";
                }
                return "nano100_between(?2,?3)*100";
            }
            case NATIVE: {
                if (fromTemporalType == TemporalType.TIME && toTemporalType == TemporalType.TIME) {
                    return "seconds_between(?2,?3)*10000000";
                }
                return "nano100_between(?2,?3)";
            }
            case QUARTER: {
                return "months_between(?2,?3)/3";
            }
            case WEEK: {
                return "days_between(?2,?3)/7";
            }
            case MINUTE: {
                return "seconds_between(?2,?3)/60";
            }
            case HOUR: {
                return "seconds_between(?2,?3)/3600";
            }
        }
        return "?1s_between(?2,?3)";
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Date)date);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    public boolean isUseUnicodeStringTypes() {
        return this.useUnicodeStringTypes || this.isDefaultTableTypeColumn() && this.isCloud();
    }

    protected boolean supportsAsciiStringTypes() {
        return !this.isDefaultTableTypeColumn() || !this.isCloud();
    }

    protected Boolean useUnicodeStringTypesDefault() {
        return this.isDefaultTableTypeColumn() ? this.isCloud() : Boolean.FALSE.booleanValue();
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)entityDescriptor, basename -> "HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)entityDescriptor, name -> "HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    public String getTemporaryTableCreateOptions() {
        return "on commit delete rows";
    }

    public String getTemporaryTableCreateCommand() {
        return "create global temporary row table";
    }

    public String getTemporaryTableTruncateCommand() {
        return "truncate table";
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public boolean supportsSkipLocked() {
        return this.getVersion().isSameOrAfter(2, 0, 30);
    }

    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? this.getForUpdateString() + SQL_IGNORE_LOCKED : this.getForUpdateString();
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? this.getForUpdateString(aliases) + SQL_IGNORE_LOCKED : this.getForUpdateString(aliases);
    }

    public String getForUpdateString(LockMode lockMode) {
        return super.getForUpdateString(lockMode);
    }

    public String getDual() {
        return "sys.dummy";
    }

    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }

    public boolean supportsRowValueConstructorGtLtSyntax() {
        return false;
    }

    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    private static class HANAClobJdbcType
    extends ClobJdbcType {
        private static final long serialVersionUID = -379042275442752102L;
        final int maxLobPrefetchSize;
        final boolean useUnicodeStringTypes;

        public String toString() {
            return "HANAClobTypeDescriptor";
        }

        public HANAClobJdbcType(int maxLobPrefetchSize, boolean useUnicodeStringTypes) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
            this.useUnicodeStringTypes = useUnicodeStringTypes;
        }

        public <X> BasicBinder<X> getClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, (JdbcType)this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = (CharacterStream)javaType.unwrap(value, CharacterStream.class, options);
                    if (value instanceof ClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(index, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                    }
                }

                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = (CharacterStream)javaType.unwrap(value, CharacterStream.class, options);
                    if (value instanceof ClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(name, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                    }
                }
            };
        }

        public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
            return new BasicExtractor<X>(javaType, (JdbcType)this){

                private X doExtract(Clob clob, WrapperOptions options) throws SQLException {
                    Object result;
                    if (clob == null) {
                        result = this.getJavaType().wrap(null, options);
                    } else if (clob.length() < (long)maxLobPrefetchSize) {
                        result = this.getJavaType().wrap((Object)clob, options);
                        clob.free();
                    } else {
                        MaterializedNClob materialized = new MaterializedNClob(DataHelper.extractString((Clob)clob));
                        clob.free();
                        result = this.getJavaType().wrap((Object)materialized, options);
                    }
                    return result;
                }

                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    Clob clob = useUnicodeStringTypes ? rs.getNClob(paramIndex) : rs.getClob(paramIndex);
                    return this.doExtract(clob, options);
                }

                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    Clob clob = useUnicodeStringTypes ? statement.getNClob(index) : statement.getClob(index);
                    return this.doExtract(clob, options);
                }

                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    Clob clob = useUnicodeStringTypes ? statement.getNClob(name) : statement.getClob(name);
                    return this.doExtract(clob, options);
                }
            };
        }

        public int getMaxLobPrefetchSize() {
            return this.maxLobPrefetchSize;
        }

        public boolean isUseUnicodeStringTypes() {
            return this.useUnicodeStringTypes;
        }
    }

    private static class HANANClobJdbcType
    extends NClobJdbcType {
        private static final long serialVersionUID = 5651116091681647859L;
        final int maxLobPrefetchSize;

        public HANANClobJdbcType(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
        }

        public String toString() {
            return "HANANClobTypeDescriptor";
        }

        public <X> BasicBinder<X> getNClobBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, (JdbcType)this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = (CharacterStream)javaType.unwrap(value, CharacterStream.class, options);
                    if (value instanceof NClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(index, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                    }
                }

                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = (CharacterStream)javaType.unwrap(value, CharacterStream.class, options);
                    if (value instanceof NClobImplementer) {
                        try (CloseSuppressingReader r = new CloseSuppressingReader(characterStream.asReader());){
                            st.setCharacterStream(name, (Reader)r, characterStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                    }
                }
            };
        }

        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
            return new BasicExtractor<X>(javaType, (JdbcType)this){

                private X doExtract(NClob nclob, WrapperOptions options) throws SQLException {
                    Object result;
                    if (nclob == null) {
                        result = this.getJavaType().wrap(null, options);
                    } else if (nclob.length() < (long)maxLobPrefetchSize) {
                        result = javaType.wrap((Object)nclob, options);
                        nclob.free();
                    } else {
                        MaterializedNClob materialized = new MaterializedNClob(DataHelper.extractString((Clob)nclob));
                        nclob.free();
                        result = this.getJavaType().wrap((Object)materialized, options);
                    }
                    return result;
                }

                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    return this.doExtract(rs.getNClob(paramIndex), options);
                }

                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return this.doExtract(statement.getNClob(index), options);
                }

                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return this.doExtract(statement.getNClob(name), options);
                }
            };
        }

        public int getMaxLobPrefetchSize() {
            return this.maxLobPrefetchSize;
        }
    }

    public static class HANABlobType
    implements JdbcType {
        private static final long serialVersionUID = 5874441715643764323L;
        public static final JdbcType INSTANCE = new HANABlobType(1024);
        final int maxLobPrefetchSize;
        final HANAStreamBlobType hanaStreamBlobTypeDescriptor;

        public HANABlobType(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
            this.hanaStreamBlobTypeDescriptor = new HANAStreamBlobType(maxLobPrefetchSize);
        }

        public int getJdbcTypeCode() {
            return 2004;
        }

        public String getFriendlyName() {
            return "BLOB (HANA)";
        }

        public String toString() {
            return "HANABlobType";
        }

        public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
            return new BlobExtractor<X>(javaType, this, this.maxLobPrefetchSize);
        }

        public <X> BasicBinder<X> getBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    Object descriptor = BlobJdbcType.BLOB_BINDING;
                    if (value instanceof byte[]) {
                        descriptor = BlobJdbcType.PRIMITIVE_ARRAY_BINDING;
                    } else if (options.useStreamForLobBinding()) {
                        descriptor = hanaStreamBlobTypeDescriptor;
                    }
                    descriptor.getBinder(javaType).bind(st, value, index, options);
                }

                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    Object descriptor = BlobJdbcType.BLOB_BINDING;
                    if (value instanceof byte[]) {
                        descriptor = BlobJdbcType.PRIMITIVE_ARRAY_BINDING;
                    } else if (options.useStreamForLobBinding()) {
                        descriptor = hanaStreamBlobTypeDescriptor;
                    }
                    descriptor.getBinder(javaType).bind(st, value, name, options);
                }
            };
        }

        public int getMaxLobPrefetchSize() {
            return this.maxLobPrefetchSize;
        }
    }

    private static class HANAStreamBlobType
    implements JdbcType {
        private static final long serialVersionUID = -2476600722093442047L;
        final int maxLobPrefetchSize;

        public HANAStreamBlobType(int maxLobPrefetchSize) {
            this.maxLobPrefetchSize = maxLobPrefetchSize;
        }

        public String getFriendlyName() {
            return "BLOB (hana-stream)";
        }

        public String toString() {
            return "HANAStreamBlobType";
        }

        public int getJdbcTypeCode() {
            return 2004;
        }

        public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    BinaryStream binaryStream = (BinaryStream)javaType.unwrap(value, BinaryStream.class, options);
                    if (value instanceof BlobImplementer) {
                        try (CloseSuppressingInputStream is = new CloseSuppressingInputStream(binaryStream.getInputStream());){
                            st.setBinaryStream(index, (InputStream)is, binaryStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setBinaryStream(index, binaryStream.getInputStream(), binaryStream.getLength());
                    }
                }

                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    BinaryStream binaryStream = (BinaryStream)javaType.unwrap(value, BinaryStream.class, options);
                    if (value instanceof BlobImplementer) {
                        try (CloseSuppressingInputStream is = new CloseSuppressingInputStream(binaryStream.getInputStream());){
                            st.setBinaryStream(name, (InputStream)is, binaryStream.getLength());
                        }
                        catch (IOException iOException) {}
                    } else {
                        st.setBinaryStream(name, binaryStream.getInputStream(), binaryStream.getLength());
                    }
                }
            };
        }

        public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
            return new BlobExtractor<X>(javaType, this, this.maxLobPrefetchSize);
        }
    }

    private static class BlobExtractor<X>
    extends BasicExtractor<X> {
        private final int maxLobPrefetchSize;

        public BlobExtractor(JavaType<X> javaType, JdbcType jdbcType, int maxLobPrefetchSize) {
            super(javaType, jdbcType);
            this.maxLobPrefetchSize = maxLobPrefetchSize;
        }

        private X doExtract(Blob blob, WrapperOptions options) throws SQLException {
            Object result;
            if (blob == null) {
                result = this.getJavaType().wrap(null, options);
            } else if (blob.length() < (long)this.maxLobPrefetchSize) {
                result = this.getJavaType().wrap((Object)blob, options);
                blob.free();
            } else {
                MaterializedBlob materialized = new MaterializedBlob(DataHelper.extractBytes((InputStream)blob.getBinaryStream()));
                blob.free();
                result = this.getJavaType().wrap((Object)materialized, options);
            }
            return (X)result;
        }

        protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
            return this.doExtract(rs.getBlob(paramIndex), options);
        }

        protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
            return this.doExtract(statement.getBlob(index), options);
        }

        protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
            return this.doExtract(statement.getBlob(name), options);
        }
    }

    private static class MaterializedNClob
    implements NClob {
        private String data;

        public MaterializedNClob(String data) {
            this.data = data;
        }

        @Override
        public void truncate(long len) throws SQLException {
            this.data = "";
        }

        @Override
        public int setString(long pos, String str, int offset, int len) throws SQLException {
            this.data = this.data.substring(0, (int)(pos - 1L)) + str.substring(offset, offset + len) + this.data.substring((int)(pos - 1L + (long)len));
            return len;
        }

        @Override
        public int setString(long pos, String str) throws SQLException {
            this.data = this.data.substring(0, (int)(pos - 1L)) + str + this.data.substring((int)(pos - 1L + (long)str.length()));
            return str.length();
        }

        @Override
        public Writer setCharacterStream(long pos) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public OutputStream setAsciiStream(long pos) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public long position(Clob searchstr, long start) throws SQLException {
            return this.data.indexOf(DataHelper.extractString((Clob)searchstr), (int)(start - 1L));
        }

        @Override
        public long position(String searchstr, long start) throws SQLException {
            return this.data.indexOf(searchstr, (int)(start - 1L));
        }

        @Override
        public long length() throws SQLException {
            return this.data.length();
        }

        @Override
        public String getSubString(long pos, int length) throws SQLException {
            return this.data.substring((int)(pos - 1L), (int)(pos - 1L + (long)length));
        }

        @Override
        public Reader getCharacterStream(long pos, long length) throws SQLException {
            return new StringReader(this.data.substring((int)(pos - 1L), (int)(pos - 1L + length)));
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            return new StringReader(this.data);
        }

        @Override
        public InputStream getAsciiStream() {
            return new ByteArrayInputStream(this.data.getBytes(StandardCharsets.ISO_8859_1));
        }

        @Override
        public void free() throws SQLException {
            this.data = null;
        }
    }

    private static class MaterializedBlob
    implements Blob {
        private byte[] bytes = null;

        public MaterializedBlob(byte[] bytes) {
            this.setBytes(bytes);
        }

        @Override
        public long length() throws SQLException {
            return this.getBytes().length;
        }

        @Override
        public byte[] getBytes(long pos, int length) throws SQLException {
            return Arrays.copyOfRange(this.bytes, (int)(pos - 1L), (int)(pos - 1L + (long)length));
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            return new ByteArrayInputStream(this.getBytes());
        }

        @Override
        public long position(byte[] pattern, long start) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public int setBytes(long pos, byte[] bytes) throws SQLException {
            int bytesSet = 0;
            if ((long)this.bytes.length < pos - 1L + (long)bytes.length) {
                this.bytes = Arrays.copyOf(this.bytes, (int)(pos - 1L + (long)bytes.length));
            }
            int i = 0;
            while (i < bytes.length && i < this.bytes.length) {
                this.bytes[(int)((long)i + pos - 1L)] = bytes[i];
                ++i;
                ++bytesSet;
            }
            return bytesSet;
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            int bytesSet = 0;
            if ((long)this.bytes.length < pos - 1L + (long)len) {
                this.bytes = Arrays.copyOf(this.bytes, (int)(pos - 1L + (long)len));
            }
            int i = offset;
            while (i < len && i < this.bytes.length) {
                this.bytes[(int)((long)i + pos - 1L)] = bytes[i];
                ++i;
                ++bytesSet;
            }
            return bytesSet;
        }

        @Override
        public OutputStream setBinaryStream(long pos) {
            return new ByteArrayOutputStream(){
                {
                    this.buf = this.getBytes();
                }
            };
        }

        @Override
        public void truncate(long len) throws SQLException {
            this.setBytes(Arrays.copyOf(this.getBytes(), (int)len));
        }

        @Override
        public void free() throws SQLException {
            this.setBytes(null);
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            return new ByteArrayInputStream(this.getBytes(), (int)(pos - 1L), (int)length);
        }

        byte[] getBytes() {
            return this.bytes;
        }

        void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    private static class CloseSuppressingInputStream
    extends FilterInputStream {
        protected CloseSuppressingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }

    private static class CloseSuppressingReader
    extends FilterReader {
        protected CloseSuppressingReader(Reader in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

