/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.H2LegacySqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.H2AggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.H2FinalTableIdentityColumnSupport;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.H2V1SequenceSupport;
import org.hibernate.dialect.sequence.H2V2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.type.H2DurationIntervalSecondJdbcType;
import org.hibernate.dialect.type.H2JsonArrayJdbcTypeConstructor;
import org.hibernate.dialect.type.H2JsonJdbcType;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorH2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.EnumJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.OrdinalEnumJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeAsTimestampWithTimeZoneJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeUtcAsJdbcTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeUtcAsOffsetTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsInstantJdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class H2LegacyDialect
extends Dialect {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(H2LegacyDialect.class);
    private final LimitHandler limitHandler;
    private final boolean ansiSequence;
    private final boolean cascadeConstraints;
    private final boolean useLocalTime;
    private final SequenceInformationExtractor sequenceInformationExtractor;
    private final String querySequenceString;
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate((Dialect)this);
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String message;
        int idx;
        if (sqle.getSQLState().startsWith("23") && (idx = (message = sqle.getMessage()).indexOf("violation: ")) > 0) {
            String constraintName = message.substring(idx + "violation: ".length());
            if (sqle.getSQLState().equals("23506")) {
                constraintName = constraintName.substring(1, constraintName.indexOf(58));
            }
            return constraintName;
        }
        return null;
    });

    public H2LegacyDialect(DialectResolutionInfo info) {
        this(H2LegacyDialect.parseVersion(info));
        this.registerKeywords(info);
    }

    public H2LegacyDialect() {
        this((DatabaseVersion)SimpleDatabaseVersion.ZERO_VERSION);
    }

    public H2LegacyDialect(DatabaseVersion version) {
        super(version);
        Object object = this.limitHandler = version.isSameOrAfter(1, 4, 195) ? OffsetFetchLimitHandler.INSTANCE : LimitOffsetLimitHandler.OFFSET_ONLY_INSTANCE;
        if (version.isBefore(1, 2, 139)) {
            LOG.unsupportedMultiTableBulkHqlJpaql(version.getMajor(), version.getMinor(), version.getMicro());
        }
        this.ansiSequence = version.isSameOrAfter(1, 4, 200);
        this.cascadeConstraints = version.isSameOrAfter(1, 4, 200);
        this.useLocalTime = version.isSameOrAfter(1, 4, 200);
        if (version.isSameOrAfter(1, 4, 32)) {
            this.sequenceInformationExtractor = version.isSameOrAfter(1, 4, 201) ? SequenceInformationExtractorLegacyImpl.INSTANCE : SequenceInformationExtractorH2DatabaseImpl.INSTANCE;
            this.querySequenceString = "select * from INFORMATION_SCHEMA.SEQUENCES";
        } else {
            this.sequenceInformationExtractor = SequenceInformationExtractorNoOpImpl.INSTANCE;
            this.querySequenceString = null;
        }
    }

    private static DatabaseVersion parseVersion(DialectResolutionInfo info) {
        return DatabaseVersion.make((Integer)info.getMajor(), (Integer)info.getMinor(), (Integer)H2LegacyDialect.parseBuildId(info));
    }

    private static int parseBuildId(DialectResolutionInfo info) {
        String databaseVersion = info.getDatabaseVersion();
        if (databaseVersion == null) {
            return 0;
        }
        String[] bits = StringHelper.split((String)". ", (String)databaseVersion);
        return bits.length > 2 ? Integer.parseInt(bits[2]) : 0;
    }

    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    public boolean supportsStandardArrays() {
        return this.getVersion().isSameOrAfter(2);
    }

    public boolean useArrayForMultiValuedParameters() {
        return false;
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 2: {
                return this.getVersion().isBefore(2) ? this.columnType(3) : super.columnType(sqlTypeCode);
            }
            case 2013: {
                return this.getVersion().isBefore(2) ? this.columnType(2014) : super.columnType(sqlTypeCode);
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case 1: {
                return "char";
            }
            case -9: 
            case 12: 
            case 4001: 
            case 4002: {
                return "varchar";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "varbinary";
            }
        }
        return super.castType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        if (this.getVersion().isBefore(2)) {
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2003, "array", (Dialect)this));
        }
        if (this.getVersion().isSameOrAfter(1, 4, 197)) {
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3000, "uuid", (Dialect)this));
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3200, "geometry", (Dialect)this));
            if (this.getVersion().isSameOrAfter(1, 4, 198)) {
                ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3100, "interval second($p,$s)", (Dialect)this));
            }
            if (this.getVersion().isSameOrAfter(1, 4, 200)) {
                ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3001, "json", (Dialect)this));
            }
        }
        ddlTypeRegistry.addDescriptor((DdlType)new NativeEnumDdlTypeImpl((Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new NativeOrdinalEnumDdlTypeImpl((Dialect)this));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.getVersion().isBefore(2)) {
            jdbcTypeRegistry.addDescriptor((JdbcType)TimeAsTimestampWithTimeZoneJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor((JdbcType)TimeUtcAsJdbcTimeJdbcType.INSTANCE);
        } else {
            jdbcTypeRegistry.addDescriptor((JdbcType)TimeUtcAsOffsetTimeJdbcType.INSTANCE);
        }
        jdbcTypeRegistry.addDescriptor(3003, (JdbcType)TimestampUtcAsInstantJdbcType.INSTANCE);
        if (this.getVersion().isSameOrAfter(1, 4, 197)) {
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)UUIDJdbcType.INSTANCE);
        }
        if (this.getVersion().isSameOrAfter(1, 4, 198)) {
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)H2DurationIntervalSecondJdbcType.INSTANCE);
        }
        if (this.getVersion().isSameOrAfter(1, 4, 200)) {
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)H2JsonJdbcType.INSTANCE);
            jdbcTypeRegistry.addTypeConstructor((JdbcTypeConstructor)H2JsonArrayJdbcTypeConstructor.INSTANCE);
        }
        jdbcTypeRegistry.addDescriptor((JdbcType)EnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor((JdbcType)OrdinalEnumJdbcType.INSTANCE);
    }

    public AggregateSupport getAggregateSupport() {
        return H2AggregateSupport.valueOf((Dialect)this);
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public boolean hasOddDstBehavior() {
        return this.getVersion().isSameOrAfter(1, 4, 200);
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates((Dialect)this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.avg_castingNonDoubleArguments((Dialect)this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.pi();
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.mod_operator();
        functionFactory.rand();
        functionFactory.soundex();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.bitAndOr();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayOfWeekMonthYear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        if (this.useLocalTime) {
            functionFactory.localtimeLocaltimestamp();
        }
        functionFactory.trunc_dateTrunc();
        functionFactory.dateTrunc();
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.octetLength();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.chr_char();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.trim1();
        functionFactory.concat_pipeOperator();
        functionFactory.nowCurdateCurtime();
        functionFactory.sysdate();
        functionFactory.insert();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        if (this.getVersion().isSame(1, 4, 200)) {
            functionFactory.format_toChar();
        } else {
            functionFactory.format_formatdatetime();
        }
        functionFactory.rownum();
        if (this.getVersion().isSameOrAfter(1, 4, 200)) {
            functionFactory.windowFunctions();
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.hypotheticalOrderedSetAggregates();
            if (this.getVersion().isSameOrAfter(2)) {
                functionFactory.listagg(null);
                functionFactory.array();
                functionFactory.arrayAggregate();
                functionFactory.arrayPosition_h2(this.getMaximumArraySize());
                functionFactory.arrayPositions_h2(this.getMaximumArraySize());
                functionFactory.arrayLength_cardinality();
                functionFactory.arrayConcat_operator();
                functionFactory.arrayPrepend_operator();
                functionFactory.arrayAppend_operator();
                functionFactory.arrayContains_h2(this.getMaximumArraySize());
                functionFactory.arrayIntersects_h2(this.getMaximumArraySize());
                functionFactory.arrayGet_h2();
                functionFactory.arraySet_h2(this.getMaximumArraySize());
                functionFactory.arrayRemove_h2(this.getMaximumArraySize());
                functionFactory.arrayRemoveIndex_h2(this.getMaximumArraySize());
                functionFactory.arraySlice();
                functionFactory.arrayReplace_h2(this.getMaximumArraySize());
                functionFactory.arrayTrim_trim_array();
                functionFactory.arrayFill_h2();
                functionFactory.arrayToString_h2(this.getMaximumArraySize());
                if (this.getVersion().isSameOrAfter(2, 2, 220)) {
                    functionFactory.jsonValue_h2();
                    functionFactory.jsonQuery_h2();
                    functionFactory.jsonExists_h2();
                    functionFactory.jsonArrayAgg_h2();
                    functionFactory.jsonObjectAgg_h2();
                }
            } else {
                functionFactory.jsonObject();
                functionFactory.jsonArray();
                functionFactory.listagg_groupConcat();
            }
            functionFactory.xmlelement_h2();
            functionFactory.xmlcomment();
            functionFactory.xmlforest_h2();
            functionFactory.xmlconcat_h2();
            functionFactory.xmlpi_h2();
        } else {
            functionFactory.listagg_groupConcat();
        }
        functionFactory.unnest_h2(this.getMaximumArraySize());
        functionFactory.generateSeries_h2(this.getMaximumSeriesSize());
        functionFactory.jsonTable_h2(this.getMaximumArraySize());
    }

    protected int getMaximumArraySize() {
        return 1000;
    }

    protected int getMaximumSeriesSize() {
        return 10000;
    }

    public @Nullable String getDefaultOrdinalityColumnName() {
        return "nord";
    }

    public void augmentPhysicalTableTypes(List<String> tableTypesList) {
        if (this.getVersion().isSameOrAfter(2)) {
            tableTypesList.add("BASE TABLE");
        }
    }

    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        switch (columnTypeName) {
            case "FLOAT(24)": {
                return 7;
            }
        }
        return super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 6: {
                if (!"DOUBLE PRECISION".equals(columnTypeName)) break;
                return jdbcTypeRegistry.getDescriptor(8);
            }
            case 1111: {
                if ("GEOMETRY".equals(columnTypeName)) {
                    return jdbcTypeRegistry.getDescriptor(3200);
                }
                if (!"JSON".equals(columnTypeName)) break;
                return jdbcTypeRegistry.getDescriptor(3001);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    protected Integer resolveSqlTypeCode(String typeName, String baseTypeName, TypeConfiguration typeConfiguration) {
        switch (baseTypeName) {
            case "CHARACTER VARYING": {
                return 12;
            }
        }
        return super.resolveSqlTypeCode(typeName, baseTypeName, typeConfiguration);
    }

    public int getMaxVarcharLength() {
        return 0x100000;
    }

    public String currentTime() {
        return this.useLocalTime ? "localtime" : super.currentTime();
    }

    public String currentTimestamp() {
        return this.useLocalTime ? "localtimestamp" : super.currentTimestamp();
    }

    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new H2LegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String extractPattern(TemporalUnit unit) {
        return unit == TemporalUnit.SECOND ? "(" + super.extractPattern(unit) + "+extract(nanosecond from ?2)/1e9)" : super.extractPattern(unit);
    }

    public String castPattern(CastType from, CastType to) {
        if (from == CastType.STRING && to == CastType.BOOLEAN) {
            return "cast(?1 as ?2)";
        }
        return super.castPattern(from, to);
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        return "dateadd(?1,?2,?3)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        return "datediff(?1,?2,?3)";
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithNanos((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)false, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Date)date);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithNanos((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Calendar)calendar);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean supportsTimeLiteralOffset() {
        return this.getVersion().isSameOrAfter(1, 4, 200);
    }

    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    public boolean supportsIfExistsAfterTableName() {
        return !this.supportsIfExistsBeforeTableName();
    }

    public boolean supportsIfExistsBeforeTableName() {
        return this.cascadeConstraints;
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return this.cascadeConstraints;
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return this.cascadeConstraints ? " cascade " : super.getCascadeConstraintsString();
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean dropConstraints() {
        return false;
    }

    public SequenceSupport getSequenceSupport() {
        return this.ansiSequence ? H2V2SequenceSupport.INSTANCE : H2V1SequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.sequenceInformationExtractor;
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)entityDescriptor, basename -> "HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)entityDescriptor, name -> "HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException);
            switch (errorCode) {
                case 23505: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, constraintName);
                }
                case 40001: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 50200: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 90006: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                case 57014: {
                    return new QueryTimeoutException(message, sqlException, sql);
                }
            }
            return null;
        };
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean supportsTupleCounts() {
        return true;
    }

    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.ALIAS;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(1, 4, 200);
    }

    public boolean supportsRecursiveCTE() {
        return this.getVersion().isSameOrAfter(1, 4, 196);
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return this.getVersion().isSameOrAfter(1, 4, 198);
    }

    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_GROUP_AND_CONSTANTS;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion().isSameOrAfter(2) ? H2FinalTableIdentityColumnSupport.INSTANCE : H2IdentityColumnSupport.INSTANCE;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        return position;
    }

    public String getQueryHintString(String query, String hints) {
        return H2LegacyDialect.addUseIndexQueryHint((String)query, (String)hints);
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        if (this.getVersion().isSame(1, 4, 200)) {
            appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)true, (boolean)true).result());
        } else {
            appender.appendSql(new Replacer(format, "'", "''").replace("e", "u").replace("xxx", "XXX").replace("xx", "XX").replace("x", "X").result());
        }
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case WEEK: {
                return "iso_week";
            }
        }
        return unit.toString();
    }

    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    public boolean canDisableConstraints() {
        return true;
    }

    public String getEnableConstraintsStatement() {
        return "set referential_integrity true";
    }

    public String getEnumTypeDeclaration(String name, String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        return type.append(')').toString();
    }

    public String getDisableConstraintsStatement() {
        return "set referential_integrity false";
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public String rowId(String rowId) {
        return "_rowid_";
    }

    public int rowIdSqlType() {
        return -5;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public String getCaseInsensitiveLike() {
        if (this.getVersion().isSameOrAfter(1, 4, 194)) {
            return "ilike";
        }
        return super.getCaseInsensitiveLike();
    }

    public boolean supportsCaseInsensitiveLike() {
        return this.getVersion().isSameOrAfter(1, 4, 194);
    }

    public boolean supportsValuesList() {
        return true;
    }

    public String getDual() {
        return "dual";
    }

    public boolean supportsFilterClause() {
        return this.getVersion().isSameOrAfter(1, 4, 197);
    }

    public boolean supportsRowConstructor() {
        return this.getVersion().isSameOrAfter(2);
    }

    public boolean supportsArrayConstructor() {
        return this.getVersion().isSameOrAfter(2);
    }

    public boolean supportsJoinInMutationStatementSubquery() {
        return false;
    }

    public boolean supportsNullPrecedence() {
        return this.getVersion().isSameOrAfter(2);
    }

    public boolean supportsRowValueConstructorSyntax() {
        return this.getVersion().isSameOrAfter(1, 4, 197);
    }

    public boolean supportsRowValueConstructorDistinctFromSyntax() {
        return this.getVersion().isSameOrAfter(1, 4, 200);
    }

    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return this.getVersion().isSameOrAfter(1, 4, 197);
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getVersion().isSameOrAfter(1, 4, 197);
    }
}

