/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.DB2LegacySqlAstTranslator;
import org.hibernate.community.dialect.sequence.LegacyDB2SequenceSupport;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2GetObjectExtractor;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.DB2AggregateSupport;
import org.hibernate.dialect.function.CastingConcatFunction;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.DB2FormatEmulation;
import org.hibernate.dialect.function.DB2PositionFunction;
import org.hibernate.dialect.function.DB2SubstringFunction;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.DB2LimitHandler;
import org.hibernate.dialect.pagination.LegacyDB2LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.type.DB2StructJdbcType;
import org.hibernate.dialect.unique.AlterTableUniqueIndexDelegate;
import org.hibernate.dialect.unique.SkipNullableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.DB2CallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDB2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.CharJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.InstantJdbcType;
import org.hibernate.type.descriptor.jdbc.JavaTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.LocalDateJdbcType;
import org.hibernate.type.descriptor.jdbc.LocalDateTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.LocalTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullResolvingJdbcType;
import org.hibernate.type.descriptor.jdbc.OffsetDateTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.OffsetTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.ZonedDateTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2LegacyDialect
extends Dialect {
    private static final int BIND_PARAMETERS_NUMBER_LIMIT = Short.MAX_VALUE;
    private static final String FOR_READ_ONLY_SQL = " for read only with rs";
    private static final String FOR_SHARE_SQL = " for read only with rs use and keep share locks";
    private static final String FOR_UPDATE_SQL = " for read only with rs use and keep update locks";
    private static final String SKIP_LOCKED_SQL = " skip locked data";
    private static final String FOR_SHARE_SKIP_LOCKED_SQL = " for read only with rs use and keep share locks skip locked data";
    private static final String FOR_UPDATE_SKIP_LOCKED_SQL = " for read only with rs use and keep update locks skip locked data";
    private final LimitHandler limitHandler = this.getDB2Version().isBefore(11, 1) ? LegacyDB2LimitHandler.INSTANCE : DB2LimitHandler.INSTANCE;
    private final UniqueDelegate uniqueDelegate = this.createUniqueDelegate();
    private final StandardTableExporter db2TableExporter = new StandardTableExporter(this){

        protected void applyAggregateColumnCheck(StringBuilder buf, AggregateColumn aggregateColumn) {
            JdbcType jdbcType = aggregateColumn.getType().getJdbcType();
            if (jdbcType.isLob() || jdbcType.isXml()) {
                return;
            }
            super.applyAggregateColumnCheck(buf, aggregateColumn);
        }
    };

    public DB2LegacyDialect() {
        this(DatabaseVersion.make((Integer)9, (Integer)0));
    }

    public DB2LegacyDialect(DialectResolutionInfo info) {
        super(info);
    }

    public DB2LegacyDialect(DatabaseVersion version) {
        super(version);
    }

    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("current");
        this.registerKeyword("date");
        this.registerKeyword("time");
        this.registerKeyword("timestamp");
        this.registerKeyword("fetch");
        this.registerKeyword("first");
        this.registerKeyword("rows");
        this.registerKeyword("only");
    }

    public DatabaseVersion getDB2Version() {
        return this.getVersion();
    }

    public Exporter<Table> getTableExporter() {
        return this.db2TableExporter;
    }

    public int getDefaultStatementBatchSize() {
        return 0;
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getDB2Version().isBefore(11) ? 5 : 16;
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return this.getDB2Version().isBefore(11) ? "smallint" : super.columnType(sqlTypeCode);
            }
            case -6: {
                return "smallint";
            }
            case 2: {
                return this.columnType(3);
            }
            case 2004: {
                return "blob";
            }
            case 2005: {
                return "clob";
            }
            case 2014: {
                return "timestamp($p)";
            }
            case 92: 
            case 2013: {
                return "time";
            }
            case -2: {
                return this.getDB2Version().isBefore(11) ? "char($l) for bit data" : super.columnType(sqlTypeCode);
            }
            case -3: {
                return this.getDB2Version().isBefore(11) ? "varchar($l) for bit data" : super.columnType(sqlTypeCode);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2009, "xml", (Dialect)this));
        if (this.getDB2Version().isBefore(11)) {
            ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-2, (String)this.columnType(-3), (Dialect)this).withTypeCapacity(254L, this.columnType(-2)).build());
        }
    }

    protected UniqueDelegate createUniqueDelegate() {
        return this.getDB2Version().isSameOrAfter(10, 5) ? new AlterTableUniqueIndexDelegate((Dialect)this) : new SkipNullableUniqueDelegate((Dialect)this);
    }

    public int getMaxVarcharLength() {
        return 32672;
    }

    public int getDefaultDecimalPrecision() {
        return 31;
    }

    protected boolean supportsPredicateAsExpression() {
        return this.getDB2Version().isSameOrAfter(11);
    }

    public boolean supportsDistinctFromPredicate() {
        return this.getDB2Version().isSameOrAfter(11, 1);
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        DdlTypeRegistry ddlTypeRegistry = functionContributions.getTypeConfiguration().getDdlTypeRegistry();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.avg_castingNonDoubleArguments((Dialect)this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.cot();
        functionFactory.sinh();
        functionFactory.cosh();
        functionFactory.tanh();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.radians();
        functionFactory.rand();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.repeat();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("substr").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).setArgumentCountBetween(2, 3).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER}).setArgumentListSignature("(STRING string, INTEGER start[, INTEGER length])").register();
        functionContributions.getFunctionRegistry().register("substring", (SqmFunctionDescriptor)new DB2SubstringFunction(functionContributions.getTypeConfiguration()));
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.dateTimeTimestamp();
        functionFactory.concat_pipeOperator();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.insert();
        functionFactory.characterLength_length(SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.stddev();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.variance();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        if (this.getDB2Version().isSameOrAfter(11)) {
            functionFactory.position();
            functionFactory.overlayLength_overlay(false);
            functionFactory.median();
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.stddevPopSamp();
            functionFactory.varPopSamp();
            functionFactory.varianceSamp();
            functionFactory.dateTrunc();
            functionFactory.trunc_dateTrunc();
        } else {
            functionContributions.getFunctionRegistry().register("position", (SqmFunctionDescriptor)new DB2PositionFunction(functionContributions.getTypeConfiguration()));
            functionFactory.overlayLength_overlay(true);
            functionContributions.getFunctionRegistry().registerAlternateKey("stddev_pop", "stddev");
            functionFactory.stddevSamp_sumCount();
            functionContributions.getFunctionRegistry().registerAlternateKey("var_pop", "variance");
            functionFactory.varSamp_sumCount();
            functionFactory.trunc_dateTrunc_trunc();
        }
        functionFactory.addYearsMonthsDaysHoursMinutesSeconds();
        functionFactory.yearsMonthsDaysHoursMinutesSecondsBetween();
        functionFactory.bitLength_pattern("length(?1)*8");
        functionContributions.getFunctionRegistry().register("concat", (SqmFunctionDescriptor)new CastingConcatFunction((Dialect)this, "||", true, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("count", (SqmFunctionDescriptor)new CountFunction((Dialect)this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "||", ddlTypeRegistry.getDescriptor(12).getCastTypeName(Size.nil(), (SqlExpressible)functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING), ddlTypeRegistry), true));
        functionContributions.getFunctionRegistry().register("format", (SqmFunctionDescriptor)new DB2FormatEmulation(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("atan2", "atan2(?2,?1)").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC}).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("posstr").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER)).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.STRING, FunctionParameterType.STRING}).setArgumentListSignature("(STRING string, STRING pattern)").register();
        functionContributions.getFunctionRegistry().register("trim", (SqmFunctionDescriptor)new TrimFunction((Dialect)this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.INLINE_PARAMETERS));
        functionFactory.windowFunctions();
        if (this.getDB2Version().isSameOrAfter(9, 5)) {
            functionFactory.listagg(null);
            if (this.getDB2Version().isSameOrAfter(11)) {
                functionFactory.jsonValue_db2();
                functionFactory.jsonQuery_no_passing();
                functionFactory.jsonExists_no_passing();
                functionFactory.jsonObject_db2();
                functionFactory.jsonArray_db2();
                functionFactory.jsonArrayAgg_db2();
                functionFactory.jsonObjectAgg_db2();
                functionFactory.jsonTable_db2(this.getMaximumSeriesSize());
            }
        }
        functionFactory.xmlelement();
        functionFactory.xmlcomment();
        functionFactory.xmlforest();
        functionFactory.xmlconcat();
        functionFactory.xmlpi();
        if (this.getDB2Version().isSameOrAfter(11)) {
            functionFactory.xmlquery_db2();
            functionFactory.xmlexists();
        } else {
            functionFactory.xmlquery_db2_legacy();
            functionFactory.xmlexists_db2_legacy();
        }
        functionFactory.xmlagg();
        functionFactory.xmltable_db2();
        functionFactory.unnest_db2(this.getMaximumSeriesSize());
        if (this.supportsRecursiveCTE()) {
            functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), false, true);
        }
    }

    protected int getMaximumSeriesSize() {
        return 10000;
    }

    public int getPreferredSqlTypeCodeForArray() {
        return 3019;
    }

    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName + " restrict"};
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        String toExpression;
        String fromExpression;
        if (this.getDB2Version().isBefore(11)) {
            return DB2Dialect.timestampdiffPatternV10((TemporalUnit)unit, (TemporalType)fromTemporalType, (TemporalType)toTemporalType);
        }
        StringBuilder pattern = new StringBuilder();
        if (unit.isDateUnit()) {
            fromExpression = "?2";
            toExpression = "?3";
        } else {
            switch (fromTemporalType) {
                case DATE: {
                    fromExpression = "cast(?2 as timestamp)";
                    break;
                }
                case TIME: {
                    fromExpression = "timestamp('1970-01-01',?2)";
                    break;
                }
                default: {
                    fromExpression = "?2";
                }
            }
            switch (toTemporalType) {
                case DATE: {
                    toExpression = "cast(?3 as timestamp)";
                    break;
                }
                case TIME: {
                    toExpression = "timestamp('1970-01-01',?3)";
                    break;
                }
                default: {
                    toExpression = "?3";
                }
            }
        }
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("(seconds_between(");
                break;
            }
            case MONTH: 
            case QUARTER: {
                pattern.append("trunc(months_between(");
                break;
            }
            default: {
                pattern.append("?1s_between(");
            }
        }
        pattern.append(toExpression);
        pattern.append(',');
        pattern.append(fromExpression);
        pattern.append(')');
        switch (unit) {
            case NATIVE: {
                pattern.append("+(microsecond(");
                pattern.append(toExpression);
                pattern.append(")-microsecond(");
                pattern.append(fromExpression);
                pattern.append("))/1e6)");
                break;
            }
            case NANOSECOND: {
                pattern.append("*1e9+(microsecond(");
                pattern.append(toExpression);
                pattern.append(")-microsecond(");
                pattern.append(fromExpression);
                pattern.append("))*1e3)");
                break;
            }
            case MONTH: {
                pattern.append(')');
                break;
            }
            case QUARTER: {
                pattern.append("/3)");
            }
        }
        return pattern.toString();
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        String timestampExpression = unit.isDateUnit() ? (temporalType == TemporalType.TIME ? "timestamp('1970-01-01',?3)" : "?3") : (temporalType == TemporalType.DATE ? "cast(?3 as timestamp)" : "?3");
        pattern.append(timestampExpression);
        pattern.append("+(");
        switch (unit) {
            case NATIVE: {
                pattern.append("?2) seconds");
                break;
            }
            case NANOSECOND: {
                pattern.append("(?2)/1e9) seconds");
                break;
            }
            case WEEK: {
                pattern.append("(?2)*7) days");
                break;
            }
            case QUARTER: {
                pattern.append("(?2)*3) months");
                break;
            }
            default: {
                pattern.append("?2) ?1s");
            }
        }
        return pattern.toString();
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)false, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String getLowercaseFunction() {
        return this.getDB2Version().isBefore(9, 7) ? "lcase" : super.getLowercaseFunction();
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return unique ? " exclude null keys" : "";
    }

    public SequenceSupport getSequenceSupport() {
        return this.getDB2Version().isBefore(9, 7) ? LegacyDB2SequenceSupport.INSTANCE : DB2SequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select * from syscat.sequences";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        if (this.getQuerySequencesString() == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE;
        }
        return SequenceInformationExtractorDB2DatabaseImpl.INSTANCE;
    }

    public String getForUpdateString() {
        return FOR_UPDATE_SQL;
    }

    public boolean supportsSkipLocked() {
        return this.getDB2Version().isSameOrAfter(11, 5);
    }

    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateSkipLockedString();
    }

    public String getWriteLockString(int timeout) {
        return timeout == -2 && this.supportsSkipLocked() ? FOR_UPDATE_SKIP_LOCKED_SQL : FOR_UPDATE_SQL;
    }

    public String getReadLockString(int timeout) {
        return timeout == -2 && this.supportsSkipLocked() ? FOR_SHARE_SKIP_LOCKED_SQL : FOR_SHARE_SQL;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public boolean supportsLockTimeouts() {
        return false;
    }

    public boolean requiresCastForConcatenatingNonStrings() {
        return true;
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return DB2LegacyDialect.selectNullString(sqlType);
    }

    static String selectNullString(int sqlType) {
        String literal = switch (sqlType) {
            case 1, 12 -> "''";
            case 91 -> "'2000-1-1'";
            case 92 -> "'00:00:00'";
            case 93, 2014 -> "'2000-1-1 00:00:00'";
            default -> "0";
        };
        return "nullif(" + literal + "," + literal + ")";
    }

    public Boolean supportsRefCursors() {
        return false;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 2012);
        return col;
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        statement.registerOutParameter(name, 2012);
        return 1;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        return (ResultSet)statement.getObject(position);
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        return (ResultSet)statement.getObject(name);
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.getDB2Version().isBefore(11)) {
            jdbcTypeRegistry.addDescriptor(16, (JdbcType)SmallIntJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(-3, (JdbcType)VarbinaryJdbcType.INSTANCE_WITHOUT_LITERALS);
        }
        jdbcTypeRegistry.addDescriptor(-15, (JdbcType)CharJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2011, (JdbcType)ClobJdbcType.STREAM_BINDING);
        jdbcTypeRegistry.addDescriptor(-9, (JdbcType)VarcharJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor((JdbcType)XmlJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor((JdbcType)DB2StructJdbcType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE);
        typeContributions.contributeType((BasicType)new JavaObjectType((JdbcType)ObjectNullResolvingJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
        typeContributions.contributeJdbcType((JdbcType)new InstantJdbcType(){

            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor(javaType, (JavaTimeJdbcType)this, Instant.class);
            }
        });
        typeContributions.contributeJdbcType((JdbcType)new LocalDateTimeJdbcType(){

            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor(javaType, (JavaTimeJdbcType)this, LocalDateTime.class);
            }
        });
        typeContributions.contributeJdbcType((JdbcType)new LocalDateJdbcType(){

            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor(javaType, (JavaTimeJdbcType)this, LocalDate.class);
            }
        });
        typeContributions.contributeJdbcType((JdbcType)new LocalTimeJdbcType(){

            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor(javaType, (JavaTimeJdbcType)this, LocalTime.class);
            }
        });
        typeContributions.contributeJdbcType((JdbcType)new OffsetDateTimeJdbcType(){

            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor(javaType, (JavaTimeJdbcType)this, OffsetDateTime.class);
            }
        });
        typeContributions.contributeJdbcType((JdbcType)new OffsetTimeJdbcType(){

            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor(javaType, (JavaTimeJdbcType)this, OffsetTime.class);
            }
        });
        typeContributions.contributeJdbcType((JdbcType)new ZonedDateTimeJdbcType(){

            public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
                return new DB2GetObjectExtractor(javaType, (JavaTimeJdbcType)this, ZonedDateTime.class);
            }
        });
    }

    public AggregateSupport getAggregateSupport() {
        return this.getDB2Version().isSameOrAfter(11) ? DB2AggregateSupport.JSON_INSTANCE : DB2AggregateSupport.INSTANCE;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return DB2CallableStatementSupport.INSTANCE;
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        if (this.getDB2Version().isSameOrAfter(11)) {
            appender.appendSql("BX'");
        } else {
            appender.appendSql("X'");
        }
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return new TemplatedViolatedConstraintNameExtractor(sqle -> {
            switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqle)) {
                case -803: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"SQLERRMC=1;", (String)",", (String)sqle.getMessage());
                }
            }
            return null;
        });
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException);
            switch (errorCode) {
                case -952: {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                case -803: {
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                }
            }
            return null;
        };
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public int getMaxIdentifierLength() {
        return 128;
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public boolean supportsNullPrecedence() {
        return false;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2LegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return DB2IdentityColumnSupport.INSTANCE;
    }

    public boolean supportsInsertReturning() {
        return true;
    }

    public boolean supportsInsertReturningRowId() {
        return false;
    }

    public boolean supportsValuesList() {
        return true;
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    public boolean supportsRecursiveCTE() {
        return this.getDB2Version().isSameOrAfter(9, 7);
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsLateral() {
        return this.getDB2Version().isSameOrAfter(9, 1);
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)false, (boolean)false).result());
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
        }
        return super.translateExtractField(unit);
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getDB2Version().isBefore(11)) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week_iso(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case QUARTER: {
                return "quarter(?2)";
            }
            case EPOCH: {
                if (!this.getDB2Version().isBefore(11)) break;
                return this.timestampdiffPattern(TemporalUnit.SECOND, TemporalType.TIMESTAMP, TemporalType.TIMESTAMP).replace("?2", "'1970-01-01 00:00:00'").replace("?3", "?2");
            }
        }
        return super.extractPattern(unit);
    }

    public String castPattern(CastType from, CastType to) {
        if (from == CastType.STRING && to == CastType.BOOLEAN) {
            return "cast(?1 as ?2)";
        }
        return super.castPattern(from, to);
    }

    public int getInExpressionCountLimit() {
        return Short.MAX_VALUE;
    }

    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public boolean canDisableConstraints() {
        return true;
    }

    public String getDisableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " alter foreign key " + name + " not enforced";
    }

    public String getEnableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " alter foreign key " + name + " enforced";
    }

    public String getTruncateTableStatement(String tableName) {
        return super.getTruncateTableStatement(tableName) + " immediate";
    }

    public String getCreateUserDefinedTypeExtensionsString() {
        return " instantiable mode db2sql";
    }

    public String rowId(String rowId) {
        return "rowid";
    }

    public int rowIdSqlType() {
        return -3;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public boolean supportsFromClauseInUpdate() {
        return this.getDB2Version().isSameOrAfter(11);
    }

    public String getDual() {
        return "sysibm.dual";
    }

    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }
}

