/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.sql.DatabaseMetaData;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.MaxDBSqlAstTranslator;
import org.hibernate.community.dialect.sequence.MaxDBSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorSAPDBDatabaseImpl;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class MaxDBDialect
extends Dialect {
    public MaxDBDialect() {
        super((DatabaseVersion)SimpleDatabaseVersion.ZERO_VERSION);
    }

    public MaxDBDialect(DialectResolutionInfo info) {
        super(info);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case -5: {
                return "fixed(19,0)";
            }
            case 2: 
            case 3: {
                return "fixed($p,$s)";
            }
            case 93: 
            case 2014: {
                return "timestamp";
            }
            case -3: 
            case 2004: {
                return "long byte";
            }
            case 2005: {
                return "long varchar";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public int getMaxVarbinaryLength() {
        return -1;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 2: 
            case 3: {
                if (precision != 19 || scale != 0) break;
                return jdbcTypeRegistry.getDescriptor(-5);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public LimitHandler getLimitHandler() {
        return LimitOffsetLimitHandler.INSTANCE;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.log();
        functionFactory.pi();
        functionFactory.cot();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.trunc();
        functionFactory.trim2();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.translate();
        functionFactory.initcap();
        functionFactory.soundex();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.daynameMonthname();
        functionFactory.dateTimeTimestamp();
        functionFactory.ceiling_ceil();
        functionFactory.week_weekofyear();
        functionFactory.concat_pipeOperator();
        functionFactory.coalesce_value();
        functionFactory.pad_fill();
        functionFactory.datediff();
        functionFactory.adddateSubdateAddtimeSubtime();
        functionFactory.addMonths();
        BasicType integerType = functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
        functionContributions.getFunctionRegistry().registerPattern("extract", "?1(?2)", integerType);
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("nullif", "case ?1 when ?2 then null else ?1 end").setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("index").setInvariantType(integerType).setArgumentCountBetween(2, 4).register();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", integerType, "index(?2,?1)", "index(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, functionContributions.getTypeConfiguration()).setArgumentListSignature("(pattern, string[, start])");
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new MaxDBSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String trimPattern(TrimSpec specification, char character) {
        return AbstractTransactSQLDialect.replaceLtrimRtrim((TrimSpec)specification, (char)character);
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder res = new StringBuilder(30).append(" foreign key ").append(constraintName).append(" (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return foreignKeyDefinition;
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " primary key ";
    }

    public String getNullColumnString() {
        return " null";
    }

    public SequenceSupport getSequenceSupport() {
        return MaxDBSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select * from domain.sequences";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorSAPDBDatabaseImpl.INSTANCE;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, basename -> "temp.HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "temp.HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.DROP;
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    public String getTemporaryTableCreateOptions() {
        return "ignore rollback";
    }

    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }
}

