/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.CUBRIDSqlAstTranslator;
import org.hibernate.community.dialect.identity.CUBRIDIdentityColumnSupport;
import org.hibernate.community.dialect.sequence.CUBRIDSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorCUBRIDDatabaseImpl;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.BinaryFloatDdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class CUBRIDDialect
extends Dialect {
    public CUBRIDDialect() {
        super((DatabaseVersion)SimpleDatabaseVersion.ZERO_VERSION);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "bit";
            }
            case -6: {
                return "smallint";
            }
            case 93: {
                return "datetime";
            }
            case 2013: 
            case 2014: {
                return "datetimetz";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new BinaryFloatDdlType((Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-2, "bit($l)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-3, (CapacityDependentDdlType.LobKind)CapacityDependentDdlType.LobKind.BIGGEST_LOB, (String)this.columnType(2004), (Dialect)this).withTypeCapacity((long)this.getMaxVarbinaryLength(), "bit varying($l)").build());
    }

    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("TYPE");
        this.registerKeyword("YEAR");
        this.registerKeyword("MONTH");
        this.registerKeyword("ALIAS");
        this.registerKeyword("VALUE");
        this.registerKeyword("FIRST");
        this.registerKeyword("ROLE");
        this.registerKeyword("CLASS");
        this.registerKeyword("BIT");
        this.registerKeyword("TIME");
        this.registerKeyword("QUERY");
        this.registerKeyword("DATE");
        this.registerKeyword("USER");
        this.registerKeyword("ACTION");
        this.registerKeyword("SYS_USER");
        this.registerKeyword("ZONE");
        this.registerKeyword("LANGUAGE");
        this.registerKeyword("DICTIONARY");
        this.registerKeyword("DATA");
        this.registerKeyword("TEST");
        this.registerKeyword("SUPERCLASS");
        this.registerKeyword("SECTION");
        this.registerKeyword("LOWER");
        this.registerKeyword("LIST");
        this.registerKeyword("OID");
        this.registerKeyword("DAY");
        this.registerKeyword("IF");
        this.registerKeyword("ATTRIBUTE");
        this.registerKeyword("STRING");
        this.registerKeyword("SEARCH");
    }

    public CUBRIDDialect(DialectResolutionInfo info) {
        this();
        this.registerKeywords(info);
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public int getMaxVarcharLength() {
        return 0x3FFFFFFF;
    }

    public int getMaxVarbinaryLength() {
        return 0x3FFFFFFF;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    public int getDefaultTimestampPrecision() {
        return 3;
    }

    public int getFloatPrecision() {
        return 21;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.trim2();
        functionFactory.space();
        functionFactory.reverse();
        functionFactory.repeat();
        functionFactory.crc32();
        functionFactory.cot();
        functionFactory.log2();
        functionFactory.log10();
        functionFactory.pi();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.systimestamp();
        functionFactory.localtimeLocaltimestamp();
        functionFactory.hourMinuteSecond();
        functionFactory.yearMonthDay();
        functionFactory.dayofweekmonthyear();
        functionFactory.lastDay();
        functionFactory.weekQuarter();
        functionFactory.octetLength();
        functionFactory.bitLength();
        functionFactory.md5();
        functionFactory.trunc();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.substr();
        functionFactory.instr();
        functionFactory.translate();
        functionFactory.ceiling_ceil();
        functionFactory.sha1();
        functionFactory.sha2();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.position();
        functionFactory.insert();
        functionFactory.nowCurdateCurtime();
        functionFactory.makedateMaketime();
        functionFactory.bitandorxornot_bitAndOrXorNot();
        functionFactory.median();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.datediff();
        functionFactory.adddateSubdateAddtimeSubtime();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.rownumInstOrderbyGroupbyNum();
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public SequenceSupport getSequenceSupport() {
        return CUBRIDSequenceSupport.INSTANCE;
    }

    public String getDropForeignKeyString() {
        return "drop foreign key";
    }

    public String getDropUniqueKeyString() {
        return "drop index";
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public String getQuerySequencesString() {
        return "select * from db_serial";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorCUBRIDDatabaseImpl.INSTANCE;
    }

    public char openQuote() {
        return '[';
    }

    public char closeQuote() {
        return ']';
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsTemporaryTables() {
        return false;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new CUBRIDSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public LimitHandler getLimitHandler() {
        return LimitLimitHandler.INSTANCE;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return CUBRIDIdentityColumnSupport.INSTANCE;
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)true, (boolean)false).replace("SSSSSS", "FF").replace("SSSSS", "FF").replace("SSSS", "FF").replace("SSS", "FF").replace("SS", "FF").replace("S", "FF").result());
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000L;
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "(second(?2)+extract(millisecond from ?2)/1e3)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case WEEK: {
                return "week(?2,3)";
            }
        }
        return "?1(?2)";
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                return "adddate(?3,interval (?2)/1e6 millisecond)";
            }
            case NATIVE: {
                return "adddate(?3,interval ?2 millisecond)";
            }
        }
        return "adddate(?3,interval ?2 ?1)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        switch (unit) {
            case DAY: {
                return "datediff(?3,?2)";
            }
            case HOUR: {
                this.timediff(pattern, TemporalUnit.HOUR, unit);
                break;
            }
            case MINUTE: {
                pattern.append("(");
                this.timediff(pattern, TemporalUnit.MINUTE, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.HOUR, unit);
                pattern.append(")");
                break;
            }
            case SECOND: {
                pattern.append("(");
                this.timediff(pattern, TemporalUnit.SECOND, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.MINUTE, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.HOUR, unit);
                pattern.append(")");
                break;
            }
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("(");
                this.timediff(pattern, unit, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.SECOND, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.MINUTE, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.HOUR, unit);
                pattern.append(")");
                break;
            }
            default: {
                throw new SemanticException("unsupported temporal unit for CUBRID: " + unit);
            }
        }
        return pattern.toString();
    }

    private void timediff(StringBuilder sqlAppender, TemporalUnit diffUnit, TemporalUnit toUnit) {
        if (diffUnit == TemporalUnit.NANOSECOND) {
            sqlAppender.append("1e6*");
        }
        sqlAppender.append("extract(");
        if (diffUnit == TemporalUnit.NANOSECOND || diffUnit == TemporalUnit.NATIVE) {
            sqlAppender.append("millisecond");
        } else {
            sqlAppender.append("?1");
        }
        sqlAppender.append(",timediff(?3,?2))");
        sqlAppender.append(diffUnit.conversionFactor(toUnit, (Dialect)this));
    }
}

