/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.c3p0.internal;

import com.mchange.v2.c3p0.DataSources;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import javax.sql.DataSource;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.c3p0.internal.C3P0MessageLogger;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProviderConfigurationException;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

public class C3P0ConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable,
ServiceRegistryAwareService {
    public static final int DEFAULT_MIN_POOL_SIZE = 3;
    public static final int DEFAULT_MAX_POOL_SIZE = 15;
    private static final String HIBERNATE_STYLE_SETTING_PREFIX = "hibernate.c3p0.";
    private static final String C3P0_STYLE_MIN_POOL_SIZE = "c3p0.minPoolSize";
    private static final String C3P0_STYLE_MAX_POOL_SIZE = "c3p0.maxPoolSize";
    private static final String C3P0_STYLE_MAX_IDLE_TIME = "c3p0.maxIdleTime";
    private static final String C3P0_STYLE_MAX_STATEMENTS = "c3p0.maxStatements";
    private static final String C3P0_STYLE_ACQUIRE_INCREMENT = "c3p0.acquireIncrement";
    private static final String C3P0_STYLE_IDLE_CONNECTION_TEST_PERIOD = "c3p0.idleConnectionTestPeriod";
    private static final String C3P0_STYLE_INITIAL_POOL_SIZE = "c3p0.initialPoolSize";
    private DataSource dataSource;
    private Integer isolation;
    private boolean autocommit;
    private Function<Dialect, DatabaseConnectionInfo> dbInfoProducer;
    private ServiceRegistryImplementor serviceRegistry;

    public Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        if (this.isolation != null && this.isolation.intValue() != connection.getTransactionIsolation()) {
            connection.setTransactionIsolation(this.isolation);
        }
        if (connection.getAutoCommit() != this.autocommit) {
            connection.setAutoCommit(this.autocommit);
        }
        return connection;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return unwrapType.isAssignableFrom(C3P0ConnectionProvider.class) || unwrapType.isAssignableFrom(DataSource.class);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (unwrapType.isAssignableFrom(C3P0ConnectionProvider.class)) {
            return (T)this;
        }
        if (unwrapType.isAssignableFrom(DataSource.class)) {
            return (T)this.dataSource;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void configure(Map<String, Object> properties) {
        ConnectionInfoLogger.INSTANCE.configureConnectionPool("c3p0");
        String jdbcDriverClass = ConnectionProviderInitiator.extractSetting(properties, (String[])new String[]{"jakarta.persistence.jdbc.driver", "hibernate.connection.driver_class", "javax.persistence.jdbc.driver"});
        String jdbcUrl = ConnectionProviderInitiator.extractSetting(properties, (String[])new String[]{"jakarta.persistence.jdbc.url", "hibernate.connection.url", "javax.persistence.jdbc.url"});
        this.loadDriverClass(jdbcDriverClass);
        this.autocommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", properties);
        this.isolation = ConnectionProviderInitiator.extractIsolation(properties);
        Properties connectionProps = ConnectionProviderInitiator.getConnectionProperties(properties);
        Map<String, Object> poolSettings = this.poolSettings(properties);
        this.dataSource = this.createDataSource(jdbcUrl, connectionProps, poolSettings);
        try (Connection connection = this.dataSource.getConnection();){
            Integer fetchSize = DatabaseConnectionInfoImpl.getFetchSize((Connection)connection);
            boolean hasSchema = DatabaseConnectionInfoImpl.hasSchema((Connection)connection);
            boolean hasCatalog = DatabaseConnectionInfoImpl.hasCatalog((Connection)connection);
            String schema = DatabaseConnectionInfoImpl.getSchema((Connection)connection);
            String catalog = DatabaseConnectionInfoImpl.getCatalog((Connection)connection);
            String driverName = DatabaseConnectionInfoImpl.getDriverName((Connection)connection);
            if (this.isolation == null) {
                this.isolation = DatabaseConnectionInfoImpl.getIsolation((Connection)connection);
            }
            this.dbInfoProducer = dialect -> new DatabaseConnectionInfoImpl(C3P0ConnectionProvider.class, jdbcUrl, driverName, dialect.getClass(), dialect.getVersion(), hasSchema, hasCatalog, schema, catalog, Boolean.toString(this.autocommit), this.isolation == null ? null : ConnectionProviderInitiator.toIsolationNiceName((Integer)this.isolation), Objects.requireNonNullElse(ConfigurationHelper.getInteger((String)C3P0_STYLE_MIN_POOL_SIZE.substring(5), (Map)poolSettings), 3), Objects.requireNonNullElse(ConfigurationHelper.getInteger((String)C3P0_STYLE_MAX_POOL_SIZE.substring(5), (Map)poolSettings), 15), fetchSize);
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new JDBCConnectionException("Could not create connection", e);
        }
    }

    private DataSource createDataSource(String jdbcUrl, Properties connectionProps, Map<String, Object> poolProperties) {
        try {
            return DataSources.pooledDataSource((DataSource)DataSources.unpooledDataSource((String)jdbcUrl, (Properties)connectionProps), poolProperties);
        }
        catch (Exception e) {
            ConnectionInfoLogger.INSTANCE.unableToInstantiateConnectionPool(e);
            throw new ConnectionProviderConfigurationException("Could not configure c3p0: " + e.getMessage(), (Throwable)e);
        }
    }

    private void loadDriverClass(String jdbcDriverClass) {
        if (jdbcDriverClass == null) {
            ConnectionInfoLogger.INSTANCE.jdbcDriverNotSpecified();
        } else {
            try {
                ((ClassLoaderService)this.serviceRegistry.requireService(ClassLoaderService.class)).classForName(jdbcDriverClass);
            }
            catch (ClassLoadingException e) {
                throw new ClassLoadingException("JDBC Driver class " + jdbcDriverClass + " not found", (Throwable)e);
            }
        }
    }

    private Map<String, Object> poolSettings(Map<String, Object> hibernateProperties) {
        Integer maxPoolSize = ConfigurationHelper.getInteger((String)"hibernate.c3p0.max_size", hibernateProperties);
        if (maxPoolSize == null) {
            maxPoolSize = ConfigurationHelper.getInteger((String)"hibernate.connection.pool_size", hibernateProperties);
        }
        Integer minPoolSize = ConfigurationHelper.getInteger((String)"hibernate.c3p0.min_size", hibernateProperties);
        Integer maxIdleTime = ConfigurationHelper.getInteger((String)"hibernate.c3p0.timeout", hibernateProperties);
        Integer maxStatements = ConfigurationHelper.getInteger((String)"hibernate.c3p0.max_statements", hibernateProperties);
        Integer acquireIncrement = ConfigurationHelper.getInteger((String)"hibernate.c3p0.acquire_increment", hibernateProperties);
        Integer idleTestPeriod = ConfigurationHelper.getInteger((String)"hibernate.c3p0.idle_test_period", hibernateProperties);
        HashMap<String, Object> c3p0Properties = new HashMap<String, Object>();
        for (String key : hibernateProperties.keySet()) {
            if (!key.startsWith(HIBERNATE_STYLE_SETTING_PREFIX)) continue;
            String newKey = key.substring(HIBERNATE_STYLE_SETTING_PREFIX.length());
            if (hibernateProperties.containsKey(newKey)) {
                this.warnPropertyConflict(key, newKey);
            }
            c3p0Properties.put(newKey, hibernateProperties.get(key));
        }
        this.setOverwriteProperty("hibernate.c3p0.min_size", C3P0_STYLE_MIN_POOL_SIZE, hibernateProperties, c3p0Properties, minPoolSize);
        this.setOverwriteProperty("hibernate.c3p0.max_size", C3P0_STYLE_MAX_POOL_SIZE, hibernateProperties, c3p0Properties, maxPoolSize);
        this.setOverwriteProperty("hibernate.c3p0.timeout", C3P0_STYLE_MAX_IDLE_TIME, hibernateProperties, c3p0Properties, maxIdleTime);
        this.setOverwriteProperty("hibernate.c3p0.max_statements", C3P0_STYLE_MAX_STATEMENTS, hibernateProperties, c3p0Properties, maxStatements);
        this.setOverwriteProperty("hibernate.c3p0.acquire_increment", C3P0_STYLE_ACQUIRE_INCREMENT, hibernateProperties, c3p0Properties, acquireIncrement);
        this.setOverwriteProperty("hibernate.c3p0.idle_test_period", C3P0_STYLE_IDLE_CONNECTION_TEST_PERIOD, hibernateProperties, c3p0Properties, idleTestPeriod);
        Integer initialPoolSize = ConfigurationHelper.getInteger((String)C3P0_STYLE_INITIAL_POOL_SIZE, hibernateProperties);
        if (initialPoolSize == null) {
            this.setOverwriteProperty("", C3P0_STYLE_INITIAL_POOL_SIZE, hibernateProperties, c3p0Properties, minPoolSize);
        }
        HashMap<String, Object> aggregatedProperties = new HashMap<String, Object>();
        aggregatedProperties.putAll(hibernateProperties);
        aggregatedProperties.putAll(c3p0Properties);
        return aggregatedProperties;
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return this.dbInfoProducer.apply(dialect);
    }

    private void setOverwriteProperty(String hibernateStyleKey, String c3p0StyleKey, Map<String, Object> hibernateProperties, Map<String, Object> c3p0Properties, Integer value) {
        if (value != null) {
            String longC3p0StyleKey;
            String peeledC3p0Key = c3p0StyleKey.substring(5);
            c3p0Properties.put(peeledC3p0Key, String.valueOf(value).trim());
            if (hibernateProperties.containsKey(c3p0StyleKey)) {
                this.warnPropertyConflict(hibernateStyleKey, c3p0StyleKey);
            }
            if (hibernateProperties.containsKey(longC3p0StyleKey = "hibernate." + c3p0StyleKey)) {
                this.warnPropertyConflict(hibernateStyleKey, longC3p0StyleKey);
            }
        }
    }

    private void warnPropertyConflict(String hibernateStyle, String c3p0Style) {
        C3P0MessageLogger.C3P0_MSG_LOGGER.bothHibernateAndC3p0StylesSet(hibernateStyle, c3p0Style);
    }

    public void stop() {
        ConnectionInfoLogger.INSTANCE.cleaningUpConnectionPool("hibernate.c3p0");
        try {
            DataSources.destroy((DataSource)this.dataSource);
        }
        catch (SQLException sqle) {
            ConnectionInfoLogger.INSTANCE.unableToDestroyConnectionPool((Exception)sqle);
        }
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

