/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.agroal.internal;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalPropertiesReader;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProviderConfigurationException;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class AgroalConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    public static final String CONFIG_PREFIX = "hibernate.agroal.";
    private static final long serialVersionUID = 1L;
    private AgroalDataSource agroalDataSource = null;

    private static String extractIsolationAsString(Map<String, Object> properties) {
        Integer isolation = ConnectionProviderInitiator.extractIsolation(properties);
        return isolation != null ? ConnectionProviderInitiator.toIsolationNiceName((Integer)isolation) : null;
    }

    private static void resolveIsolationSetting(Map<String, Object> properties, AgroalConnectionFactoryConfigurationSupplier cf) {
        String isolationString = AgroalConnectionProvider.extractIsolationAsString(properties);
        if (isolationString != null) {
            cf.jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation.valueOf((String)isolationString));
        }
    }

    private static <T> void copyProperty(Map<String, Object> properties, String key, Consumer<T> consumer, Function<String, T> converter) {
        Object value = properties.get(key);
        if (value != null) {
            consumer.accept(converter.apply(value.toString()));
        }
    }

    public void configure(Map<String, Object> properties) throws HibernateException {
        ConnectionInfoLogger.INSTANCE.configureConnectionPool("Agroal");
        try {
            Map<String, String> config = AgroalConnectionProvider.toStringValuedProperties(properties);
            if (!properties.containsKey("hibernate.agroal.maxSize")) {
                String maxSize = properties.containsKey("hibernate.connection.pool_size") ? properties.get("hibernate.connection.pool_size").toString() : String.valueOf(10);
                config.put("hibernate.agroal.maxSize", maxSize);
            }
            AgroalPropertiesReader agroalProperties = new AgroalPropertiesReader(CONFIG_PREFIX).readProperties(config);
            agroalProperties.modify().connectionPoolConfiguration(cp -> cp.connectionFactoryConfiguration(cf -> {
                AgroalConnectionProvider.copyProperty(properties, "hibernate.connection.driver_class", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).connectionProviderClassName(arg_0), Function.identity());
                AgroalConnectionProvider.copyProperty(properties, "hibernate.connection.url", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).jdbcUrl(arg_0), Function.identity());
                AgroalConnectionProvider.copyProperty(properties, "hibernate.connection.username", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).principal(arg_0), NamePrincipal::new);
                AgroalConnectionProvider.copyProperty(properties, "hibernate.connection.password", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).credential(arg_0), SimplePassword::new);
                AgroalConnectionProvider.copyProperty(properties, "hibernate.connection.autocommit", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).autoCommit(arg_0), Boolean::valueOf);
                AgroalConnectionProvider.resolveIsolationSetting(properties, cf);
                return cf;
            }));
            this.agroalDataSource = AgroalDataSource.from((Supplier)agroalProperties, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
        }
        catch (Exception e) {
            ConnectionInfoLogger.INSTANCE.unableToInstantiateConnectionPool(e);
            throw new ConnectionProviderConfigurationException("Could not configure Agroal: " + e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, String> toStringValuedProperties(Map<String, Object> properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }

    public Connection getConnection() throws SQLException {
        return this.agroalDataSource == null ? null : this.agroalDataSource.getConnection();
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        DatabaseConnectionInfoImpl databaseConnectionInfoImpl;
        block9: {
            AgroalConnectionPoolConfiguration poolConfig = this.agroalDataSource.getConfiguration().connectionPoolConfiguration();
            AgroalConnectionFactoryConfiguration connectionConfig = poolConfig.connectionFactoryConfiguration();
            Connection connection = this.agroalDataSource.getConnection();
            try {
                DatabaseConnectionInfoImpl info = new DatabaseConnectionInfoImpl(AgroalConnectionProvider.class, connectionConfig.jdbcUrl(), connectionConfig.connectionProviderClass() != null ? connectionConfig.connectionProviderClass().toString() : DatabaseConnectionInfoImpl.getDriverName((Connection)connection), dialect.getClass(), dialect.getVersion(), DatabaseConnectionInfoImpl.hasSchema((Connection)connection), DatabaseConnectionInfoImpl.hasCatalog((Connection)connection), DatabaseConnectionInfoImpl.getSchema((Connection)connection), DatabaseConnectionInfoImpl.getCatalog((Connection)connection), Boolean.toString(connectionConfig.autoCommit()), connectionConfig.jdbcTransactionIsolation() != null && connectionConfig.jdbcTransactionIsolation().isDefined() ? ConnectionProviderInitiator.toIsolationNiceName((Integer)connectionConfig.jdbcTransactionIsolation().level()) : ConnectionProviderInitiator.toIsolationNiceName((Integer)DatabaseConnectionInfoImpl.getIsolation((Connection)connection)), Integer.valueOf(poolConfig.minSize()), Integer.valueOf(poolConfig.maxSize()), DatabaseConnectionInfoImpl.getFetchSize((Connection)connection));
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                }
                databaseConnectionInfoImpl = info;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JDBCConnectionException("Could not create connection", e);
                }
            }
            connection.close();
        }
        return databaseConnectionInfoImpl;
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return unwrapType.isAssignableFrom(AgroalConnectionProvider.class) || unwrapType.isAssignableFrom(AgroalDataSource.class);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (unwrapType.isAssignableFrom(AgroalConnectionProvider.class)) {
            return (T)this;
        }
        if (unwrapType.isAssignableFrom(AgroalDataSource.class)) {
            return (T)this.agroalDataSource;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        if (this.agroalDataSource != null) {
            ConnectionInfoLogger.INSTANCE.cleaningUpConnectionPool(this.agroalDataSource.getConfiguration().connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl());
            this.agroalDataSource.close();
        }
    }
}

