/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.lang.annotation.Annotation;
import org.hibernate.models.jandex.spi.JandexModelBuildingContext;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class JandexValueHelper {
    public static <A extends Annotation, V> V extractValue(AnnotationInstance usage, AnnotationDescriptor<A> descriptor, String attributeName, SourceModelBuildingContext modelContext) {
        AttributeDescriptor attribute = descriptor.getAttribute(attributeName);
        return JandexValueHelper.extractValue(usage, attribute, modelContext);
    }

    public static <V> V extractValue(AnnotationInstance usage, AttributeDescriptor<V> attributeDescriptor, SourceModelBuildingContext modelContext) {
        return ((JandexModelBuildingContext)modelContext.as(JandexModelBuildingContext.class)).getJandexValueExtractor(attributeDescriptor.getTypeDescriptor()).extractValue(usage, attributeDescriptor, modelContext);
    }

    public static <A extends Annotation, V> V extractOptionalValue(AnnotationInstance usage, AnnotationDescriptor<A> descriptor, String attributeName, SourceModelBuildingContext modelContext) {
        return JandexValueHelper.extractOptionalValue(usage, descriptor.getAttribute(attributeName), modelContext);
    }

    public static <V> V extractOptionalValue(AnnotationInstance usage, AttributeDescriptor<V> attributeDescriptor, SourceModelBuildingContext modelContext) {
        AnnotationValue value = usage.value(attributeDescriptor.getName());
        if (value == null) {
            return (V)attributeDescriptor.getAttributeMethod().getDefaultValue();
        }
        return ((JandexModelBuildingContext)modelContext.as(JandexModelBuildingContext.class)).getJandexValueExtractor(attributeDescriptor.getTypeDescriptor()).extractValue(usage, attributeDescriptor, modelContext);
    }
}

