/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.models.internal.AbstractModelBuildingContext;
import org.hibernate.models.internal.ModelsClassLogging;
import org.hibernate.models.internal.MutableAnnotationDescriptorRegistry;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.jandex.internal.JandexAnnotationDescriptorRegistry;
import org.hibernate.models.jandex.internal.JandexBuilders;
import org.hibernate.models.jandex.internal.JandexClassDetailsRegistry;
import org.hibernate.models.jandex.spi.JandexModelBuildingContext;
import org.hibernate.models.jandex.spi.JandexValueConverter;
import org.hibernate.models.jandex.spi.JandexValueExtractor;
import org.hibernate.models.serial.internal.StorableContextImpl;
import org.hibernate.models.serial.spi.StorableContext;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.RegistryPrimer;
import org.hibernate.models.spi.ValueTypeDescriptor;
import org.jboss.jandex.IndexView;

public class JandexModelBuildingContextImpl
extends AbstractModelBuildingContext
implements JandexModelBuildingContext {
    private final IndexView jandexIndex;
    private final JandexAnnotationDescriptorRegistry descriptorRegistry;
    private final JandexClassDetailsRegistry classDetailsRegistry;
    private final Map<ValueTypeDescriptor, JandexValueConverter> valueConverters = new HashMap<ValueTypeDescriptor, JandexValueConverter>();
    private final Map<ValueTypeDescriptor, JandexValueExtractor> valueExtractors = new HashMap<ValueTypeDescriptor, JandexValueExtractor>();

    public JandexModelBuildingContextImpl(IndexView jandexIndex, ClassLoading classLoading, RegistryPrimer registryPrimer) {
        super(classLoading);
        assert (jandexIndex != null);
        this.jandexIndex = jandexIndex;
        ModelsClassLogging.MODELS_CLASS_LOGGER.debugf("Using Jandex support", new Object[0]);
        this.descriptorRegistry = new JandexAnnotationDescriptorRegistry(this);
        this.classDetailsRegistry = new JandexClassDetailsRegistry(jandexIndex, this);
        this.primeRegistries(registryPrimer);
    }

    public MutableAnnotationDescriptorRegistry getAnnotationDescriptorRegistry() {
        return this.descriptorRegistry;
    }

    public MutableClassDetailsRegistry getClassDetailsRegistry() {
        return this.classDetailsRegistry;
    }

    @Override
    public IndexView getJandexIndex() {
        return this.jandexIndex;
    }

    @Override
    public <V> JandexValueConverter<V> getJandexValueConverter(ValueTypeDescriptor<V> valueTypeDescriptor) {
        JandexValueConverter existing = this.valueConverters.get(valueTypeDescriptor);
        if (existing != null) {
            return existing;
        }
        return JandexBuilders.buildValueHandlersReturnConverter(valueTypeDescriptor, this.valueConverters::put, this.valueExtractors::put, this);
    }

    @Override
    public <V> JandexValueExtractor<V> getJandexValueExtractor(ValueTypeDescriptor<V> valueTypeDescriptor) {
        JandexValueExtractor existing = this.valueExtractors.get(valueTypeDescriptor);
        if (existing != null) {
            return existing;
        }
        return JandexBuilders.buildValueHandlersReturnExtractor(valueTypeDescriptor, this.valueConverters::put, this.valueExtractors::put, this);
    }

    public StorableContext toStorableForm() {
        return new StorableContextImpl(this.classDetailsRegistry.getClassDetailsMap(), this.descriptorRegistry.getDescriptorMap());
    }
}

