/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.jandex.internal.AbstractAnnotationTarget;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassBasedTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeVariableScope;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JandexMethodDetails
extends AbstractAnnotationTarget
implements MethodDetails,
MutableMemberDetails {
    private final MethodInfo methodInfo;
    private final MethodDetails.MethodKind methodKind;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final ClassDetails returnType;
    private final List<ClassDetails> argumentTypes;
    private final boolean isArray;
    private final boolean isPlural;
    private Method underlyingMethod;

    public JandexMethodDetails(MethodInfo methodInfo, MethodDetails.MethodKind methodKind, TypeDetails type, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        super(buildingContext);
        this.methodInfo = methodInfo;
        this.methodKind = methodKind;
        this.type = type;
        this.declaringType = declaringType;
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getClassDetailsRegistry();
        this.returnType = classDetailsRegistry.resolveClassDetails(methodInfo.returnType().name().toString());
        this.argumentTypes = new ArrayList<ClassDetails>(methodInfo.parametersCount());
        for (int i = 0; i < methodInfo.parametersCount(); ++i) {
            this.argumentTypes.add(classDetailsRegistry.resolveClassDetails(methodInfo.parameterType(i).name().toString()));
        }
        switch (methodKind) {
            case GETTER: {
                this.isArray = methodInfo.returnType().kind() == Type.Kind.ARRAY;
                this.isPlural = this.isArray || type.isImplementor(Collection.class) || type.isImplementor(Map.class);
                break;
            }
            case SETTER: {
                assert (methodInfo.parametersCount() == 1);
                this.isArray = methodInfo.parameterType(0).kind() == Type.Kind.ARRAY;
                this.isPlural = this.isArray || type.isImplementor(Collection.class) || type.isImplementor(Map.class);
                break;
            }
            default: {
                this.isArray = false;
                this.isPlural = false;
            }
        }
    }

    @Override
    protected AnnotationTarget getJandexAnnotationTarget() {
        return this.methodInfo;
    }

    public String getName() {
        return this.methodInfo.name();
    }

    public MethodDetails.MethodKind getMethodKind() {
        return this.methodKind;
    }

    public TypeDetails getType() {
        return this.type;
    }

    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    public boolean isPlural() {
        return this.isPlural;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getModifiers() {
        return this.methodInfo.flags();
    }

    public Method toJavaMember() {
        if (this.underlyingMethod == null) {
            this.underlyingMethod = this.resolveJavaMember();
        }
        return this.underlyingMethod;
    }

    public TypeDetails resolveRelativeType(TypeVariableScope container) {
        if (this.methodKind == MethodDetails.MethodKind.GETTER || this.methodKind == MethodDetails.MethodKind.SETTER) {
            return this.type.determineRelativeType(container);
        }
        throw new IllegalStateException("Method does not have a type - " + this);
    }

    public ClassBasedTypeDetails resolveRelativeClassType(TypeVariableScope container) {
        if (this.methodKind == MethodDetails.MethodKind.GETTER || this.methodKind == MethodDetails.MethodKind.SETTER) {
            return TypeDetailsHelper.resolveRelativeClassType((TypeDetails)this.type, (TypeVariableScope)container);
        }
        throw new IllegalStateException("Method does not have a type - " + this);
    }

    private Method resolveJavaMember() {
        Class declaringTypeClass = this.declaringType.toJavaClass();
        block0: for (Method method : declaringTypeClass.getDeclaredMethods()) {
            if (!method.getName().equals(this.methodInfo.name()) || method.getParameterCount() != this.methodInfo.parametersCount()) continue;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> methodParameterType = method.getParameterTypes()[i];
                Type expectedType = this.methodInfo.parameterType(i);
                if (!methodParameterType.getName().equals(expectedType.name().toString())) continue block0;
            }
            return method;
        }
        throw new RuntimeException(String.format("Jandex FieldInfo had no corresponding Field : %s.%s", this.declaringType.getName(), this.methodInfo.name()));
    }

    public ClassDetails getReturnType() {
        return this.returnType;
    }

    public List<ClassDetails> getArgumentTypes() {
        return this.argumentTypes;
    }

    public String toString() {
        return String.format(Locale.ROOT, "JandexMethodDetails( [%s] %s )", this.methodKind.name(), this.methodInfo.toString());
    }

    public MethodDetails asMethodDetails() {
        return this;
    }

    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    public FieldDetails asFieldDetails() {
        throw new IllegalCastException("MethodDetails cannot be cast as FieldDetails");
    }

    public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("MethodDetails cannot be cast as RecordComponentDetails");
    }

    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("MethodDetails cannot be cast to an AnnotationDescriptor");
    }

    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("MethodDetails cannot be cast to a ClassDetails");
    }
}

