/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.AnnotationTargetSupport;
import org.hibernate.models.jandex.internal.AbstractAnnotationTarget;
import org.hibernate.models.jandex.internal.JandexTypeSwitchStandard;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;

public class JandexFieldDetails
extends AbstractAnnotationTarget
implements FieldDetails,
MutableMemberDetails,
AnnotationTargetSupport {
    private final FieldInfo fieldInfo;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final boolean isArray;
    private final boolean isPlural;
    private Member underlyingMember;

    public JandexFieldDetails(FieldInfo fieldInfo, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        super(buildingContext);
        this.fieldInfo = fieldInfo;
        this.declaringType = declaringType;
        this.type = JandexTypeSwitchStandard.switchType(fieldInfo.type(), declaringType, buildingContext);
        this.isArray = fieldInfo.type().kind() == Type.Kind.ARRAY;
        this.isPlural = this.isArray || this.type.isImplementor(Collection.class) || this.type.isImplementor(Map.class);
    }

    @Override
    protected AnnotationTarget getJandexAnnotationTarget() {
        return this.fieldInfo;
    }

    public String getName() {
        return this.fieldInfo.name();
    }

    public TypeDetails getType() {
        return this.type;
    }

    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    public boolean isPlural() {
        return this.isPlural;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getModifiers() {
        return this.fieldInfo.flags();
    }

    public Member toJavaMember() {
        if (this.underlyingMember == null) {
            this.underlyingMember = this.resolveJavaMember();
        }
        return this.underlyingMember;
    }

    private Field resolveJavaMember() {
        Class declaringJavaClass = this.declaringType.toJavaClass();
        try {
            return declaringJavaClass.getField(this.fieldInfo.name());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Jandex FieldInfo had no corresponding Field : %s.%s", this.declaringType.getName(), this.fieldInfo.name()), e);
        }
    }

    public String toString() {
        return "JandexFieldDetails(" + this.getName() + ")";
    }

    public FieldDetails asFieldDetails() {
        return this;
    }

    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    public MethodDetails asMethodDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as MethodDetails");
    }

    public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as RecordComponentDetails");
    }

    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("FieldDetails cannot be cast to an AnnotationDescriptor");
    }

    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast to a ClassDetails");
    }
}

