/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.util.function.BiConsumer;
import org.hibernate.models.internal.ArrayTypeDescriptor;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.jandex.internal.ArrayValueConverter;
import org.hibernate.models.jandex.internal.ArrayValueExtractor;
import org.hibernate.models.jandex.internal.BooleanValueConverter;
import org.hibernate.models.jandex.internal.BooleanValueExtractor;
import org.hibernate.models.jandex.internal.ByteValueConverter;
import org.hibernate.models.jandex.internal.ByteValueExtractor;
import org.hibernate.models.jandex.internal.CharacterValueConverter;
import org.hibernate.models.jandex.internal.CharacterValueExtractor;
import org.hibernate.models.jandex.internal.ClassValueConverter;
import org.hibernate.models.jandex.internal.ClassValueExtractor;
import org.hibernate.models.jandex.internal.DoubleValueConverter;
import org.hibernate.models.jandex.internal.DoubleValueExtractor;
import org.hibernate.models.jandex.internal.EnumValueConverter;
import org.hibernate.models.jandex.internal.EnumValueExtractor;
import org.hibernate.models.jandex.internal.FloatValueConverter;
import org.hibernate.models.jandex.internal.FloatValueExtractor;
import org.hibernate.models.jandex.internal.IntegerValueConverter;
import org.hibernate.models.jandex.internal.IntegerValueExtractor;
import org.hibernate.models.jandex.internal.JandexClassDetails;
import org.hibernate.models.jandex.internal.JandexMethodDetails;
import org.hibernate.models.jandex.internal.JandexNestedValueConverter;
import org.hibernate.models.jandex.internal.JandexNestedValueExtractor;
import org.hibernate.models.jandex.internal.JandexTypeSwitchStandard;
import org.hibernate.models.jandex.internal.LongValueConverter;
import org.hibernate.models.jandex.internal.LongValueExtractor;
import org.hibernate.models.jandex.internal.ShortValueConverter;
import org.hibernate.models.jandex.internal.ShortValueExtractor;
import org.hibernate.models.jandex.internal.StringValueConverter;
import org.hibernate.models.jandex.internal.StringValueExtractor;
import org.hibernate.models.jandex.spi.JandexValueConverter;
import org.hibernate.models.jandex.spi.JandexValueExtractor;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.ValueTypeDescriptor;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JandexBuilders {
    public static ClassDetails buildDetailsFromIndex(String name, IndexView jandexIndex, SourceModelBuildingContext processingContext) {
        ClassInfo classInfo;
        if (StringHelper.isEmpty((String)name)) {
            return null;
        }
        if ("void".equals(name)) {
            name = Void.class.getName();
        }
        if ((classInfo = jandexIndex.getClassByName(name)) != null) {
            return new JandexClassDetails(classInfo, processingContext);
        }
        Class<?> primitiveClass = JandexBuilders.resolvePrimitiveClass(name);
        if (primitiveClass != null) {
            return JdkBuilders.buildClassDetailsStatic(primitiveClass, (SourceModelBuildingContext)processingContext);
        }
        ClassInfo packageInfo = jandexIndex.getClassByName(name + ".package-info");
        if (packageInfo != null) {
            return JdkBuilders.buildClassDetailsStatic((String)(name + ".package-info"), (SourceModelBuildingContext)processingContext);
        }
        return null;
    }

    public static Class<?> resolvePrimitiveClass(String className) {
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if (Boolean.class.getSimpleName().equalsIgnoreCase(className) || Boolean.class.getName().equals(className)) {
            return Boolean.class;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        if (Byte.class.getSimpleName().equals(className) || Byte.class.getName().equals(className)) {
            return Byte.class;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if (Short.class.getSimpleName().equals(className) || Short.class.getName().equals(className)) {
            return Short.class;
        }
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if (Integer.class.getSimpleName().equals(className) || Integer.class.getName().equals(className)) {
            return Integer.class;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if (Long.class.getSimpleName().equals(className) || Long.class.getName().equals(className)) {
            return Long.class;
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if (Double.class.getSimpleName().equals(className) || Double.class.getName().equals(className)) {
            return Double.class;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if (Float.class.getSimpleName().equals(className) || Float.class.getName().equals(className)) {
            return Float.class;
        }
        return null;
    }

    public static JandexMethodDetails buildMethodDetails(MethodInfo method, ClassDetails declaringType, SourceModelBuildingContext buildingContext) {
        Type returnType;
        if (method.parametersCount() == 0 && (returnType = method.returnType()).kind() != Type.Kind.VOID) {
            String methodName = method.name();
            if (methodName.startsWith("get")) {
                return new JandexMethodDetails(method, MethodDetails.MethodKind.GETTER, JandexTypeSwitchStandard.switchType(returnType, declaringType, buildingContext), declaringType, buildingContext);
            }
            if (JandexBuilders.isBoolean(returnType) && (methodName.startsWith("is") || methodName.startsWith("has") || methodName.startsWith("was"))) {
                return new JandexMethodDetails(method, MethodDetails.MethodKind.GETTER, JandexTypeSwitchStandard.switchType(returnType, declaringType, buildingContext), declaringType, buildingContext);
            }
        }
        if (method.parametersCount() == 1 && method.returnType().kind() == Type.Kind.VOID && method.name().startsWith("set")) {
            return new JandexMethodDetails(method, MethodDetails.MethodKind.SETTER, JandexTypeSwitchStandard.switchType(method.parameterType(0), declaringType, buildingContext), declaringType, buildingContext);
        }
        return new JandexMethodDetails(method, MethodDetails.MethodKind.OTHER, null, declaringType, buildingContext);
    }

    private static boolean isBoolean(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return type.name().toString().equals("boolean");
        }
        return type.name().toString().equals("java.lang.Boolean");
    }

    public static <V> JandexValueConverter<V> buildValueHandlersReturnConverter(ValueTypeDescriptor<V> valueTypeDescriptor, BiConsumer<ValueTypeDescriptor<V>, JandexValueConverter<V>> converterCollector, BiConsumer<ValueTypeDescriptor<V>, JandexValueExtractor<V>> extractorCollector, SourceModelBuildingContext buildingContext) {
        if (valueTypeDescriptor.getValueType().isArray()) {
            ValueTypeDescriptor elementTypeDescriptor = ((ArrayTypeDescriptor)valueTypeDescriptor).getElementTypeDescriptor();
            ArrayValueConverter valueConverter = new ArrayValueConverter(elementTypeDescriptor);
            ArrayValueExtractor valueExtractor = new ArrayValueExtractor(valueConverter);
            converterCollector.accept(valueTypeDescriptor, valueConverter);
            extractorCollector.accept(valueTypeDescriptor, valueExtractor);
            return valueConverter;
        }
        if (JandexBuilders.isBoolean(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, BooleanValueConverter.JANDEX_BOOLEAN_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, BooleanValueExtractor.JANDEX_BOOLEAN_EXTRACTOR);
            return BooleanValueConverter.JANDEX_BOOLEAN_VALUE_WRAPPER;
        }
        if (JandexBuilders.isByte(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, ByteValueConverter.JANDEX_BYTE_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ByteValueExtractor.JANDEX_BYTE_EXTRACTOR);
            return ByteValueConverter.JANDEX_BYTE_VALUE_WRAPPER;
        }
        if (JandexBuilders.isChar(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, CharacterValueConverter.JANDEX_CHARACTER_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, CharacterValueExtractor.JANDEX_CHARACTER_EXTRACTOR);
            return CharacterValueConverter.JANDEX_CHARACTER_VALUE_WRAPPER;
        }
        if (JandexBuilders.isDouble(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, DoubleValueConverter.JANDEX_DOUBLE_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, DoubleValueExtractor.JANDEX_DOUBLE_EXTRACTOR);
            return DoubleValueConverter.JANDEX_DOUBLE_VALUE_WRAPPER;
        }
        if (JandexBuilders.isFloat(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, FloatValueConverter.JANDEX_FLOAT_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, FloatValueExtractor.JANDEX_FLOAT_EXTRACTOR);
            return FloatValueConverter.JANDEX_FLOAT_VALUE_WRAPPER;
        }
        if (JandexBuilders.isInt(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, IntegerValueConverter.JANDEX_INTEGER_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, IntegerValueExtractor.JANDEX_INTEGER_EXTRACTOR);
            return IntegerValueConverter.JANDEX_INTEGER_VALUE_WRAPPER;
        }
        if (JandexBuilders.isLong(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, LongValueConverter.JANDEX_LONG_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, LongValueExtractor.JANDEX_LONG_EXTRACTOR);
            return LongValueConverter.JANDEX_LONG_VALUE_WRAPPER;
        }
        if (JandexBuilders.isShort(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, ShortValueConverter.JANDEX_SHORT_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ShortValueExtractor.JANDEX_SHORT_EXTRACTOR);
            return ShortValueConverter.JANDEX_SHORT_VALUE_WRAPPER;
        }
        if (valueTypeDescriptor.getValueType() == String.class) {
            converterCollector.accept(valueTypeDescriptor, StringValueConverter.JANDEX_STRING_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, StringValueExtractor.JANDEX_STRING_EXTRACTOR);
            return StringValueConverter.JANDEX_STRING_VALUE_WRAPPER;
        }
        if (valueTypeDescriptor.getValueType().isAnnotation()) {
            AnnotationDescriptor annotationDescriptor = buildingContext.getAnnotationDescriptorRegistry().getDescriptor(valueTypeDescriptor.getValueType());
            JandexNestedValueConverter jandexNestedValueConverter = new JandexNestedValueConverter(annotationDescriptor);
            JandexNestedValueExtractor jandexNestedValueExtractor = new JandexNestedValueExtractor(jandexNestedValueConverter);
            converterCollector.accept(valueTypeDescriptor, jandexNestedValueConverter);
            extractorCollector.accept(valueTypeDescriptor, jandexNestedValueExtractor);
            return jandexNestedValueConverter;
        }
        if (valueTypeDescriptor.getValueType().isEnum()) {
            EnumValueConverter converter = new EnumValueConverter(valueTypeDescriptor.getValueType());
            converterCollector.accept(valueTypeDescriptor, converter);
            extractorCollector.accept(valueTypeDescriptor, new EnumValueExtractor(converter));
            return converter;
        }
        if (valueTypeDescriptor.getValueType() == Class.class) {
            converterCollector.accept(valueTypeDescriptor, ClassValueConverter.JANDEX_CLASS_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ClassValueExtractor.JANDEX_CLASS_EXTRACTOR);
            return ClassValueConverter.JANDEX_CLASS_VALUE_WRAPPER;
        }
        throw new UnsupportedOperationException("Unhandled value type : " + valueTypeDescriptor);
    }

    public static <V> JandexValueExtractor<V> buildValueHandlersReturnExtractor(ValueTypeDescriptor<V> valueTypeDescriptor, BiConsumer<ValueTypeDescriptor<V>, JandexValueConverter<V>> converterCollector, BiConsumer<ValueTypeDescriptor<V>, JandexValueExtractor<V>> extractorCollector, SourceModelBuildingContext buildingContext) {
        if (valueTypeDescriptor.getValueType().isArray()) {
            ValueTypeDescriptor elementTypeDescriptor = ((ArrayTypeDescriptor)valueTypeDescriptor).getElementTypeDescriptor();
            ArrayValueConverter valueConverter = new ArrayValueConverter(elementTypeDescriptor);
            ArrayValueExtractor valueExtractor = new ArrayValueExtractor(valueConverter);
            converterCollector.accept(valueTypeDescriptor, valueConverter);
            extractorCollector.accept(valueTypeDescriptor, valueExtractor);
            return valueExtractor;
        }
        if (JandexBuilders.isBoolean(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, BooleanValueConverter.JANDEX_BOOLEAN_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, BooleanValueExtractor.JANDEX_BOOLEAN_EXTRACTOR);
            return BooleanValueExtractor.JANDEX_BOOLEAN_EXTRACTOR;
        }
        if (JandexBuilders.isByte(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, ByteValueConverter.JANDEX_BYTE_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ByteValueExtractor.JANDEX_BYTE_EXTRACTOR);
            return ByteValueExtractor.JANDEX_BYTE_EXTRACTOR;
        }
        if (JandexBuilders.isChar(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, CharacterValueConverter.JANDEX_CHARACTER_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, CharacterValueExtractor.JANDEX_CHARACTER_EXTRACTOR);
            return CharacterValueExtractor.JANDEX_CHARACTER_EXTRACTOR;
        }
        if (JandexBuilders.isDouble(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, DoubleValueConverter.JANDEX_DOUBLE_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, DoubleValueExtractor.JANDEX_DOUBLE_EXTRACTOR);
            return (JandexValueExtractor)((Object)DoubleValueConverter.JANDEX_DOUBLE_VALUE_WRAPPER);
        }
        if (JandexBuilders.isFloat(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, FloatValueConverter.JANDEX_FLOAT_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, FloatValueExtractor.JANDEX_FLOAT_EXTRACTOR);
            return FloatValueExtractor.JANDEX_FLOAT_EXTRACTOR;
        }
        if (JandexBuilders.isInt(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, IntegerValueConverter.JANDEX_INTEGER_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, IntegerValueExtractor.JANDEX_INTEGER_EXTRACTOR);
            return IntegerValueExtractor.JANDEX_INTEGER_EXTRACTOR;
        }
        if (JandexBuilders.isLong(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, LongValueConverter.JANDEX_LONG_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, LongValueExtractor.JANDEX_LONG_EXTRACTOR);
            return LongValueExtractor.JANDEX_LONG_EXTRACTOR;
        }
        if (JandexBuilders.isShort(valueTypeDescriptor)) {
            converterCollector.accept(valueTypeDescriptor, ShortValueConverter.JANDEX_SHORT_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ShortValueExtractor.JANDEX_SHORT_EXTRACTOR);
            return ShortValueExtractor.JANDEX_SHORT_EXTRACTOR;
        }
        if (valueTypeDescriptor.getValueType() == String.class) {
            converterCollector.accept(valueTypeDescriptor, StringValueConverter.JANDEX_STRING_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, StringValueExtractor.JANDEX_STRING_EXTRACTOR);
            return StringValueExtractor.JANDEX_STRING_EXTRACTOR;
        }
        if (valueTypeDescriptor.getValueType().isAnnotation()) {
            AnnotationDescriptor annotationDescriptor = buildingContext.getAnnotationDescriptorRegistry().getDescriptor(valueTypeDescriptor.getValueType());
            JandexNestedValueConverter jandexNestedValueConverter = new JandexNestedValueConverter(annotationDescriptor);
            JandexNestedValueExtractor jandexNestedValueExtractor = new JandexNestedValueExtractor(jandexNestedValueConverter);
            converterCollector.accept(valueTypeDescriptor, jandexNestedValueConverter);
            extractorCollector.accept(valueTypeDescriptor, jandexNestedValueExtractor);
            return jandexNestedValueExtractor;
        }
        if (valueTypeDescriptor.getValueType().isEnum()) {
            EnumValueConverter converter = new EnumValueConverter(valueTypeDescriptor.getValueType());
            EnumValueExtractor extractor = new EnumValueExtractor(converter);
            converterCollector.accept(valueTypeDescriptor, converter);
            extractorCollector.accept(valueTypeDescriptor, extractor);
            return extractor;
        }
        if (valueTypeDescriptor.getValueType() == Class.class) {
            converterCollector.accept(valueTypeDescriptor, ClassValueConverter.JANDEX_CLASS_VALUE_WRAPPER);
            extractorCollector.accept(valueTypeDescriptor, ClassValueExtractor.JANDEX_CLASS_EXTRACTOR);
            return ClassValueExtractor.JANDEX_CLASS_EXTRACTOR;
        }
        throw new UnsupportedOperationException("Unhandled value type : " + valueTypeDescriptor);
    }

    private static <V> boolean isBoolean(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Boolean.TYPE || valueTypeDescriptor.getValueType() == Boolean.class;
    }

    private static <V> boolean isByte(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Byte.TYPE || valueTypeDescriptor.getValueType() == Byte.class;
    }

    private static <V> boolean isChar(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Character.TYPE || valueTypeDescriptor.getValueType() == Character.class;
    }

    private static <V> boolean isDouble(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Double.TYPE || valueTypeDescriptor.getValueType() == Double.class;
    }

    private static <V> boolean isFloat(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Float.TYPE || valueTypeDescriptor.getValueType() == Float.class;
    }

    private static <V> boolean isShort(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Short.TYPE || valueTypeDescriptor.getValueType() == Short.class;
    }

    private static <V> boolean isInt(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Integer.TYPE || valueTypeDescriptor.getValueType() == Integer.class;
    }

    private static <V> boolean isLong(ValueTypeDescriptor<V> valueTypeDescriptor) {
        return valueTypeDescriptor.getValueType() == Long.TYPE || valueTypeDescriptor.getValueType() == Long.class;
    }
}

