/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import org.hibernate.models.jandex.spi.JandexValueConverter;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationValue;

public class EnumValueConverter<E extends Enum<E>>
implements JandexValueConverter<E> {
    private final Class<E> enumClass;

    public EnumValueConverter(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public E convert(AnnotationValue jandexValue, SourceModelBuildingContext modelContext) {
        assert (jandexValue != null);
        String enumName = jandexValue.asEnum();
        return Enum.valueOf(this.enumClass, enumName);
    }
}

